/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.meta.wartermark;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Map;
import java.util.Optional;

public class WatermarkEvent {
    public static final String WATERMARK_SIGNAL = "_split_watermark_signal_";
    public static final String SPLIT_ID_KEY = "split_id";
    public static final String WATERMARK_KIND = "watermark_kind";
    public static final String SIGNAL_EVENT_KEY_SCHEMA_NAME = "io.debezium.connector.flink.cdc.embedded.watermark.key";
    public static final String SIGNAL_EVENT_VALUE_SCHEMA_NAME = "io.debezium.connector.flink.cdc.embedded.watermark.value";
    private static final SchemaNameAdjuster SCHEMA_NAME_ADJUSTER = SchemaNameAdjuster.create();
    private static final Schema SIGNAL_EVENT_KEY_SCHEMA = SchemaBuilder.struct().name(SCHEMA_NAME_ADJUSTER.adjust("io.debezium.connector.flink.cdc.embedded.watermark.key")).field("split_id", Schema.STRING_SCHEMA).field("_split_watermark_signal_", Schema.BOOLEAN_SCHEMA).build();
    private static final Schema SIGNAL_EVENT_VALUE_SCHEMA = SchemaBuilder.struct().name(SCHEMA_NAME_ADJUSTER.adjust("io.debezium.connector.flink.cdc.embedded.watermark.value")).field("split_id", Schema.STRING_SCHEMA).field("watermark_kind", Schema.STRING_SCHEMA).build();

    public static SourceRecord create(Map<String, ?> sourcePartition, String topic, String splitId, WatermarkKind watermarkKind, Offset watermark) {
        return new SourceRecord(sourcePartition, watermark.getOffset(), topic, SIGNAL_EVENT_KEY_SCHEMA, WatermarkEvent.signalRecordKey(splitId), SIGNAL_EVENT_VALUE_SCHEMA, WatermarkEvent.signalRecordValue(splitId, watermarkKind));
    }

    public static boolean isWatermarkEvent(SourceRecord record) {
        Optional<WatermarkKind> watermarkKind = WatermarkEvent.getWatermarkKind(record);
        return watermarkKind.isPresent();
    }

    public static boolean isLowWatermarkEvent(SourceRecord record) {
        Optional<WatermarkKind> watermarkKind = WatermarkEvent.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == WatermarkKind.LOW;
    }

    public static boolean isHighWatermarkEvent(SourceRecord record) {
        Optional<WatermarkKind> watermarkKind = WatermarkEvent.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == WatermarkKind.HIGH;
    }

    public static boolean isEndWatermarkEvent(SourceRecord record) {
        Optional<WatermarkKind> watermarkKind = WatermarkEvent.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == WatermarkKind.END;
    }

    private static Optional<WatermarkKind> getWatermarkKind(SourceRecord record) {
        if (record.valueSchema() != null && SIGNAL_EVENT_VALUE_SCHEMA_NAME.equals(record.valueSchema().name())) {
            Struct value = (Struct)record.value();
            return Optional.of(WatermarkKind.valueOf(value.getString(WATERMARK_KIND)));
        }
        return Optional.empty();
    }

    private static Struct signalRecordKey(String splitId) {
        Struct result = new Struct(SIGNAL_EVENT_KEY_SCHEMA);
        result.put(SPLIT_ID_KEY, (Object)splitId);
        result.put(WATERMARK_SIGNAL, (Object)true);
        return result;
    }

    private static Struct signalRecordValue(String splitId, WatermarkKind watermarkKind) {
        Struct result = new Struct(SIGNAL_EVENT_VALUE_SCHEMA);
        result.put(SPLIT_ID_KEY, (Object)splitId);
        result.put(WATERMARK_KIND, (Object)watermarkKind.toString());
        return result;
    }
}

