/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.utils;

import io.debezium.DebeziumException;
import io.debezium.relational.TableId;
import io.debezium.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializerUtils {
    private SerializerUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String rowToSerializedString(Object[] splitBoundary) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(splitBoundary);
                string = HexConverter.convertToHexString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize split boundary information %s", splitBoundary));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String rowToSerializedString(Object splitBoundary) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(splitBoundary);
                string = HexConverter.convertToHexString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize split boundary information %s", splitBoundary));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object[] serializedStringToRow(String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex(serialized));){
            Object[] objectArray;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                objectArray = (Object[])ois.readObject();
            }
            return objectArray;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize split boundary with value '%s'", serialized), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object serializedStringToObject(String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex(serialized));){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                object = ois.readObject();
            }
            return object;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize split boundary with value '%s'", serialized), e);
        }
    }

    public static boolean shouldUseCatalogBeforeSchema(TableId tableId) {
        return tableId.catalog() != null || tableId.schema() == null;
    }
}

