/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class BrokerHeartbeatResponse
extends AbstractResponse {
    private final BrokerHeartbeatResponseData data;

    public BrokerHeartbeatResponse(BrokerHeartbeatResponseData data) {
        super(ApiKeys.BROKER_HEARTBEAT);
        this.data = data;
    }

    @Override
    public BrokerHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        errorCounts.put(Errors.forCode(this.data.errorCode()), 1);
        return errorCounts;
    }

    public static BrokerHeartbeatResponse parse(ByteBuffer buffer, short version) {
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }
}

