/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.sqlserver.source.dialect;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import com.ververica.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.sqlserver.source.config.SqlServerSourceConfig;
import com.ververica.cdc.connectors.sqlserver.source.config.SqlServerSourceConfigFactory;
import com.ververica.cdc.connectors.sqlserver.source.dialect.SqlServerChunkSplitter;
import com.ververica.cdc.connectors.sqlserver.source.dialect.SqlServerPooledDataSourceFactory;
import com.ververica.cdc.connectors.sqlserver.source.dialect.SqlServerSchema;
import com.ververica.cdc.connectors.sqlserver.source.offset.LsnOffset;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerScanFetchTask;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerStreamFetchTask;
import com.ververica.cdc.connectors.sqlserver.source.utils.SqlServerConnectionUtils;
import com.ververica.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public class SqlServerDialect
implements JdbcDataSourceDialect {
    private static final long serialVersionUID = 1L;
    private final SqlServerSourceConfigFactory configFactory;
    private final SqlServerSourceConfig sourceConfig;
    private transient SqlServerSchema sqlserverSchema;

    public SqlServerDialect(SqlServerSourceConfigFactory configFactory) {
        this.configFactory = configFactory;
        this.sourceConfig = configFactory.create(0);
    }

    @Override
    public String getName() {
        return "SqlServer";
    }

    @Override
    public Offset displayCurrentOffset(JdbcSourceConfig sourceConfig) {
        LsnOffset lsnOffset;
        block8: {
            JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);
            try {
                lsnOffset = SqlServerUtils.currentLsn((SqlServerConnection)jdbcConnection);
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Read the redoLog offset error", (Throwable)e);
                }
            }
            jdbcConnection.close();
        }
        return lsnOffset;
    }

    @Override
    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        return true;
    }

    @Override
    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return SqlServerConnectionUtils.createSqlServerConnection(sourceConfig.getDbzConnectorConfig());
    }

    @Override
    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new SqlServerChunkSplitter(sourceConfig, this);
    }

    @Override
    public JdbcConnectionPoolFactory getPooledDataSourceFactory() {
        return new SqlServerPooledDataSourceFactory();
    }

    @Override
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        List<TableId> list;
        block8: {
            SqlServerSourceConfig sqlserverSourceConfig = (SqlServerSourceConfig)sourceConfig;
            JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);
            try {
                list = SqlServerConnectionUtils.listTables(jdbcConnection, sqlserverSourceConfig.getTableFilters());
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FlinkRuntimeException("Error to discover tables: " + e.getMessage(), (Throwable)e);
                }
            }
            jdbcConnection.close();
        }
        return list;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> discoverDataCollectionSchemas(JdbcSourceConfig sourceConfig) {
        HashMap<TableId, TableChanges.TableChange> hashMap;
        block9: {
            List<TableId> capturedTableIds = this.discoverDataCollections(sourceConfig);
            SqlServerConnection jdbc = SqlServerConnectionUtils.createSqlServerConnection(sourceConfig.getDbzConnectorConfig());
            try {
                HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
                for (TableId tableId : capturedTableIds) {
                    TableChanges.TableChange tableSchema = this.queryTableSchema(jdbc, tableId);
                    tableSchemas.put(tableId, tableSchema);
                }
                hashMap = tableSchemas;
                if (jdbc == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbc != null) {
                        try {
                            jdbc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Error to discover table schemas: " + e.getMessage(), (Throwable)e);
                }
            }
            jdbc.close();
        }
        return hashMap;
    }

    @Override
    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.sqlserverSchema == null) {
            this.sqlserverSchema = new SqlServerSchema();
        }
        return this.sqlserverSchema.getTableSchema(jdbc, tableId);
    }

    @Override
    public SqlServerSourceFetchTaskContext createFetchTaskContext(SourceSplitBase sourceSplitBase, JdbcSourceConfig taskSourceConfig) {
        SqlServerConnection jdbcConnection = SqlServerConnectionUtils.createSqlServerConnection(this.sourceConfig.getDbzConnectorConfig());
        SqlServerConnection metaDataConnection = SqlServerConnectionUtils.createSqlServerConnection(this.sourceConfig.getDbzConnectorConfig());
        return new SqlServerSourceFetchTaskContext(taskSourceConfig, this, jdbcConnection, metaDataConnection);
    }

    @Override
    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new SqlServerScanFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new SqlServerStreamFetchTask(sourceSplitBase.asStreamSplit());
    }
}

