/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler;

import com.xxl.crawler.pageloader.PageLoader;
import com.xxl.crawler.pageparser.PageParser;
import com.xxl.crawler.proxy.ProxyPool;
import com.xxl.crawler.runconf.RunConf;
import com.xxl.crawler.rundata.RunUrlPool;
import com.xxl.crawler.rundata.strategy.LocalRunUrlPool;
import com.xxl.crawler.thread.CrawlerThread;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlCrawler {
    private static Logger logger = LoggerFactory.getLogger(XxlCrawler.class);
    private volatile RunUrlPool runUrlPool = new LocalRunUrlPool();
    private volatile RunConf runConf = new RunConf();
    private volatile int threadCount = 1;
    private volatile ExecutorService crawlers = Executors.newCachedThreadPool();
    private volatile List<CrawlerThread> crawlerThreads = new CopyOnWriteArrayList<CrawlerThread>();

    public RunUrlPool getRunUrlPool() {
        return this.runUrlPool;
    }

    public RunConf getRunConf() {
        return this.runConf;
    }

    public void start(boolean sync) {
        if (this.runUrlPool == null) {
            throw new RuntimeException("xxl crawler runUrlPool can not be null.");
        }
        if (this.runUrlPool.getUrlNum() <= 0) {
            throw new RuntimeException("xxl crawler indexUrl can not be empty.");
        }
        if (this.runConf == null) {
            throw new RuntimeException("xxl crawler runConf can not be empty.");
        }
        if (this.threadCount < 1 || this.threadCount > 1000) {
            throw new RuntimeException("xxl crawler threadCount invalid, threadCount : " + this.threadCount);
        }
        if (this.runConf.getPageLoader() == null) {
            throw new RuntimeException("xxl crawler pageLoader can not be null.");
        }
        if (this.runConf.getPageParser() == null) {
            throw new RuntimeException("xxl crawler pageParser can not be null.");
        }
        if (this.runConf.getTimeoutMillis() <= 0 || this.runConf.getTimeoutMillis() > 300000) {
            throw new RuntimeException("xxl crawler timeoutMillis invalid.");
        }
        if (this.runConf.getPauseMillis() < 0 || this.runConf.getPauseMillis() > 600000) {
            throw new RuntimeException("xxl crawler pauseMillis invalid.");
        }
        if (this.runConf.getFailRetryCount() < 0 || this.runConf.getFailRetryCount() > 100) {
            throw new RuntimeException("xxl crawler failRetryCount invalid.");
        }
        logger.info(">>>>>>>>>>> xxl crawler start ...");
        for (int i = 0; i < this.threadCount; ++i) {
            CrawlerThread crawlerThread = new CrawlerThread(this);
            this.crawlerThreads.add(crawlerThread);
        }
        for (CrawlerThread crawlerThread : this.crawlerThreads) {
            this.crawlers.execute(crawlerThread);
        }
        this.crawlers.shutdown();
        if (sync) {
            try {
                while (!this.crawlers.awaitTermination(5L, TimeUnit.SECONDS)) {
                    logger.info(">>>>>>>>>>> xxl crawler still running ...");
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void tryFinish() {
        boolean isEnd;
        boolean isRunning = false;
        for (CrawlerThread crawlerThread : this.crawlerThreads) {
            if (!crawlerThread.isRunning()) continue;
            isRunning = true;
            break;
        }
        boolean bl = isEnd = this.runUrlPool.getUrlNum() == 0 && !isRunning;
        if (isEnd) {
            this.stop();
        }
    }

    public void stop() {
        for (CrawlerThread crawlerThread : this.crawlerThreads) {
            crawlerThread.toStop();
        }
        this.crawlers.shutdownNow();
        logger.info(">>>>>>>>>>> xxl crawler stop.");
    }

    public static class Builder {
        private XxlCrawler crawler = new XxlCrawler();

        public Builder setRunUrlPool(RunUrlPool runData) {
            this.crawler.runUrlPool = runData;
            return this;
        }

        public Builder setUrls(String ... urls) {
            if (urls != null && urls.length > 0) {
                for (String url : urls) {
                    this.crawler.runUrlPool.addUrl(url, false);
                }
            }
            return this;
        }

        public Builder setWhiteUrlRegexs(String ... whiteUrlRegexs) {
            if (whiteUrlRegexs != null && whiteUrlRegexs.length > 0) {
                for (String whiteUrlRegex : whiteUrlRegexs) {
                    this.crawler.runUrlPool.addWhiteUrlRegex(whiteUrlRegex);
                }
            }
            return this;
        }

        public Builder setAllowSpread(boolean allowSpread) {
            this.crawler.runConf.setAllowSpread(allowSpread);
            return this;
        }

        public Builder setPageLoader(PageLoader pageLoader) {
            this.crawler.runConf.setPageLoader(pageLoader);
            return this;
        }

        public Builder setPageParser(PageParser pageParser) {
            this.crawler.runConf.setPageParser(pageParser);
            return this;
        }

        public Builder setParamMap(Map<String, String> paramMap) {
            this.crawler.runConf.setParamMap(paramMap);
            return this;
        }

        public Builder setHeaderMap(Map<String, String> headerMap) {
            this.crawler.runConf.setHeaderMap(headerMap);
            return this;
        }

        public Builder setCookieMap(Map<String, String> cookieMap) {
            this.crawler.runConf.setCookieMap(cookieMap);
            return this;
        }

        public Builder setUserAgent(String ... userAgents) {
            if (userAgents != null && userAgents.length > 0) {
                for (String userAgent : userAgents) {
                    if (this.crawler.runConf.getUserAgentList().contains(userAgent)) continue;
                    this.crawler.runConf.getUserAgentList().add(userAgent);
                }
            }
            return this;
        }

        public Builder setReferrer(String referrer) {
            this.crawler.runConf.setReferrer(referrer);
            return this;
        }

        public Builder setIfPost(boolean ifPost) {
            this.crawler.runConf.setIfPost(ifPost);
            return this;
        }

        public Builder setTimeoutMillis(int timeoutMillis) {
            this.crawler.runConf.setTimeoutMillis(timeoutMillis);
            return this;
        }

        public Builder setValidateTLSCertificates(boolean validateTLSCertificates) {
            this.crawler.runConf.setValidateTLSCertificates(validateTLSCertificates);
            return this;
        }

        public Builder setProxyPool(ProxyPool proxyPool) {
            this.crawler.runConf.setProxyPool(proxyPool);
            return this;
        }

        public Builder setPauseMillis(int pauseMillis) {
            this.crawler.runConf.setPauseMillis(pauseMillis);
            return this;
        }

        public Builder setFailRetryCount(int failRetryCount) {
            if (failRetryCount > 0) {
                this.crawler.runConf.setFailRetryCount(failRetryCount);
            }
            return this;
        }

        public Builder setThreadCount(int threadCount) {
            this.crawler.threadCount = threadCount;
            return this;
        }

        public XxlCrawler build() {
            return this.crawler;
        }
    }
}

