/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.pageloader.strategy;

import com.xxl.crawler.exception.XxlCrawlerException;
import com.xxl.crawler.pageloader.PageLoader;
import com.xxl.crawler.pageloader.param.Request;
import com.xxl.crawler.util.FileUtil;
import com.xxl.crawler.util.UrlUtil;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumChromePageLoader
extends PageLoader {
    private static Logger logger = LoggerFactory.getLogger(SeleniumChromePageLoader.class);
    private final String driverPath;

    public SeleniumChromePageLoader(String driverPath) {
        this.driverPath = driverPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document load(Request request) {
        if (!UrlUtil.isUrl(request.getUrl())) {
            return null;
        }
        if (!FileUtil.exists(this.driverPath)) {
            throw new XxlCrawlerException("webdriver.chrome.driver not found.");
        }
        System.setProperty("webdriver.chrome.driver", this.driverPath);
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--headless"});
        if (request.getUserAgent() != null) {
            chromeOptions.addArguments(new String[]{"--user-agent=" + request.getUserAgent()});
        } else {
            chromeOptions.addArguments(new String[]{"--user-agent=Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36"});
        }
        if (request.isValidateTLSCertificates()) {
            chromeOptions.addArguments(new String[]{"--ignore-certificate-errors"});
        }
        if (request.getProxy() != null) {
            chromeOptions.setCapability("proxy", (Object)request.getProxy());
        }
        ChromeDriver webDriver = new ChromeDriver(chromeOptions);
        if (request.getReferrer() != null && !request.getReferrer().isEmpty()) {
            ((JavascriptExecutor)webDriver).executeScript("document.referrer = '" + request.getReferrer() + "';", new Object[0]);
        }
        try {
            if (request.getCookieMap() != null && !request.getCookieMap().isEmpty()) {
                for (Map.Entry<String, String> item : request.getCookieMap().entrySet()) {
                    Cookie cookie = new Cookie.Builder(item.getKey(), item.getValue()).domain(request.getUrl()).path("/").expiresOn(new Date(System.currentTimeMillis() + 0x6DDD00L)).isSecure(false).isHttpOnly(true).build();
                    webDriver.manage().addCookie(cookie);
                }
                webDriver.navigate().refresh();
            }
            webDriver.get(request.getUrl());
            webDriver.manage().timeouts().implicitlyWait((long)request.getTimeoutMillis(), TimeUnit.MILLISECONDS);
            webDriver.manage().timeouts().pageLoadTimeout((long)request.getTimeoutMillis(), TimeUnit.MILLISECONDS);
            webDriver.manage().timeouts().setScriptTimeout((long)request.getTimeoutMillis(), TimeUnit.MILLISECONDS);
            String pageSource = webDriver.getPageSource();
            if (pageSource != null) {
                Document html;
                Document document = html = Jsoup.parse((String)pageSource);
                return document;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            webDriver.quit();
        }
        return null;
    }
}

