/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.rundata;

import com.xxl.crawler.util.RegexUtil;
import com.xxl.crawler.util.UrlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class RunUrlPool {
    private Set<String> whiteUrlRegexs = Collections.synchronizedSet(new HashSet());

    public void addWhiteUrlRegex(String whiteUrlRegex) {
        this.whiteUrlRegexs.add(whiteUrlRegex);
    }

    public boolean validUrlRegex(String url) {
        if (!UrlUtil.isUrl(url)) {
            return false;
        }
        if (this.whiteUrlRegexs != null && !this.whiteUrlRegexs.isEmpty()) {
            boolean underWhiteUrl = false;
            for (String whiteRegex : this.whiteUrlRegexs) {
                if (!RegexUtil.matches(whiteRegex, url)) continue;
                underWhiteUrl = true;
            }
            if (!underWhiteUrl) {
                return false;
            }
        }
        return true;
    }

    public abstract boolean addUrl(String var1, boolean var2);

    public abstract String getUrl();

    public abstract int getUrlNum();
}

