/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.rundata.strategy;

import com.xxl.crawler.rundata.RunUrlPool;
import com.xxl.crawler.util.UrlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRunUrlPool
extends RunUrlPool {
    private static Logger logger = LoggerFactory.getLogger(LocalRunUrlPool.class);
    private volatile LinkedBlockingQueue<String> unVisitedUrlQueue = new LinkedBlockingQueue();
    private volatile Set<String> visitedUrlSet = Collections.synchronizedSet(new HashSet());

    @Override
    public boolean addUrl(String url, boolean validUrlRegex) {
        if (!UrlUtil.isUrl(url)) {
            logger.debug(">>>>>>>>>>> xxl-crawler isUrl fail, url not valid: {}", (Object)url);
            return false;
        }
        if (validUrlRegex && !this.validUrlRegex(url)) {
            logger.debug(">>>>>>>>>>> xxl-crawler validUrlRegex fail, url not valid: {}", (Object)url);
            return false;
        }
        if (this.visitedUrlSet.contains(url) || this.unVisitedUrlQueue.contains(url)) {
            logger.debug(">>>>>>>>>>> xxl-crawler addUrl fail, url repeate: {}", (Object)url);
            return false;
        }
        this.unVisitedUrlQueue.add(url);
        logger.info(">>>>>>>>>>> xxl-crawler addUrl success, url: {}", (Object)url);
        return true;
    }

    @Override
    public String getUrl() {
        String link = null;
        try {
            link = this.unVisitedUrlQueue.take();
        }
        catch (InterruptedException e) {
            logger.debug(">>>>>>>>>>> xxl-crawler getUrl interrupted.");
        }
        if (link != null) {
            this.visitedUrlSet.add(link);
        }
        return link;
    }

    @Override
    public int getUrlNum() {
        return this.unVisitedUrlQueue.size();
    }
}

