/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.thread;

import com.xxl.crawler.XxlCrawler;
import com.xxl.crawler.annotation.PageFieldSelect;
import com.xxl.crawler.annotation.PageSelect;
import com.xxl.crawler.constant.Const;
import com.xxl.crawler.exception.XxlCrawlerException;
import com.xxl.crawler.pageloader.param.Request;
import com.xxl.crawler.pageloader.param.Response;
import com.xxl.crawler.util.FieldReflectionUtil;
import com.xxl.crawler.util.JsoupUtil;
import com.xxl.crawler.util.UrlUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerThread
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(CrawlerThread.class);
    private final XxlCrawler crawler;
    private volatile boolean running;
    private volatile boolean toStop;

    public CrawlerThread(XxlCrawler crawler) {
        this.crawler = crawler;
        this.running = true;
        this.toStop = false;
    }

    public void toStop() {
        this.toStop = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        block6: while (!this.toStop) {
            try {
                this.running = false;
                this.crawler.tryFinish();
                String link = this.crawler.getRunUrlPool().getUrl();
                this.running = true;
                if (!UrlUtil.isUrl(link)) continue;
                logger.info(">>>>>>>>>>> xxl crawler, process link : {}", (Object)link);
                int runCount = this.crawler.getRunConf().getFailRetryCount() + 1;
                for (int i = 0; i < runCount; ++i) {
                    Response response = null;
                    try {
                        Request request = this.buildRequest(link);
                        this.crawler.getRunConf().getPageParser().preParse(request);
                        response = this.loadAndParsePage(request);
                        if (response.isSuccess()) {
                            this.crawler.getRunConf().getPageParser().afterParse(response);
                        } else {
                            this.crawler.getRunConf().getPageParser().afterParseFail(response);
                        }
                    }
                    catch (Throwable e) {
                        logger.error(">>>>>>>>>>> xxl crawler proocess error.", e);
                    }
                    if (this.crawler.getRunConf().getPauseMillis() > 0) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(this.crawler.getRunConf().getPauseMillis());
                        }
                        catch (InterruptedException e) {
                            logger.error(">>>>>>>>>>> xxl crawler thread is interrupted. {}", (Object)e.getMessage());
                        }
                    }
                    if (response != null && response.isSuccess()) continue block6;
                }
            }
            catch (Throwable e) {
                if (e instanceof XxlCrawlerException) {
                    logger.error(">>>>>>>>>>> xxl crawler thread {}", (Object)e.getMessage(), (Object)e);
                    continue;
                }
                logger.error(e.getMessage(), e);
            }
        }
    }

    private Request buildRequest(String url) {
        String userAgent = this.crawler.getRunConf().getUserAgentList().size() > 1 ? this.crawler.getRunConf().getUserAgentList().get(new Random().nextInt(this.crawler.getRunConf().getUserAgentList().size())) : (this.crawler.getRunConf().getUserAgentList().size() == 1 ? this.crawler.getRunConf().getUserAgentList().get(0) : null);
        Proxy proxy = null;
        if (this.crawler.getRunConf().getProxyPool() != null) {
            proxy = this.crawler.getRunConf().getProxyPool().getProxy();
        }
        Request pageRequest = new Request();
        pageRequest.setUrl(url);
        pageRequest.setParamMap(this.crawler.getRunConf().getParamMap());
        pageRequest.setHeaderMap(this.crawler.getRunConf().getHeaderMap());
        pageRequest.setCookieMap(this.crawler.getRunConf().getCookieMap());
        pageRequest.setUserAgent(userAgent);
        pageRequest.setReferrer(this.crawler.getRunConf().getReferrer());
        pageRequest.setIfPost(this.crawler.getRunConf().isIfPost());
        pageRequest.setTimeoutMillis(this.crawler.getRunConf().getTimeoutMillis());
        pageRequest.setValidateTLSCertificates(this.crawler.getRunConf().isValidateTLSCertificates());
        pageRequest.setProxy(proxy);
        return pageRequest;
    }

    private Response loadAndParsePage(Request request) throws IllegalAccessException, InstantiationException {
        Set<String> urlSet;
        Document html = null;
        try {
            html = this.crawler.getRunConf().getPageLoader().load(request);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (html == null) {
            return new Response(request, false, null, null, new ArrayList());
        }
        if (this.crawler.getRunConf().isAllowSpread() && (urlSet = JsoupUtil.findLinks(html)) != null && !urlSet.isEmpty()) {
            for (String item : urlSet) {
                this.crawler.getRunUrlPool().addUrl(item, true);
            }
        }
        if (!this.crawler.getRunUrlPool().validUrlRegex(request.getUrl())) {
            return new Response(request, true, html, null, new ArrayList());
        }
        Class pageVoClassType = Object.class;
        Type pageVoParserClass = this.crawler.getRunConf().getPageParser().getClass().getGenericSuperclass();
        if (pageVoParserClass instanceof ParameterizedType) {
            Type[] pageVoClassTypes = ((ParameterizedType)pageVoParserClass).getActualTypeArguments();
            pageVoClassType = (Class)pageVoClassTypes[0];
        }
        ArrayList<Element> parseElementList = new ArrayList<Element>();
        ArrayList parseVoList = new ArrayList();
        PageSelect pageVoSelect = pageVoClassType.getAnnotation(PageSelect.class);
        String pageVoCssQuery = pageVoSelect != null && pageVoSelect.cssQuery() != null && pageVoSelect.cssQuery().trim().length() > 0 ? pageVoSelect.cssQuery() : "html";
        Elements pageVoElements = html.select(pageVoCssQuery);
        if (pageVoElements != null && !pageVoElements.isEmpty()) {
            for (Element pageVoElement : pageVoElements) {
                Object pageVo = pageVoClassType.newInstance();
                Field[] fields = pageVoClassType.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    for (Field field : fields) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        PageFieldSelect fieldSelect = field.getAnnotation(PageFieldSelect.class);
                        String cssQuery = null;
                        Const.SelectType selectType = null;
                        String selectVal = null;
                        if (fieldSelect != null) {
                            cssQuery = fieldSelect.cssQuery();
                            selectType = fieldSelect.selectType();
                            selectVal = fieldSelect.selectVal();
                        }
                        if (cssQuery == null || cssQuery.trim().isEmpty()) continue;
                        ArrayList<Object> fieldValue = null;
                        if (field.getGenericType() instanceof ParameterizedType) {
                            Elements fieldElementList;
                            ParameterizedType fieldGenericType = (ParameterizedType)field.getGenericType();
                            if (fieldGenericType.getRawType().equals(List.class) && (fieldElementList = pageVoElement.select(cssQuery)) != null && !fieldElementList.isEmpty()) {
                                ArrayList<Object> fieldValueTmp = new ArrayList<Object>();
                                for (Element fieldElement : fieldElementList) {
                                    String fieldElementOrigin = JsoupUtil.parseElement(fieldElement, selectType, selectVal);
                                    if (fieldElementOrigin == null || fieldElementOrigin.length() == 0) continue;
                                    try {
                                        fieldValueTmp.add(FieldReflectionUtil.parseValue(field, fieldElementOrigin));
                                    }
                                    catch (Exception e) {
                                        logger.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (!fieldValueTmp.isEmpty()) {
                                    fieldValue = fieldValueTmp;
                                }
                            }
                        } else {
                            Elements fieldElements = pageVoElement.select(cssQuery);
                            String fieldValueOrigin = null;
                            if (fieldElements != null && !fieldElements.isEmpty()) {
                                fieldValueOrigin = JsoupUtil.parseElement((Element)fieldElements.get(0), selectType, selectVal);
                            }
                            if (fieldValueOrigin == null || fieldValueOrigin.length() == 0) continue;
                            try {
                                fieldValue = FieldReflectionUtil.parseValue(field, fieldValueOrigin);
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (fieldValue == null) continue;
                        field.setAccessible(true);
                        field.set(pageVo, fieldValue);
                    }
                }
                parseElementList.add(pageVoElement);
                parseVoList.add(pageVo);
            }
        }
        return new Response(request, true, html, parseElementList, parseVoList);
    }
}

