/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.util;

import com.xxl.crawler.annotation.PageFieldSelect;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class FieldReflectionUtil {
    private FieldReflectionUtil() {
    }

    public static Byte parseByte(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseByte but input illegal input=" + value, e);
        }
    }

    public static Boolean parseBoolean(String value) {
        value = value.replaceAll("\u3000", "");
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("parseBoolean but input illegal input=" + value);
    }

    public static Integer parseInt(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseInt but input illegal input=" + value, e);
        }
    }

    public static Short parseShort(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseShort but input illegal input=" + value, e);
        }
    }

    public static Long parseLong(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseLong but input illegal input=" + value, e);
        }
    }

    public static Float parseFloat(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseFloat but input illegal input=" + value, e);
        }
    }

    public static Double parseDouble(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("parseDouble but input illegal input=" + value, e);
        }
    }

    public static Date parseDate(PageFieldSelect apiRequestParam, String value) {
        try {
            String datePattern = "yyyy-MM-dd HH:mm:ss";
            if (apiRequestParam != null) {
                datePattern = apiRequestParam.datePattern();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("parseDate but input illegal input=" + value, e);
        }
    }

    public static Object parseValue(Field field, String value) {
        ParameterizedType fieldGenericType;
        Class fieldType = field.getType();
        if (field.getGenericType() instanceof ParameterizedType && (fieldGenericType = (ParameterizedType)field.getGenericType()).getRawType().equals(List.class)) {
            Type gtATA = fieldGenericType.getActualTypeArguments()[0];
            fieldType = (Class)gtATA;
        }
        PageFieldSelect apiRequestParam = field.getAnnotation(PageFieldSelect.class);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        value = value.trim();
        if (Byte.class.equals((Object)fieldType) || Byte.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseByte(value);
        }
        if (Boolean.class.equals((Object)fieldType) || Boolean.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseBoolean(value);
        }
        if (String.class.equals((Object)fieldType)) {
            return value;
        }
        if (Short.class.equals((Object)fieldType) || Short.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseShort(value);
        }
        if (Integer.class.equals((Object)fieldType) || Integer.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseInt(value);
        }
        if (Long.class.equals((Object)fieldType) || Long.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseLong(value);
        }
        if (Float.class.equals((Object)fieldType) || Float.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseFloat(value);
        }
        if (Double.class.equals((Object)fieldType) || Double.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseDouble(value);
        }
        if (Date.class.equals((Object)fieldType)) {
            return FieldReflectionUtil.parseDate(apiRequestParam, value);
        }
        throw new RuntimeException("request illeagal type, type must be Integer not int Long not long etc, type=" + fieldType);
    }
}

