/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static String getFileNameByUrl(String url, String contentType) {
        url = url.replaceAll("[\\?/:*|<>\"]", "_");
        if (contentType != null && contentType.lastIndexOf("/") > -1) {
            url = url + "." + contentType.substring(contentType.lastIndexOf("/") + 1);
        }
        return url;
    }

    public static void saveFile(String fileData, String filePath, String fileName) {
        File filePathDir = new File(filePath);
        if (!filePathDir.exists()) {
            filePathDir.mkdirs();
        }
        File file = new File(filePathDir, fileName);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(fileData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean downFile(String fileUrl, int timeoutMillis, String filePath, String fileName) {
        File filePathDir = new File(filePath);
        if (!filePathDir.exists()) {
            filePathDir.mkdirs();
        }
        Path outputPath = Paths.get(filePath, fileName);
        try {
            URL url = new URL(fileUrl);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(timeoutMillis);
            try (InputStream inputStream = connection.getInputStream();
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    bufferedOutputStream.write(buffer, 0, bytesRead);
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to download file from URL: " + fileUrl + " to path: " + outputPath, (Throwable)e);
            return false;
        }
    }

    public static boolean exists(String filePath) {
        return new File(filePath).exists();
    }
}

