/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.crawler.util;

import com.xxl.crawler.constant.Const;
import com.xxl.crawler.pageloader.param.Request;
import com.xxl.crawler.util.UrlUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupUtil {
    private static Logger logger = LoggerFactory.getLogger(JsoupUtil.class);

    public static Document load(Request request) {
        if (!UrlUtil.isUrl(request.getUrl())) {
            logger.debug("url is invalid, request=" + request.toString());
            return null;
        }
        try {
            Connection conn = Jsoup.connect((String)request.getUrl());
            if (request.getParamMap() != null && !request.getParamMap().isEmpty()) {
                conn.data(request.getParamMap());
            }
            if (request.getHeaderMap() != null && !request.getHeaderMap().isEmpty()) {
                conn.headers(request.getHeaderMap());
            }
            if (request.getCookieMap() != null && !request.getCookieMap().isEmpty()) {
                conn.cookies(request.getCookieMap());
            }
            if (request.getUserAgent() != null) {
                conn.userAgent(request.getUserAgent());
            }
            if (request.getReferrer() != null) {
                conn.referrer(request.getReferrer());
            }
            conn.method(request.isIfPost() ? Connection.Method.POST : Connection.Method.GET);
            conn.timeout(request.getTimeoutMillis());
            if (request.isValidateTLSCertificates()) {
                conn.sslSocketFactory(JsoupUtil.generateSSLSocketFactory());
            }
            conn.maxBodySize(0);
            conn.ignoreContentType(true);
            if (request.getProxy() != null) {
                conn.proxy(request.getProxy());
            }
            Connection.Response resp = conn.execute();
            Document document = resp.parse();
            return document;
        }
        catch (IOException e) {
            logger.error("jsoup load error, url={}, error:{}", new Object[]{request.getUrl(), e.getMessage(), e});
            return null;
        }
    }

    private static SSLSocketFactory generateSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory result = sslContext.getSocketFactory();
            return result;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create a SSL socket factory", e);
        }
    }

    public static String loadPageSource(Request request) {
        Document html = JsoupUtil.load(request);
        return html != null ? html.outerHtml() : null;
    }

    public static String parseElement(Element fieldElement, Const.SelectType selectType, String selectVal) {
        String fieldElementOrigin = null;
        fieldElementOrigin = Const.SelectType.HTML == selectType ? fieldElement.html() : (Const.SelectType.VAL == selectType ? fieldElement.val() : (Const.SelectType.TEXT == selectType ? fieldElement.text() : (Const.SelectType.ATTR == selectType ? fieldElement.attr(selectVal) : (Const.SelectType.HAS_CLASS == selectType ? String.valueOf(fieldElement.hasClass(selectVal)) : fieldElement.toString()))));
        return fieldElementOrigin;
    }

    public static Set<String> findLinks(Document html) {
        if (html == null) {
            return null;
        }
        Elements hrefElements = html.select("a[href]");
        HashSet<String> links = new HashSet<String>();
        if (hrefElements != null && !hrefElements.isEmpty()) {
            for (Element item : hrefElements) {
                String href = item.attr("abs:href");
                if (!UrlUtil.isUrl(href)) continue;
                links.add(href);
            }
        }
        return links;
    }

    public static Set<String> findImages(Document html) {
        Elements imgs = html.getElementsByTag("img");
        HashSet<String> images = new HashSet<String>();
        if (imgs != null && !imgs.isEmpty()) {
            for (Element element : imgs) {
                String imgSrc = element.attr("abs:src");
                images.add(imgSrc);
            }
        }
        return images;
    }
}

