/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.signer;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.exception.VerifySignFailedException;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.List;

public interface YopSigner {
    public List<String> supportSignerAlg();

    public void sign(Request<? extends BaseRequest> var1, YopCredentials<?> var2, SignOptions var3);

    default public void checkSignature(YopHttpResponse httpResponse, String signature, YopCredentials<?> credentials, SignOptions options) {
        String content = httpResponse.readContent();
        String requestId = httpResponse.getHeader("x-yop-request-id");
        YopPlatformCredentials platformCredentials = (YopPlatformCredentials)credentials;
        CertTypeEnum certType = ((CredentialsItem)platformCredentials.getCredential()).getCertType();
        content = content.replaceAll("[ \t\n]", "");
        if (!YopSignProcessorFactory.getSignProcessor(certType.name()).doVerify(content, signature, (CredentialsItem)platformCredentials.getCredential(), options)) {
            throw new VerifySignFailedException(String.format("response sign verify failure, content:%s, signature:%s, platformSerialNo:%s, requestId:%s.", content, signature, platformCredentials.getSerialNo(), requestId));
        }
    }
}

