/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.cert.parser;

import com.yeepay.yop.sdk.base.security.cert.X509CertSupportFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class AbstractYopPublicKeyParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected X509Certificate getX509Cert(String certPath, CertTypeEnum certType) throws CertificateException, NoSuchProviderException {
        InputStream certStream = null;
        try {
            certStream = FileUtils.getResourceAsStream(certPath);
            if (null == certStream) {
                throw new YopClientException("ConfigProblem, X509Cert NotFound, path:" + certPath + ", type:" + certType);
            }
            X509Certificate x509Certificate = X509CertSupportFactory.getSupport(certType.getValue()).generate(certStream);
            return x509Certificate;
        }
        finally {
            StreamUtils.closeQuietly(certStream);
        }
    }
}

