/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.client.ClientReporter;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostStatusChangePayload;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostStatusChangeReport;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.RouteUtils;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.invoke.model.UriResource;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.sentinel.YopSph;
import com.yeepay.yop.sdk.utils.CheckUtils;
import com.yeepay.yop.sdk.utils.EnvUtils;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGateWayRouter
implements GateWayRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleGateWayRouter.class);
    private static final Map<ServerRootSpace, ServerRootRouting> SERVER_ROOT_ROUTING = Maps.newConcurrentMap();
    private static final Map<URI, Set<ServerRootInfo>> ALL_SERVER_INFOS = Maps.newConcurrentMap();
    private static final YopSph.BlockResourcePool BLOCK_SERVER_POOL = new YopSph.BlockResourcePool();
    private final ServerRootSpace space;
    private final Set<String> independentApiGroups;
    private final ServerRootRouting serverRootRouting;

    public SimpleGateWayRouter(ServerRootSpace space) {
        this.space = space;
        this.independentApiGroups = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"bank-encryption"}));
        this.serverRootRouting = SERVER_ROOT_ROUTING.computeIfAbsent(space, p -> {
            List randomSandboxList;
            List<URI> randomYosList;
            this.collectServerRootTypes(space);
            ConcurrentMap mainServers = Maps.newConcurrentMap();
            ConcurrentMap backupServers = Maps.newConcurrentMap();
            List<URI> randomCommonList = RouteUtils.randomList(space.getPreferredEndPoint());
            if (this.recordMainServer(randomCommonList.remove(0), ServerRootType.COMMON, mainServers)) {
                backupServers.put(ServerRootType.COMMON, randomCommonList);
            }
            if (this.recordMainServer((randomYosList = RouteUtils.randomList(CollectionUtils.isEmpty(space.getPreferredYosEndPoint()) ? Lists.newArrayList((Object[])new URI[]{space.getYosServerRoot()}) : space.getPreferredYosEndPoint())).remove(0), ServerRootType.YOS, mainServers)) {
                backupServers.put(ServerRootType.YOS, randomYosList);
            }
            if (this.recordMainServer((URI)(randomSandboxList = RouteUtils.randomList(Lists.newArrayList((Object[])new URI[]{space.getSandboxServerRoot()}))).remove(0), ServerRootType.SANDBOX, mainServers)) {
                backupServers.put(ServerRootType.SANDBOX, randomYosList);
            }
            return new ServerRootRouting(mainServers, backupServers);
        });
    }

    private boolean recordMainServer(URI serverRoot, ServerRootType serverRootType, Map<ServerRootType, URI> mainServers) {
        return this.recordMainServer(serverRoot, serverRootType, mainServers, false);
    }

    private boolean recordMainServer(URI serverRoot, ServerRootType serverRootType, Map<ServerRootType, URI> mainServers, boolean force) {
        if (null == serverRoot) {
            throw new YopClientException("Config Error, No ServerRoot Found, type:" + (Object)((Object)serverRootType));
        }
        URI oldMain = mainServers.putIfAbsent(serverRootType, serverRoot);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Main ServerRoot Set, value:{}, type:{}", (Object)serverRoot, (Object)serverRootType);
        }
        if (null != oldMain) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Main ServerRoot Already Set, value:{}", (Object)oldMain);
            }
            if (force) {
                mainServers.put(serverRootType, serverRoot);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Main ServerRoot Switched, old:{}, new:{}", (Object)oldMain, (Object)serverRoot);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void collectServerRootTypes(ServerRootSpace space) {
        if (CollectionUtils.isNotEmpty(space.getPreferredEndPoint())) {
            for (URI uri : space.getPreferredEndPoint()) {
                this.collectServerRootType(space.getProvider(), space.getEnv(), uri, ServerRootType.COMMON);
            }
        }
        if (CollectionUtils.isNotEmpty(space.getPreferredYosEndPoint())) {
            for (URI uri : space.getPreferredYosEndPoint()) {
                this.collectServerRootType(space.getProvider(), space.getEnv(), uri, ServerRootType.YOS);
            }
        }
        this.collectServerRootType(space.getProvider(), space.getEnv(), space.getYosServerRoot(), ServerRootType.YOS);
    }

    private void collectServerRootType(String provider, String env, URI serverRoot, ServerRootType serverRootType) {
        if (null != serverRoot) {
            ALL_SERVER_INFOS.computeIfAbsent(serverRoot, p -> Sets.newHashSet()).add(new ServerRootInfo(provider, env, serverRootType));
        }
    }

    private static void monitorServerRoot() {
        EventObserverRegistry.getInstance().addStateChangeObserver("BLOCKED_SERVERS_CHANGED", (prevState, newState, rule, snapshotValue) -> {
            try {
                UriResource uriResource = UriResource.parseResourceKey((String)rule.getResource());
                URI serverRoot = uriResource.getResource();
                LOGGER.info("ServerRoot Block State Changed, serverRoot:{}, old:{}, new:{}, rule:{}", new Object[]{serverRoot, prevState, newState, rule});
                Set<ServerRootInfo> serverRootInfos = ALL_SERVER_INFOS.get(serverRoot);
                ServerRootInfo choosedServerRootInfo = ServerRootInfo.DEFAULT_INFO;
                HashSet serverTypes = Collections.emptySet();
                if (CollectionUtils.isNotEmpty(serverRootInfos)) {
                    serverTypes = Sets.newHashSet();
                    for (ServerRootInfo serverRootInfo : serverRootInfos) {
                        serverTypes.add(serverRootInfo.getServerRootType().name());
                    }
                    choosedServerRootInfo = serverRootInfos.iterator().next();
                }
                BLOCK_SERVER_POOL.onServerStatusChange(uriResource, prevState, newState, rule, serverTypes);
                YopHostStatusChangeReport report = new YopHostStatusChangeReport(new YopHostStatusChangePayload(serverRoot.toString(), prevState.name(), newState.name(), rule.toString()));
                report.setProvider(choosedServerRootInfo.getProvider());
                report.setEnv(choosedServerRootInfo.getEnv());
                ClientReporter.asyncReportToQueue(report);
            }
            catch (Exception e) {
                LOGGER.warn("UnexpectedError, MonitorServerRoot ex:", (Throwable)e);
            }
        });
    }

    @Override
    public UriResource route(String appKey, Request<?> request, List<URI> excludeServerRoots) {
        ServerRootType serverRootType;
        if (!EnvUtils.isSandBoxEnv(this.space.getEnv()) && (EnvUtils.isSandboxApp(appKey) || EnvUtils.isSandBoxMode())) {
            return new UriResource(this.space.getSandboxServerRoot());
        }
        YopRequestConfig requestConfig = ((BaseRequest)request.getOriginalRequestObject()).getRequestConfig();
        ServerRootType serverRootType2 = serverRootType = request.isYosRequest() ? ServerRootType.YOS : ServerRootType.COMMON;
        if (StringUtils.isNotBlank((CharSequence)requestConfig.getServerRoot())) {
            URI serverRoot = CheckUtils.checkServerRoot(requestConfig.getServerRoot());
            if (this.isExcludeServerRoots(serverRoot, excludeServerRoots)) {
                throw new YopClientException("RequestConfig Error, serverRoot excluded:" + serverRoot);
            }
            this.collectServerRootType(this.space.getProvider(), this.space.getEnv(), serverRoot, serverRootType);
            return new UriResource(serverRoot);
        }
        String apiGroup = request.getServiceName().toLowerCase().replace("_", "-");
        if (this.independentApiGroups.contains(apiGroup)) {
            URI independentServerRoot = this.independentServerRoot(apiGroup, request);
            if (this.isExcludeServerRoots(independentServerRoot, excludeServerRoots)) {
                throw new YopClientException("Config Error, ServerRoot excluded:" + independentServerRoot);
            }
            return new UriResource(independentServerRoot);
        }
        URI mainServer = this.serverRootRouting.getMainServers().get((Object)serverRootType);
        if (null == mainServer) {
            throw new YopClientException("Config Error, Main ServerRoot NotFound" + (Object)((Object)serverRootType));
        }
        if (!this.isExcludeServerRoots(mainServer, excludeServerRoots)) {
            return new UriResource(mainServer);
        }
        List<URI> backupServers = this.serverRootRouting.getBackupServers().get((Object)serverRootType);
        if (CollectionUtils.isNotEmpty(backupServers)) {
            for (URI backup : backupServers) {
                if (this.isExcludeServerRoots(backup, excludeServerRoots)) continue;
                return new UriResource(backup);
            }
        }
        return BLOCK_SERVER_POOL.select(serverRootType.name(), mainServer, this.serverRootRouting.getAllServers().get((Object)serverRootType));
    }

    private boolean isExcludeServerRoots(URI serverRoot, List<URI> excludeServerRoots) {
        return null != excludeServerRoots && null != serverRoot && excludeServerRoots.contains(serverRoot);
    }

    private URI independentServerRoot(String apiGroup, Request<?> request) {
        try {
            URI serverRoot = request.isYosRequest() ? this.space.getYosServerRoot() : this.space.getServerRoot();
            return new URI(serverRoot.getScheme(), serverRoot.getUserInfo(), this.getIndependentApiGroupHost(apiGroup, serverRoot.getHost(), request.isYosRequest()), serverRoot.getPort(), serverRoot.getPath(), serverRoot.getQuery(), serverRoot.getFragment());
        }
        catch (Exception ex) {
            throw new YopClientException("Route Request Failure, ex:", (Throwable)ex);
        }
    }

    private String getIndependentApiGroupHost(String apiGroup, String originHost, boolean isYosRequest) {
        if (isYosRequest) {
            return originHost;
        }
        int index = StringUtils.indexOf((CharSequence)originHost, (CharSequence)".");
        return StringUtils.substring((String)originHost, (int)0, (int)index) + "-" + apiGroup + StringUtils.substring((String)originHost, (int)index);
    }

    static {
        SimpleGateWayRouter.monitorServerRoot();
    }

    private static class ServerRootInfo {
        public static ServerRootInfo DEFAULT_INFO = new ServerRootInfo("", "", ServerRootType.COMMON);
        private String provider;
        private String env;
        private ServerRootType serverRootType;

        public ServerRootInfo(String provider, String env, ServerRootType serverRootType) {
            this.provider = provider;
            this.env = env;
            this.serverRootType = serverRootType;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getEnv() {
            return this.env;
        }

        public ServerRootType getServerRootType() {
            return this.serverRootType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.provider, this.env, this.serverRootType});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServerRootInfo) {
                ServerRootInfo that = (ServerRootInfo)obj;
                return Objects.equals(this.provider, that.provider) && Objects.equals(this.env, that.env) && Objects.equals((Object)this.serverRootType, (Object)that.serverRootType);
            }
            return false;
        }
    }

    private static enum ServerRootType {
        COMMON,
        YOS,
        SANDBOX;

    }

    private class ServerRootRouting {
        private Map<ServerRootType, URI> mainServers;
        private Map<ServerRootType, List<URI>> backupServers;
        private Map<ServerRootType, List<URI>> allServers;

        public ServerRootRouting(Map<ServerRootType, URI> mainServers, Map<ServerRootType, List<URI>> backupServers) {
            this.mainServers = mainServers;
            this.backupServers = backupServers;
            this.allServers = Maps.newHashMap();
            if (MapUtils.isNotEmpty(mainServers)) {
                mainServers.forEach((k, v) -> this.allServers.computeIfAbsent((ServerRootType)((Object)k), p -> Lists.newArrayList()).add(v));
            }
            if (MapUtils.isNotEmpty(backupServers)) {
                backupServers.forEach((k, v) -> this.allServers.computeIfAbsent((ServerRootType)((Object)k), p -> Lists.newArrayList()).addAll(v));
            }
        }

        public Map<ServerRootType, URI> getMainServers() {
            return this.mainServers;
        }

        public Map<ServerRootType, List<URI>> getBackupServers() {
            return this.backupServers;
        }

        public Map<ServerRootType, List<URI>> getAllServers() {
            return this.allServers;
        }
    }
}

