/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.support.ClientConfigurationSupport;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpClientProvider;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class YopHttpClientFactory {
    private static final Map<String, YopHttpClient> DEFAULT_CLIENT_MAP = Maps.newConcurrentMap();
    private static final Map<String, YopHttpClientProvider> httpClientProviderMap = Maps.newHashMap();

    @Deprecated
    public static YopHttpClient getDefaultClient() {
        return YopHttpClientFactory.getDefaultClient("", "", null);
    }

    public static YopHttpClient getDefaultClient(String provider, String env, YopSdkConfigProvider yopSdkConfigProvider) {
        String clientKey = StringUtils.defaultString((String)provider, (String)"") + ":" + StringUtils.defaultString((String)env, (String)"");
        return DEFAULT_CLIENT_MAP.computeIfAbsent(clientKey, p -> {
            YopSdkConfigProvider sdkConfigProvider = null == yopSdkConfigProvider ? YopSdkConfigProviderRegistry.getProvider() : yopSdkConfigProvider;
            ClientConfiguration clientConfiguration = ClientConfigurationSupport.getClientConfiguration(sdkConfigProvider.getConfig(provider, env));
            return YopHttpClientFactory.getClient(clientConfiguration);
        });
    }

    public static YopHttpClient getClient(ClientConfiguration clientConfig) {
        YopHttpClientProvider yopHttpClientProvider = httpClientProviderMap.get(clientConfig.getClientImpl());
        if (null == yopHttpClientProvider) {
            throw new YopClientException("SetUpProblem, YopHttpClientProvider NotFound, name:" + clientConfig.getClientImpl());
        }
        return yopHttpClientProvider.get(clientConfig);
    }

    static {
        ServiceLoader<YopHttpClientProvider> serviceLoader = ServiceLoader.load(YopHttpClientProvider.class);
        for (YopHttpClientProvider yopHttpClientProvider : serviceLoader) {
            httpClientProviderMap.put(yopHttpClientProvider.name(), yopHttpClientProvider);
        }
        if (httpClientProviderMap.isEmpty()) {
            throw new YopClientException("SetUpProblem\uff0cYopHttpClientProvider NotFound!");
        }
    }
}

