/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.AbstractServiceClientBuilder;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import com.yeepay.yop.sdk.service.common.YopClient;
import com.yeepay.yop.sdk.service.common.YopClientBuilder;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class ClientUtils {
    private static final String BASIC_CLIENT_PREFIX = YopClientBuilder.class.getCanonicalName();
    private static final String INNER_CLIENT_TYPE = "inner";
    private static ThreadLocal<String> CURRENT_CLIENT_ID = new ThreadLocal();
    private static final Map<String, String> INNER_BASIC_CLIENT_MAP = Maps.newConcurrentMap();
    private static Cache<String, AbstractServiceClientBuilder<?, ?>> CLIENT_BUILDER_CACHE = CacheBuilder.newBuilder().maximumSize(3000L).build();

    public static <ClientInst> ClientInst getOrBuildClientInst(ClientParams clientParams, ClientInstBuilder<ClientInst> instBuilder) {
        ClientInst clientInst = instBuilder.build(clientParams);
        if (!ClientUtils.isInnerBasicClient(clientParams.getClientId())) {
            String innerBasicClientId = ClientUtils.toInnerBasicClientId(clientParams.getClientId());
            ((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)((YopClientBuilder)YopClientBuilder.builder().withInner(true)).withClientId(innerBasicClientId)).withProvider(clientParams.getProvider())).withEnv(clientParams.getEnv())).withCredentialsProvider(clientParams.getCredentialsProvider())).withYopSdkConfigProvider(clientParams.getYopSdkConfigProvider())).withPlatformCredentialsProvider(clientParams.getPlatformCredentialsProvider())).withClientConfiguration(clientParams.getClientConfiguration())).withEndpoint(null != clientParams.getEndPoint() ? clientParams.getEndPoint().toString() : null)).withYosEndpoint(null != clientParams.getYosEndPoint() ? clientParams.getYosEndPoint().toString() : null)).withPreferredEndPoint(clientParams.getPreferredEndPoint())).withPreferredYosEndPoint(clientParams.getPreferredYosEndPoint())).withSandboxEndPoint(null != clientParams.getSandboxEndPoint() ? clientParams.getSandboxEndPoint().toString() : null)).build();
        }
        return clientInst;
    }

    public static <ClientInst> ClientInst getClientInst(String clientId) {
        AbstractServiceClientBuilder builder = (AbstractServiceClientBuilder)CLIENT_BUILDER_CACHE.getIfPresent((Object)clientId);
        if (null != builder) {
            return (ClientInst)builder.getClientInst();
        }
        return null;
    }

    public static boolean isBasicClient(String clientId) {
        return StringUtils.startsWith((CharSequence)clientId, (CharSequence)(BASIC_CLIENT_PREFIX + ":"));
    }

    public static boolean isInnerBasicClient(String clientId) {
        return StringUtils.startsWith((CharSequence)clientId, (CharSequence)(BASIC_CLIENT_PREFIX + ":" + INNER_CLIENT_TYPE + ":"));
    }

    public static String toInnerBasicClientId(String clientId) {
        if (ClientUtils.isInnerBasicClient(clientId)) {
            return clientId;
        }
        return BASIC_CLIENT_PREFIX + ":" + INNER_CLIENT_TYPE + ":" + clientId.substring(clientId.indexOf(":") + 1);
    }

    public static String computeClientIdSuffix(ClientParams clientParams) {
        return UUID.randomUUID().toString();
    }

    public static void cacheClientBuilder(String clientId, AbstractServiceClientBuilder<?, ?> clientBuilder) {
        CLIENT_BUILDER_CACHE.put((Object)clientId, clientBuilder);
        if (ClientUtils.isInnerBasicClient(clientId)) {
            INNER_BASIC_CLIENT_MAP.put(ClientUtils.getClientEnvCacheKey(clientBuilder.getProvider(), clientBuilder.getEnv()), clientId);
        }
    }

    private static String getClientEnvCacheKey(String provider, String env) {
        return StringUtils.defaultString((String)provider, (String)"") + ":" + StringUtils.defaultString((String)env, (String)"");
    }

    public static String getCurrentClientId() {
        return CURRENT_CLIENT_ID.get();
    }

    public static YopClient getDefaultYopClient() {
        return ClientUtils.getAvailableYopClient("", "");
    }

    public static YopClient getAvailableYopClient(String provider, String env) {
        String clientEnvCacheKey;
        String clientId;
        YopClient clientInst = null;
        String currentClientId = ClientUtils.getCurrentClientId();
        if (StringUtils.isNotBlank((CharSequence)currentClientId)) {
            clientInst = (YopClient)ClientUtils.getClientInst(ClientUtils.toInnerBasicClientId(currentClientId));
        }
        if (null == clientInst && StringUtils.isNotBlank((CharSequence)(clientId = INNER_BASIC_CLIENT_MAP.get(clientEnvCacheKey = ClientUtils.getClientEnvCacheKey(provider, env))))) {
            clientInst = (YopClient)ClientUtils.getClientInst(clientId);
        }
        if (null == clientInst) {
            clientInst = (YopClient)((YopClientBuilder)((YopClientBuilder)YopClientBuilder.builder().withProvider(provider)).withEnv(env)).build();
        }
        return clientInst;
    }

    public static void setCurrentClientId(String clientId) {
        CURRENT_CLIENT_ID.set(clientId);
    }

    public static void removeCurrentClientId() {
        CURRENT_CLIENT_ID.remove();
    }

    public static YopSdkConfigProvider getCurrentSdkConfigProvider() {
        AbstractServiceClientBuilder clientBuilder;
        String currentClientId = ClientUtils.getCurrentClientId();
        if (StringUtils.isNotBlank((CharSequence)currentClientId) && null != (clientBuilder = (AbstractServiceClientBuilder)CLIENT_BUILDER_CACHE.getIfPresent((Object)currentClientId)) && null != clientBuilder.getYopSdkConfigProvider()) {
            return clientBuilder.getYopSdkConfigProvider();
        }
        return YopSdkConfigProviderRegistry.getProvider();
    }

    public static YopCredentialsProvider getCurrentCredentialsProvider() {
        AbstractServiceClientBuilder clientBuilder;
        String currentClientId = ClientUtils.getCurrentClientId();
        if (StringUtils.isNotBlank((CharSequence)currentClientId) && null != (clientBuilder = (AbstractServiceClientBuilder)CLIENT_BUILDER_CACHE.getIfPresent((Object)currentClientId)) && null != clientBuilder.getCredentialsProvider()) {
            return clientBuilder.getCredentialsProvider();
        }
        return YopCredentialsProviderRegistry.getProvider();
    }

    public static YopPlatformCredentialsProvider getCurrentPlatformCredentialsProvider() {
        AbstractServiceClientBuilder clientBuilder;
        String currentClientId = ClientUtils.getCurrentClientId();
        if (StringUtils.isNotBlank((CharSequence)currentClientId) && null != (clientBuilder = (AbstractServiceClientBuilder)CLIENT_BUILDER_CACHE.getIfPresent((Object)currentClientId)) && null != clientBuilder.getPlatformCredentialsProvider()) {
            return clientBuilder.getPlatformCredentialsProvider();
        }
        return YopPlatformCredentialsProviderRegistry.getProvider();
    }

    public static interface ClientInstBuilder<T> {
        public T build(ClientParams var1);
    }
}

