/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import de.codecentric.boot.admin.server.cloud.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.server.domain.values.Registration;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultServiceInstanceConverter
implements ServiceInstanceConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceInstanceConverter.class);
    private static final String KEY_MANAGEMENT_PORT = "management.port";
    private static final String KEY_MANAGEMENT_PATH = "management.context-path";
    private static final String KEY_MANAGEMENT_ADDRESS = "management.address";
    private static final String KEY_HEALTH_PATH = "health.path";
    private String managementContextPath = "/actuator";
    private String healthEndpointPath = "health";

    @Override
    public Registration convert(ServiceInstance instance) {
        Map<String, String> metadata;
        URI serviceUrl;
        LOGGER.debug("Converting service '{}' running at '{}' with metadata {}", new Object[]{instance.getServiceId(), instance.getUri(), instance.getMetadata()});
        Registration.Builder builder = Registration.create((String)instance.getServiceId(), (String)this.getHealthUrl(instance).toString());
        URI managementUrl = this.getManagementUrl(instance);
        if (managementUrl != null) {
            builder.managementUrl(managementUrl.toString());
        }
        if ((serviceUrl = this.getServiceUrl(instance)) != null) {
            builder.serviceUrl(serviceUrl.toString());
        }
        if ((metadata = this.getMetadata(instance)) != null) {
            builder.metadata(metadata);
        }
        return builder.build();
    }

    protected URI getHealthUrl(ServiceInstance instance) {
        String healthPath = (String)instance.getMetadata().get(KEY_HEALTH_PATH);
        if (StringUtils.isEmpty((Object)healthPath)) {
            healthPath = this.healthEndpointPath;
        }
        return UriComponentsBuilder.fromUri((URI)this.getManagementUrl(instance)).path("/").path(healthPath).build().toUri();
    }

    protected URI getManagementUrl(ServiceInstance instance) {
        String managamentPort;
        String managamentPath = (String)instance.getMetadata().get(KEY_MANAGEMENT_PATH);
        if (StringUtils.isEmpty((Object)managamentPath)) {
            managamentPath = this.managementContextPath;
        }
        URI serviceUrl = this.getServiceUrl(instance);
        String managementServerAddress = (String)instance.getMetadata().get(KEY_MANAGEMENT_ADDRESS);
        if (StringUtils.isEmpty((Object)managementServerAddress)) {
            managementServerAddress = serviceUrl.getHost();
        }
        if (StringUtils.isEmpty((Object)(managamentPort = (String)instance.getMetadata().get(KEY_MANAGEMENT_PORT)))) {
            managamentPort = String.valueOf(serviceUrl.getPort());
        }
        return UriComponentsBuilder.fromUri((URI)serviceUrl).host(managementServerAddress).port(managamentPort).path("/").path(managamentPath).build().toUri();
    }

    protected URI getServiceUrl(ServiceInstance instance) {
        return UriComponentsBuilder.fromUri((URI)instance.getUri()).path("/").build().toUri();
    }

    protected Map<String, String> getMetadata(ServiceInstance instance) {
        return instance.getMetadata() != null ? instance.getMetadata() : Collections.emptyMap();
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setHealthEndpointPath(String healthEndpointPath) {
        this.healthEndpointPath = healthEndpointPath;
    }

    public String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }
}

