/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LombokLightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private PsiJavaCodeReferenceElement[] myCachedRefs = null;
    private PsiClassType[] myCachedTypes = null;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LombokLightReferenceListBuilder(PsiManager psiManager, PsiReferenceList.Role role) {
        this(psiManager, StdLanguages.JAVA, role);
    }

    public LombokLightReferenceListBuilder(PsiManager psiManager, Language language, PsiReferenceList.Role role) {
        super(psiManager, language);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    public void addReference(PsiClass psiClass) {
        this.addReference(psiClass.getQualifiedName());
    }

    public void addReference(String string) {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myFactory.createReferenceElementByFQClassName(string, this.getResolveScope());
        this.myRefs.add(psiJavaCodeReferenceElement);
    }

    public void addReference(PsiClassType psiClassType) {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myFactory.createReferenceElementByType(psiClassType);
        this.myRefs.add(psiJavaCodeReferenceElement);
    }

    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
    }

    public String getText() {
        return null;
    }

    public PsiElement copy() {
        return null;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        if (this.myCachedRefs == null) {
            this.myCachedRefs = this.myRefs.isEmpty() ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : (PsiJavaCodeReferenceElement[])ContainerUtil.toArray(this.myRefs, (Object[])new PsiJavaCodeReferenceElement[this.myRefs.size()]);
        }
        return this.myCachedRefs;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myCachedTypes == null) {
            if (this.myRefs.isEmpty()) {
                this.myCachedTypes = PsiClassType.EMPTY_ARRAY;
            } else {
                int n = this.myRefs.size();
                this.myCachedTypes = new PsiClassType[n];
                for (int i = 0; i < n; ++i) {
                    this.myCachedTypes[i] = this.myFactory.createType(this.myRefs.get(i));
                }
            }
        }
        return this.myCachedTypes;
    }

    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    public String toString() {
        return "LombokLightReferenceList";
    }
}

