/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.extension;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import de.plushnikov.intellij.lombok.psi.LombokLightMethod;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokElementRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement psiElement = LombokElementRenameHandler.getElement(dataContext);
        return psiElement instanceof LombokLightMethod || psiElement instanceof LombokLightMethodBuilder;
    }

    @Nullable
    private static PsiElement getElement(DataContext dataContext) {
        return (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile, @Nullable DataContext dataContext) {
        PsiElement psiElement = LombokElementRenameHandler.getElement(dataContext);
        this.invokeInner(project, editor, psiElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] psiElementArray, @Nullable DataContext dataContext) {
        PsiElement psiElement;
        PsiElement psiElement2 = psiElement = psiElementArray.length == 1 ? psiElementArray[0] : null;
        if (psiElement == null) {
            psiElement = LombokElementRenameHandler.getElement(dataContext);
        }
        Editor editor = dataContext == null ? null : (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        this.invokeInner(project, editor, psiElement);
    }

    private void invokeInner(Project project, Editor editor, PsiElement psiElement) {
        String string = RefactoringBundle.getCannotRefactorMessage((String)"This element cannot be renamed.");
        if (string != null && string.length() > 0) {
            this.showErrorMessage(project, editor, string);
        }
    }

    void showErrorMessage(Project project, @Nullable Editor editor, String string) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)RefactoringBundle.message((String)"rename.title"), null);
    }
}

