/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.rag.content.retriever.neo4j;

import dev.langchain4j.Internal;
import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jGraph;
import java.util.Map;
import org.neo4j.driver.Record;

@Internal
class Neo4jGraphSchemaUtils {
    static final String SCHEMA_FROM_META_DATA = "CALL apoc.meta.data({maxRels: $maxRels, sample: $sample})\nYIELD label, other, elementType, type, property\nWITH label, elementType,\n     apoc.text.join(collect(case when NOT type = \"RELATIONSHIP\" then property+\": \"+type else null end),\", \") AS properties,\n     collect(case when type = \"RELATIONSHIP\" AND elementType = \"node\" then \"(:\" + label + \")-[:\" + property + \"]->(:\" + toString(other[0]) + \")\" else null end) AS patterns\nWITH elementType AS type,\n    apoc.text.join(collect(\":\"+label+\" {\"+properties+\"}\"),\"\\n\") AS entities,\n    apoc.text.join(apoc.coll.flatten(collect(coalesce(patterns,[]))),\"\\n\") AS patterns\nRETURN collect(case type when \"relationship\" then entities end)[0] AS relationships,\n    collect(case type when \"node\" then entities end)[0] AS nodes,\n    collect(case type when \"node\" then patterns end)[0] as patterns\n";

    Neo4jGraphSchemaUtils() {
    }

    static String getSchemaFromMetadata(Neo4jGraph graph, Long sample, Long maxRels) {
        Record record = graph.executeRead(SCHEMA_FROM_META_DATA, Map.of("sample", sample, "maxRels", maxRels)).get(0);
        String nodesString = record.get("nodes").asString();
        String relationshipsString = record.get("relationships").asString();
        String patternsString = record.get("patterns").asString();
        String schema = "Node properties are the following:\n" + nodesString + "\n\nRelationship properties are the following:\n" + relationshipsString + "\n\nThe relationships are the following:\n" + patternsString;
        return schema;
    }
}

