/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input;

import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.spi.prompt.PromptTemplateFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DefaultPromptTemplateFactory
implements PromptTemplateFactory {
    DefaultPromptTemplateFactory() {
    }

    @Override
    public DefaultTemplate create(PromptTemplateFactory.Input input) {
        return new DefaultTemplate(input.getTemplate());
    }

    static class DefaultTemplate
    implements PromptTemplateFactory.Template {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{\\{(.+?)}}");
        private final String template;
        private final Set<String> allVariables;

        public DefaultTemplate(String template) {
            this.template = ValidationUtils.ensureNotBlank(template, "template");
            this.allVariables = DefaultTemplate.extractVariables(template);
        }

        private static Set<String> extractVariables(String template) {
            HashSet<String> variables = new HashSet<String>();
            Matcher matcher = VARIABLE_PATTERN.matcher(template);
            while (matcher.find()) {
                variables.add(matcher.group(1));
            }
            return variables;
        }

        @Override
        public String render(Map<String, Object> variables) {
            this.ensureAllVariablesProvided(variables);
            String result = this.template;
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                result = DefaultTemplate.replaceAll(result, entry.getKey(), entry.getValue());
            }
            return result;
        }

        private void ensureAllVariablesProvided(Map<String, Object> providedVariables) {
            for (String variable : this.allVariables) {
                if (providedVariables.containsKey(variable)) continue;
                throw Exceptions.illegalArgument("Value for the variable '%s' is missing", variable);
            }
        }

        private static String replaceAll(String template, String variable, Object value) {
            if (value == null || value.toString() == null) {
                throw Exceptions.illegalArgument("Value for the variable '%s' is null", variable);
            }
            return template.replace(DefaultTemplate.inDoubleCurlyBrackets(variable), value.toString());
        }

        private static String inDoubleCurlyBrackets(String variable) {
            return "{{" + variable + "}}";
        }
    }
}

