/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.TypeUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.structured.Description;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ToolSpecifications {
    private ToolSpecifications() {
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Class<?> classWithTools) {
        List<ToolSpecification> toolSpecifications = Arrays.stream(classWithTools.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(ToolSpecifications::toolSpecificationFrom).collect(Collectors.toList());
        ToolSpecifications.validateSpecifications(toolSpecifications);
        return toolSpecifications;
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Object objectWithTools) {
        return ToolSpecifications.toolSpecificationsFrom(objectWithTools.getClass());
    }

    public static void validateSpecifications(List<ToolSpecification> toolSpecifications) throws IllegalArgumentException {
        HashSet<String> names = new HashSet<String>();
        for (ToolSpecification toolSpecification : toolSpecifications) {
            if (names.add(toolSpecification.name())) continue;
            throw new IllegalArgumentException(String.format("Tool names must be unique. The tool '%s' appears several times", toolSpecification.name()));
        }
    }

    public static ToolSpecification toolSpecificationFrom(Method method) {
        Tool annotation = method.getAnnotation(Tool.class);
        String name = Utils.isNullOrBlank(annotation.name()) ? method.getName() : annotation.name();
        String description = String.join((CharSequence)"\n", annotation.value());
        ToolSpecification.Builder builder = ToolSpecification.builder().name(name).description(description);
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isAnnotationPresent(ToolMemoryId.class)) continue;
            boolean required = Optional.ofNullable(parameter.getAnnotation(P.class)).map(P::required).orElse(true);
            if (required) {
                builder.addParameter(parameter.getName(), ToolSpecifications.toJsonSchemaProperties(parameter));
                continue;
            }
            builder.addOptionalParameter(parameter.getName(), ToolSpecifications.toJsonSchemaProperties(parameter));
        }
        return builder.build();
    }

    static Iterable<JsonSchemaProperty> toJsonSchemaProperties(Parameter parameter) {
        P annotation;
        JsonSchemaProperty description;
        Class<?> type = parameter.getType();
        Iterable<JsonSchemaProperty> simpleType = ToolSpecifications.toJsonSchemaProperties(type, description = (annotation = parameter.getAnnotation(P.class)) == null ? null : JsonSchemaProperty.description(annotation.value()));
        if (simpleType != null) {
            return simpleType;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, ToolSpecifications.arrayTypeFrom(parameter.getParameterizedType()), description);
        }
        return ToolSpecifications.removeNulls(JsonSchemaProperty.OBJECT, ToolSpecifications.schema(type), description);
    }

    static JsonSchemaProperty schema(Class<?> structured) {
        return ToolSpecifications.schema(structured, new HashSet());
    }

    private static JsonSchemaProperty schema(Class<?> structured, Set<Class<?>> visited) {
        if (visited.contains(structured)) {
            return null;
        }
        visited.add(structured);
        HashMap properties = new HashMap();
        for (Field field : structured.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("this$0") || Modifier.isStatic(field.getModifiers())) continue;
            Iterable<JsonSchemaProperty> schemaProperties = ToolSpecifications.toJsonSchemaProperties(field, visited);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            for (JsonSchemaProperty jsonSchemaProperty : schemaProperties) {
                objectMap.put(jsonSchemaProperty.key(), jsonSchemaProperty.value());
            }
            properties.put(name, objectMap);
        }
        return JsonSchemaProperty.from("properties", properties);
    }

    private static Iterable<JsonSchemaProperty> toJsonSchemaProperties(Field field, Set<Class<?>> visited) {
        Description annotation;
        JsonSchemaProperty description;
        Class<?> type = field.getType();
        Iterable<JsonSchemaProperty> simpleType = ToolSpecifications.toJsonSchemaProperties(type, description = (annotation = field.getAnnotation(Description.class)) == null ? null : JsonSchemaProperty.description(String.join((CharSequence)" ", annotation.value())));
        if (simpleType != null) {
            return simpleType;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, ToolSpecifications.arrayTypeFrom((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]), description);
        }
        return ToolSpecifications.removeNulls(JsonSchemaProperty.OBJECT, ToolSpecifications.schema(type, visited), description);
    }

    private static Iterable<JsonSchemaProperty> toJsonSchemaProperties(Class<?> type, JsonSchemaProperty description) {
        if (type == String.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, description);
        }
        if (TypeUtils.isJsonBoolean(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.BOOLEAN, description);
        }
        if (TypeUtils.isJsonInteger(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.INTEGER, description);
        }
        if (TypeUtils.isJsonNumber(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.NUMBER, description);
        }
        if (type.isArray()) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, ToolSpecifications.arrayTypeFrom(type.getComponentType()), description);
        }
        if (type.isEnum()) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, JsonSchemaProperty.enums(type), description);
        }
        return null;
    }

    private static JsonSchemaProperty arrayTypeFrom(Type type) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return ToolSpecifications.arrayTypeFrom((Class)actualTypeArguments[0]);
        }
        return JsonSchemaProperty.items(JsonSchemaProperty.OBJECT);
    }

    private static JsonSchemaProperty arrayTypeFrom(Class<?> clazz) {
        if (clazz == String.class) {
            return JsonSchemaProperty.items(JsonSchemaProperty.STRING);
        }
        if (TypeUtils.isJsonBoolean(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.BOOLEAN);
        }
        if (TypeUtils.isJsonInteger(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.INTEGER);
        }
        if (TypeUtils.isJsonNumber(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.NUMBER);
        }
        return JsonSchemaProperty.objectItems(ToolSpecifications.schema(clazz));
    }

    static Iterable<JsonSchemaProperty> removeNulls(JsonSchemaProperty ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

