/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
class EmbeddingResponse {
    private String model;
    private List<float[]> embeddings;

    public static EmbeddingResponseBuilder builder() {
        return new EmbeddingResponseBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<float[]> getEmbeddings() {
        return this.embeddings;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setEmbeddings(List<float[]> embeddings) {
        this.embeddings = embeddings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingResponse)) {
            return false;
        }
        EmbeddingResponse other = (EmbeddingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<float[]> this$embeddings = this.getEmbeddings();
        List<float[]> other$embeddings = other.getEmbeddings();
        return !(this$embeddings == null ? other$embeddings != null : !((Object)this$embeddings).equals(other$embeddings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<float[]> $embeddings = this.getEmbeddings();
        result = result * 59 + ($embeddings == null ? 43 : ((Object)$embeddings).hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingResponse(model=" + this.getModel() + ", embeddings=" + this.getEmbeddings() + ")";
    }

    public EmbeddingResponse() {
    }

    public EmbeddingResponse(String model, List<float[]> embeddings) {
        this.model = model;
        this.embeddings = embeddings;
    }

    public static class EmbeddingResponseBuilder {
        private String model;
        private List<float[]> embeddings;

        EmbeddingResponseBuilder() {
        }

        public EmbeddingResponseBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingResponseBuilder embeddings(List<float[]> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        public EmbeddingResponse build() {
            return new EmbeddingResponse(this.model, this.embeddings);
        }

        public String toString() {
            return "EmbeddingResponse.EmbeddingResponseBuilder(model=" + this.model + ", embeddings=" + this.embeddings + ")";
        }
    }
}

