/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.DeleteModelRequest;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaApi;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.OllamaRequestLoggingInterceptor;
import dev.langchain4j.model.ollama.OllamaResponseLoggingInterceptor;
import dev.langchain4j.model.ollama.RunningModelsListResponse;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class OllamaClient {
    private static final Logger log = LoggerFactory.getLogger(OllamaClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final OllamaApi ollamaApi;
    private final boolean logStreamingResponses;

    public OllamaClient(String baseUrl, Duration timeout, Boolean logRequests, Boolean logResponses, Boolean logStreamingResponses, Map<String, String> customHeaders) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests != null && logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new OllamaRequestLoggingInterceptor());
        }
        if (logResponses != null && logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new OllamaResponseLoggingInterceptor());
        }
        boolean bl = this.logStreamingResponses = logStreamingResponses != null && logStreamingResponses != false;
        if (customHeaders != null && !customHeaders.isEmpty()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new GenericHeadersInterceptor(customHeaders));
        }
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.ollamaApi = (OllamaApi)retrofit.create(OllamaApi.class);
    }

    public CompletionResponse completion(CompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.completion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (CompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse chat(ChatRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.chat(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (ChatResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        this.ollamaApi.streamingCompletion(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();){
                    StringBuilder contentBuilder = new StringBuilder();
                    while (true) {
                        byte[] bytes = new byte[1024];
                        int len = inputStream.read(bytes);
                        String partialResponse = new String(bytes, 0, len);
                        if (OllamaClient.this.logStreamingResponses) {
                            log.debug("Streaming partial response: {}", (Object)partialResponse);
                        }
                        CompletionResponse completionResponse = (CompletionResponse)OBJECT_MAPPER.readValue(partialResponse, CompletionResponse.class);
                        contentBuilder.append(completionResponse.getResponse());
                        handler.onNext(completionResponse.getResponse());
                        if (!Boolean.TRUE.equals(completionResponse.getDone())) continue;
                        Response response = Response.from((Object)contentBuilder.toString(), (TokenUsage)new TokenUsage(completionResponse.getPromptEvalCount(), completionResponse.getEvalCount()));
                        handler.onComplete(response);
                        return;
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                    return;
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public void streamingChat(ChatRequest request, final StreamingResponseHandler<AiMessage> handler) {
        this.ollamaApi.streamingChat(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> retrofitResponse) {
                try (InputStream inputStream = ((ResponseBody)retrofitResponse.body()).byteStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    StringBuilder contentBuilder = new StringBuilder();
                    while (true) {
                        String partialResponse = reader.readLine();
                        if (OllamaClient.this.logStreamingResponses) {
                            log.debug("Streaming partial response: {}", (Object)partialResponse);
                        }
                        ChatResponse chatResponse = (ChatResponse)OBJECT_MAPPER.readValue(partialResponse, ChatResponse.class);
                        String content = chatResponse.getMessage().getContent();
                        contentBuilder.append(content);
                        handler.onNext(content);
                        if (!Boolean.TRUE.equals(chatResponse.getDone())) continue;
                        Response response = Response.from((Object)AiMessage.from((String)contentBuilder.toString()), (TokenUsage)new TokenUsage(chatResponse.getPromptEvalCount(), chatResponse.getEvalCount()));
                        handler.onComplete(response);
                        return;
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                    return;
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.embed(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ModelsListResponse listModels() {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.listModels().execute();
            if (retrofitResponse.isSuccessful()) {
                return (ModelsListResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OllamaModelCard showInformation(ShowModelInformationRequest showInformationRequest) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.showInformation(showInformationRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (OllamaModelCard)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RunningModelsListResponse listRunningModels() {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.listRunningModels().execute();
            if (retrofitResponse.isSuccessful()) {
                return (RunningModelsListResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Void deleteModel(DeleteModelRequest deleteModelRequest) {
        try {
            retrofit2.Response retrofitResponse = this.ollamaApi.deleteModel(deleteModelRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (Void)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static OllamaClientBuilder builder() {
        return new OllamaClientBuilder();
    }

    static class GenericHeadersInterceptor
    implements Interceptor {
        private final Map<String, String> headers = new HashMap<String, String>();

        GenericHeadersInterceptor(Map<String, String> headers) {
            Optional.ofNullable(headers).ifPresent(this.headers::putAll);
        }

        @NotNull
        public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder();
            this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
            return chain.proceed(builder.build());
        }
    }

    public static class OllamaClientBuilder {
        private String baseUrl;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Boolean logStreamingResponses;
        private Map<String, String> customHeaders;

        OllamaClientBuilder() {
        }

        public OllamaClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaClientBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaClientBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaClientBuilder logStreamingResponses(Boolean logStreamingResponses) {
            this.logStreamingResponses = logStreamingResponses;
            return this;
        }

        public OllamaClientBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OllamaClient build() {
            return new OllamaClient(this.baseUrl, this.timeout, this.logRequests, this.logResponses, this.logStreamingResponses, this.customHeaders);
        }

        public String toString() {
            return "OllamaClient.OllamaClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", logStreamingResponses=" + this.logStreamingResponses + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

