/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser;

import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.parser.NodeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseNodeParser
implements NodeParser {
    private static final JSONObject EMPTY_JSON_OBJECT = new JSONObject(Collections.emptyMap());

    public JSONObject getData(JSONObject nodeObject) {
        JSONObject jsonObject = nodeObject.getJSONObject("data");
        return jsonObject != null ? jsonObject : EMPTY_JSON_OBJECT;
    }

    public void addParameters(BaseNode node, JSONObject data) {
        List<Parameter> inputParameters = this.getParameters(data, "parameters");
        node.setParameters(inputParameters);
    }

    public List<Parameter> getParameters(JSONObject data, String key) {
        return this.getParameters(data.getJSONArray(key));
    }

    public List<Parameter> getParameters(JSONArray parametersJsonArray) {
        if (parametersJsonArray == null || parametersJsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parametersJsonArray.size());
        for (int i = 0; i < parametersJsonArray.size(); ++i) {
            JSONObject parameterJsonObject = parametersJsonArray.getJSONObject(i);
            Parameter parameter = new Parameter();
            parameter.setId(parameterJsonObject.getString("id"));
            parameter.setName(parameterJsonObject.getString("name"));
            parameter.setDescription(parameterJsonObject.getString("description"));
            parameter.setDataType(DataType.ofValue((String)parameterJsonObject.getString("dataType")));
            parameter.setRef(parameterJsonObject.getString("ref"));
            parameter.setRefType(RefType.ofValue((String)parameterJsonObject.getString("refType")));
            parameter.setRequired(parameterJsonObject.getBooleanValue("required"));
            parameter.setDefaultValue(parameterJsonObject.getString("defaultValue"));
            parameter.setValue(parameterJsonObject.getString("value"));
            JSONArray childrenJSONArray = parameterJsonObject.getJSONArray("children");
            if (childrenJSONArray != null && !childrenJSONArray.isEmpty()) {
                parameter.addChildren(this.getParameters(childrenJSONArray));
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public void addOutputDefs(BaseNode node, JSONObject data) {
        JSONArray outputDefs = data.getJSONArray("outputDefs");
        if (outputDefs != null) {
            for (int i = 0; i < outputDefs.size(); ++i) {
                JSONObject outputDefJsonObject = outputDefs.getJSONObject(i);
                Parameter parameter = new Parameter();
                parameter.setName(outputDefJsonObject.getString("name"));
                parameter.setDescription(outputDefJsonObject.getString("description"));
                parameter.setRef(outputDefJsonObject.getString("ref"));
                parameter.setRefType(RefType.ofValue((String)outputDefJsonObject.getString("refType")));
                parameter.setDataType(DataType.ofValue((String)outputDefJsonObject.getString("dataType")));
                node.addOutputDef(parameter);
            }
        }
    }
}

