/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;

class TypeBinding
implements ITypeBinding {
    private static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    private static final String NO_NAME = "";
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final int VALID_MODIFIERS = 3103;
    private org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;
    private String key;
    private BindingResolver resolver;

    public TypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        IAnnotationBinding[] domInstances = AnnotationBinding.NoAnnotations;
        if (this.binding.isAnnotationType() || this.binding.isClass() || this.binding.isEnum() || this.binding.isInterface()) {
            int length;
            ReferenceBinding refType = (ReferenceBinding)this.binding;
            org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] internalAnnotations = refType.getAnnotations();
            int n = length = internalAnnotations == null ? 0 : internalAnnotations.length;
            if (length > 0) {
                domInstances = new AnnotationBinding[length];
                int i = 0;
                while (i < length) {
                    domInstances[i] = this.resolver.getAnnotationInstance(internalAnnotations[i]);
                    ++i;
                }
            }
        }
        return domInstances;
    }

    public String getBinaryName() {
        char[] constantPoolName = this.binding.constantPoolName();
        if (constantPoolName == null) {
            return null;
        }
        char[] dotSeparated = CharOperation.replaceOnCopy(constantPoolName, '/', '.');
        return new String(dotSeparated);
    }

    public ITypeBinding getBound() {
        if (this.binding.isWildcard()) {
            WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
            if (wildcardBinding.bound != null) {
                return this.resolver.getTypeBinding(wildcardBinding.bound);
            }
        }
        return null;
    }

    private IClassFile getClassFile(char[] fileName) {
        int jarSeparator = CharOperation.indexOf('|', fileName);
        int pkgEnd = CharOperation.lastIndexOf('/', fileName);
        if (pkgEnd == -1) {
            pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
        }
        if (jarSeparator != -1 && pkgEnd < jarSeparator) {
            pkgEnd = jarSeparator;
        }
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(fileName, pkgEnd, jarSeparator);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        return pkg.getClassFile(new String(fileName, start, fileName.length - start));
    }

    private ICompilationUnit getCompilationUnit(char[] fileName) {
        ICompilationUnit workingCopy;
        char[] slashSeparatedFileName = CharOperation.replaceOnCopy(fileName, File.separatorChar, '/');
        int pkgEnd = CharOperation.lastIndexOf('/', slashSeparatedFileName);
        if (pkgEnd == -1) {
            return null;
        }
        IPackageFragment pkg = this.getPackageFragment(slashSeparatedFileName, pkgEnd, -1);
        if (pkg == null) {
            return null;
        }
        int start = pkgEnd + 1;
        ICompilationUnit cu = pkg.getCompilationUnit(new String(slashSeparatedFileName, start, slashSeparatedFileName.length - start));
        if (this.resolver instanceof DefaultBindingResolver && (workingCopy = cu.findWorkingCopy(((DefaultBindingResolver)this.resolver).workingCopyOwner)) != null) {
            return workingCopy;
        }
        return cu;
    }

    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.elementsType());
    }

    public IVariableBinding[] getDeclaredFields() {
        try {
            if (this.isClass() || this.isInterface() || this.isEnum()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                FieldBinding[] fields = referenceBinding.fields();
                int length = fields.length;
                IVariableBinding[] newFields = new IVariableBinding[length];
                int i = 0;
                while (i < length) {
                    newFields[i] = this.resolver.getVariableBinding(fields[i]);
                    ++i;
                }
                return newFields;
            }
        }
        catch (RuntimeException runtimeException) {}
        return NO_VARIABLE_BINDINGS;
    }

    public IMethodBinding[] getDeclaredMethods() {
        try {
            if (this.isClass() || this.isInterface() || this.isEnum()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                MethodBinding[] methods = referenceBinding.methods();
                int length = methods.length;
                int removeSyntheticsCounter = 0;
                IMethodBinding[] newMethods = new IMethodBinding[length];
                int i = 0;
                while (i < length) {
                    MethodBinding methodBinding = methods[i];
                    if (!this.shouldBeRemoved(methodBinding)) {
                        newMethods[removeSyntheticsCounter++] = this.resolver.getMethodBinding(methodBinding);
                    }
                    ++i;
                }
                if (removeSyntheticsCounter != length) {
                    IMethodBinding[] iMethodBindingArray = newMethods;
                    newMethods = new IMethodBinding[removeSyntheticsCounter];
                    System.arraycopy(iMethodBindingArray, 0, newMethods, 0, removeSyntheticsCounter);
                }
                return newMethods;
            }
        }
        catch (RuntimeException runtimeException) {}
        return NO_METHOD_BINDINGS;
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public ITypeBinding[] getDeclaredTypes() {
        try {
            if (this.isClass() || this.isInterface() || this.isEnum()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                ReferenceBinding[] members = referenceBinding.memberTypes();
                int length = members.length;
                ITypeBinding[] newMembers = new ITypeBinding[length];
                int i = 0;
                while (i < length) {
                    newMembers[i] = this.resolver.getTypeBinding(members[i]);
                    ++i;
                }
                return newMembers;
            }
        }
        catch (RuntimeException runtimeException) {}
        return NO_TYPE_BINDINGS;
    }

    public IMethodBinding getDeclaringMethod() {
        if (this.binding instanceof LocalTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
            MethodBinding methodBinding = localTypeBinding.enclosingMethod;
            if (methodBinding != null) {
                try {
                    return this.resolver.getMethodBinding(localTypeBinding.enclosingMethod);
                }
                catch (RuntimeException runtimeException) {}
            }
        } else if (this.binding.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding declaringElement = typeVariableBinding.declaringElement;
            if (declaringElement instanceof MethodBinding) {
                try {
                    return this.resolver.getMethodBinding((MethodBinding)declaringElement);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isNestedType()) {
                try {
                    return this.resolver.getTypeBinding(referenceBinding.enclosingType());
                }
                catch (RuntimeException runtimeException) {}
            }
        } else if (this.binding.isTypeVariable()) {
            Binding declaringElement;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding binding = declaringElement = typeVariableBinding.isCapture() ? ((CaptureBinding)typeVariableBinding).sourceType : typeVariableBinding.declaringElement;
            if (declaringElement instanceof ReferenceBinding) {
                try {
                    return this.resolver.getTypeBinding((ReferenceBinding)declaringElement);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        return null;
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public ITypeBinding getTypeDeclaration() {
        if (this.binding instanceof ParameterizedTypeBinding) {
            return this.resolver.getTypeBinding(((ParameterizedTypeBinding)this.binding).type);
        }
        return this;
    }

    public ITypeBinding getErasure() {
        return this.resolver.getTypeBinding(this.binding.erasure());
    }

    public ITypeBinding[] getInterfaces() {
        if (this.binding == null) {
            return NO_TYPE_BINDINGS;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return NO_TYPE_BINDINGS;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding[] interfaces = null;
        try {
            interfaces = referenceBinding.superInterfaces();
        }
        catch (RuntimeException runtimeException) {}
        if (interfaces == null) {
            return NO_TYPE_BINDINGS;
        }
        int length = interfaces.length;
        if (length == 0) {
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] newInterfaces = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            newInterfaces[i] = this.resolver.getTypeBinding(interfaces[i]);
            ++i;
        }
        return newInterfaces;
    }

    public IJavaElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        return this.getUnresolvedJavaElement(this.binding);
    }

    private JavaElement getUnresolvedJavaElement(org.eclipse.jdt.internal.compiler.lookup.TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        switch (typeBinding.kind()) {
            case 68: {
                typeBinding = ((ArrayBinding)typeBinding).leafComponentType();
                return this.getUnresolvedJavaElement(typeBinding);
            }
            case 132: 
            case 516: {
                return null;
            }
        }
        if (typeBinding.isCapture()) {
            return null;
        }
        ReferenceBinding referenceBinding = typeBinding.isParameterizedType() || typeBinding.isRawType() ? (ReferenceBinding)typeBinding.erasure() : (ReferenceBinding)typeBinding;
        char[] fileName = referenceBinding.getFileName();
        if (referenceBinding.isLocalType() || referenceBinding.isAnonymousType()) {
            if (Util.isClassFileName(fileName)) {
                int jarSeparator = CharOperation.indexOf('|', fileName);
                int pkgEnd = CharOperation.lastIndexOf('/', fileName);
                if (pkgEnd == -1) {
                    pkgEnd = CharOperation.lastIndexOf(File.separatorChar, fileName);
                }
                if (jarSeparator != -1 && pkgEnd < jarSeparator) {
                    pkgEnd = jarSeparator;
                }
                if (pkgEnd == -1) {
                    return null;
                }
                IPackageFragment pkg = this.getPackageFragment(fileName, pkgEnd, jarSeparator);
                char[] constantPoolName = referenceBinding.constantPoolName();
                if (constantPoolName == null) {
                    ClassFile classFile = (ClassFile)this.getClassFile(fileName);
                    return classFile == null ? null : (JavaElement)((Object)classFile.getType());
                }
                pkgEnd = CharOperation.lastIndexOf('/', constantPoolName);
                char[] classFileName = CharOperation.subarray(constantPoolName, pkgEnd + 1, constantPoolName.length);
                ClassFile classFile = (ClassFile)pkg.getClassFile(String.valueOf(new String(classFileName)) + ".class");
                return (JavaElement)((Object)classFile.getType());
            }
            ICompilationUnit cu = this.getCompilationUnit(fileName);
            if (cu == null) {
                return null;
            }
            try {
                int sourceStart = ((LocalTypeBinding)referenceBinding).sourceStart;
                return (JavaElement)cu.getElementAt(sourceStart);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        if (referenceBinding.isTypeVariable()) {
            String typeVariableName = new String(referenceBinding.sourceName());
            Binding declaringElement = ((TypeVariableBinding)referenceBinding).declaringElement;
            IBinding declaringTypeBinding = null;
            if (declaringElement instanceof MethodBinding) {
                declaringTypeBinding = this.resolver.getMethodBinding((MethodBinding)declaringElement);
                IMethod declaringMethod = (IMethod)declaringTypeBinding.getJavaElement();
                return (JavaElement)((Object)declaringMethod.getTypeParameter(typeVariableName));
            }
            declaringTypeBinding = this.resolver.getTypeBinding((org.eclipse.jdt.internal.compiler.lookup.TypeBinding)declaringElement);
            IType declaringType = (IType)declaringTypeBinding.getJavaElement();
            return (JavaElement)((Object)declaringType.getTypeParameter(typeVariableName));
        }
        if (fileName == null) {
            return null;
        }
        ITypeBinding declaringTypeBinding = this.getDeclaringClass();
        if (declaringTypeBinding == null) {
            if (Util.isClassFileName(fileName)) {
                ClassFile classFile = (ClassFile)this.getClassFile(fileName);
                if (classFile == null) {
                    return null;
                }
                return (JavaElement)((Object)classFile.getType());
            }
            ICompilationUnit cu = this.getCompilationUnit(fileName);
            if (cu == null) {
                return null;
            }
            return (JavaElement)((Object)cu.getType(new String(referenceBinding.sourceName())));
        }
        IType declaringType = (IType)declaringTypeBinding.getJavaElement();
        if (declaringType == null) {
            return null;
        }
        return (JavaElement)((Object)declaringType.getType(new String(referenceBinding.sourceName())));
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 2;
    }

    public int getModifiers() {
        if (this.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            if (referenceBinding.isAnonymousType()) {
                return accessFlags & 0xFFFFFFEF;
            }
            return accessFlags;
        }
        if (this.isAnnotation()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            return accessFlags & 0xFFFFD9FF;
        }
        if (this.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            return accessFlags & 0xFFFFF9FF;
        }
        if (this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            int accessFlags = referenceBinding.getAccessFlags() & 0xC1F;
            return accessFlags & 0xFFFFBFFF;
        }
        return 0;
    }

    public String getName() {
        switch (this.binding.kind()) {
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(TypeConstants.WILDCARD_NAME);
                if (wildcardBinding.bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            buffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            buffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    buffer.append(this.getBound().getName());
                }
                return String.valueOf(buffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return NO_NAME;
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(parameterizedTypeBinding.sourceName());
                ITypeBinding[] typeArguments = this.getTypeArguments();
                int typeArgumentsLength = typeArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    int max = typeArguments.length;
                    while (i < max) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(typeArguments[i].getName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getName();
            }
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous() || elementType.isCapture()) {
                    return NO_NAME;
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isAnonymous()) {
            return NO_NAME;
        }
        return new String(this.binding.sourceName());
    }

    public IPackageBinding getPackage() {
        switch (this.binding.kind()) {
            case 68: 
            case 132: 
            case 516: 
            case 4100: {
                return null;
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    private IPackageFragment getPackageFragment(char[] fileName, int pkgEnd, int jarSeparator) {
        if (jarSeparator != -1) {
            String jarMemento = new String(fileName, 0, jarSeparator);
            IPackageFragmentRoot root = (IPackageFragmentRoot)JavaCore.create(jarMemento);
            if (pkgEnd == jarSeparator) {
                return root.getPackageFragment(NO_NAME);
            }
            char[] pkgName = CharOperation.subarray(fileName, jarSeparator + 1, pkgEnd);
            CharOperation.replace(pkgName, '/', '.');
            return root.getPackageFragment(new String(pkgName));
        }
        Path path = new Path(new String(fileName, 0, pkgEnd));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Object folder = path.segmentCount() == 1 ? workspaceRoot.getProject(path.lastSegment()) : workspaceRoot.getFolder((IPath)path);
        IJavaElement element = JavaCore.create((IResource)folder);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 4: {
                return (IPackageFragment)element;
            }
            case 3: {
                return ((IPackageFragmentRoot)element).getPackageFragment(NO_NAME);
            }
            case 2: {
                IPackageFragmentRoot root = ((IJavaProject)element).getPackageFragmentRoot((IResource)folder);
                if (root == null) {
                    return null;
                }
                return root.getPackageFragment(NO_NAME);
            }
        }
        return null;
    }

    public String getQualifiedName() {
        switch (this.binding.kind()) {
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(TypeConstants.WILDCARD_NAME);
                ITypeBinding bound = this.getBound();
                if (bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            buffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            buffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    buffer.append(bound.getQualifiedName());
                }
                return String.valueOf(buffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getQualifiedName();
            }
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous() || elementType.isCapture()) {
                    return NO_NAME;
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getQualifiedName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return NO_NAME;
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                StringBuffer buffer = new StringBuffer();
                if (this.isMember()) {
                    buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                    buffer.append(parameterizedTypeBinding.sourceName());
                    ITypeBinding[] typeArguments = this.getTypeArguments();
                    int typeArgumentsLength = typeArguments.length;
                    if (typeArgumentsLength != 0) {
                        buffer.append('<');
                        int i = 0;
                        int max = typeArguments.length;
                        while (i < max) {
                            if (i > 0) {
                                buffer.append(',');
                            }
                            buffer.append(typeArguments[i].getQualifiedName());
                            ++i;
                        }
                        buffer.append('>');
                    }
                    return String.valueOf(buffer);
                }
                buffer.append(this.getTypeDeclaration().getQualifiedName());
                ITypeBinding[] typeArguments = this.getTypeArguments();
                int typeArgumentsLength = typeArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    int max = typeArguments.length;
                    while (i < max) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(typeArguments[i].getQualifiedName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
        }
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isMember()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDeclaringClass().getQualifiedName()).append('.');
            buffer.append(this.getName());
            return String.valueOf(buffer);
        }
        PackageBinding packageBinding = this.binding.getPackage();
        StringBuffer buffer = new StringBuffer();
        if (packageBinding != null && packageBinding.compoundName != CharOperation.NO_CHAR_CHAR) {
            buffer.append(CharOperation.concatWith(packageBinding.compoundName, '.')).append('.');
        }
        buffer.append(this.getName());
        return String.valueOf(buffer);
    }

    public ITypeBinding getSuperclass() {
        if (this.binding == null) {
            return null;
        }
        switch (this.binding.kind()) {
            case 68: 
            case 132: {
                return null;
            }
        }
        if (this.binding.isInterface()) {
            return null;
        }
        ReferenceBinding superclass = null;
        try {
            superclass = ((ReferenceBinding)this.binding).superclass();
        }
        catch (RuntimeException runtimeException) {
            return this.resolver.resolveWellKnownType("java.lang.Object");
        }
        if (superclass == null) {
            return null;
        }
        return this.resolver.getTypeBinding(superclass);
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.binding.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding[] arguments = parameterizedTypeBinding.arguments;
            if (arguments != null) {
                int argumentsLength = arguments.length;
                ITypeBinding[] typeArguments = new ITypeBinding[argumentsLength];
                int i = 0;
                while (i < argumentsLength) {
                    typeArguments[i] = this.resolver.getTypeBinding(arguments[i]);
                    ++i;
                }
                return typeArguments;
            }
        }
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        if (this.binding instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            ReferenceBinding varSuperclass = typeVariableBinding.superclass();
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding firstClassOrArrayBound = typeVariableBinding.firstBound;
            int boundsLength = 0;
            if (firstClassOrArrayBound != null) {
                if (firstClassOrArrayBound == varSuperclass) {
                    ++boundsLength;
                } else if (firstClassOrArrayBound.isArrayType()) {
                    ++boundsLength;
                } else {
                    firstClassOrArrayBound = null;
                }
            }
            ReferenceBinding[] superinterfaces = typeVariableBinding.superInterfaces();
            int superinterfacesLength = 0;
            if (superinterfaces != null) {
                superinterfacesLength = superinterfaces.length;
                boundsLength += superinterfacesLength;
            }
            if (boundsLength != 0) {
                ITypeBinding[] typeBounds = new ITypeBinding[boundsLength];
                int boundsIndex = 0;
                if (firstClassOrArrayBound != null) {
                    typeBounds[boundsIndex++] = this.resolver.getTypeBinding(firstClassOrArrayBound);
                }
                if (superinterfaces != null) {
                    int i = 0;
                    while (i < superinterfacesLength) {
                        typeBounds[boundsIndex] = this.resolver.getTypeBinding(superinterfaces[i]);
                        ++i;
                        ++boundsIndex;
                    }
                }
                return typeBounds;
            }
        }
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeParameters() {
        int typeVariableBindingsLength;
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        if (typeVariableBindings != null && (typeVariableBindingsLength = typeVariableBindings.length) != 0) {
            ITypeBinding[] typeParameters = new ITypeBinding[typeVariableBindingsLength];
            int i = 0;
            while (i < typeVariableBindingsLength) {
                typeParameters[i] = this.resolver.getTypeBinding(typeVariableBindings[i]);
                ++i;
            }
            return typeParameters;
        }
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding getWildcard() {
        if (this.binding instanceof CaptureBinding) {
            CaptureBinding captureBinding = (CaptureBinding)this.binding;
            return this.resolver.getTypeBinding(captureBinding.wildcard);
        }
        return null;
    }

    public boolean isGenericType() {
        if (this.isRawType()) {
            return false;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        return typeVariableBindings != null && typeVariableBindings.length > 0;
    }

    public boolean isAnnotation() {
        return this.binding.isAnnotationType();
    }

    public boolean isAnonymous() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    public boolean isArray() {
        return this.binding.isArrayType();
    }

    public boolean isAssignmentCompatible(ITypeBinding type) {
        if (this == type) {
            return true;
        }
        TypeBinding other = (TypeBinding)type;
        CompilationUnitScope scope = this.resolver.scope();
        if (scope == null) {
            return false;
        }
        return this.binding.isCompatibleWith(other.binding) || scope.isBoxingCompatibleWith(this.binding, other.binding);
    }

    public boolean isCapture() {
        return this.binding.isCapture();
    }

    public boolean isCastCompatible(ITypeBinding type) {
        Expression expression = new Expression(){

            public StringBuffer printExpression(int indent, StringBuffer output) {
                return null;
            }
        };
        CompilationUnitScope scope = this.resolver.scope();
        if (scope == null) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.TypeBinding expressionType = ((TypeBinding)type).binding;
        expressionType = expressionType.capture(scope, 0);
        return expression.checkCastTypesCompatibility(scope, this.binding, expressionType, null);
    }

    public boolean isClass() {
        return this.binding.isClass() && !this.binding.isTypeVariable() && !this.binding.isWildcard();
    }

    public boolean isDeprecated() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isEnum() {
        return this.binding.isEnum();
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TypeBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.TypeBinding otherBinding = ((TypeBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public boolean isFromSource() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isRawType()) {
                return !((RawTypeBinding)referenceBinding).type.isBinaryBinding();
            }
            if (referenceBinding.isParameterizedType()) {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
                org.eclipse.jdt.internal.compiler.lookup.TypeBinding erasure = parameterizedTypeBinding.erasure();
                if (erasure instanceof ReferenceBinding) {
                    return !((ReferenceBinding)erasure).isBinaryBinding();
                }
                return false;
            }
            return !referenceBinding.isBinaryBinding();
        }
        if (this.isTypeVariable()) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
            Binding declaringElement = typeVariableBinding.declaringElement;
            if (declaringElement instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)declaringElement;
                return !methodBinding.declaringClass.isBinaryBinding();
            }
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding typeBinding = (org.eclipse.jdt.internal.compiler.lookup.TypeBinding)declaringElement;
            if (typeBinding instanceof ReferenceBinding) {
                return !((ReferenceBinding)typeBinding).isBinaryBinding();
            }
            if (typeBinding instanceof ArrayBinding) {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                org.eclipse.jdt.internal.compiler.lookup.TypeBinding leafComponentType = arrayBinding.leafComponentType;
                if (leafComponentType instanceof ReferenceBinding) {
                    return !((ReferenceBinding)leafComponentType).isBinaryBinding();
                }
            }
        } else if (this.isCapture()) {
            CaptureBinding captureBinding = (CaptureBinding)this.binding;
            return !captureBinding.sourceType.isBinaryBinding();
        }
        return false;
    }

    public boolean isInterface() {
        return this.binding.isInterface() && !this.binding.isTypeVariable() && !this.binding.isWildcard();
    }

    public boolean isLocal() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isNested() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isNullType() {
        return this.binding == org.eclipse.jdt.internal.compiler.lookup.TypeBinding.NULL;
    }

    public boolean isParameterizedType() {
        return this.binding.isParameterizedType() && ((ParameterizedTypeBinding)this.binding).arguments != null;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public boolean isRawType() {
        return this.binding.isRawType();
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        if (this == type) {
            return true;
        }
        if (this.binding.isBaseType()) {
            return false;
        }
        TypeBinding other = (TypeBinding)type;
        if (other.binding.isBaseType()) {
            return false;
        }
        return this.binding.isCompatibleWith(other.binding);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isTopLevel() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isTypeVariable() {
        return this.binding.isTypeVariable() && !this.binding.isCapture();
    }

    public boolean isUpperbound() {
        return this.binding.isWildcard() && ((WildcardBinding)this.binding).boundKind == 1;
    }

    public boolean isWildcardType() {
        return this.binding.isWildcard();
    }

    private boolean shouldBeRemoved(MethodBinding methodBinding) {
        return methodBinding.isDefaultAbstract() || methodBinding.isSynthetic() || methodBinding.isConstructor() && this.isInterface();
    }

    public String toString() {
        return this.binding.toString();
    }
}

