/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.StringUtil;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DateUtil {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDD_HHMMSS = "yyyyMMdd-HHmmss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String MM_DD = "MM-dd";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String YYYY_MM = "yyyy-MM";
    public static final int SUB_YEAR = 1;
    public static final int SUB_MONTH = 2;
    public static final int SUB_DAY = 5;
    public static final int SUB_HOUR = 10;
    public static final int SUB_MINUTE = 12;
    public static final int SUB_SECOND = 13;
    static final String[] a = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final TimeZone b = TimeZone.getTimeZone("Asia/Shanghai");

    public static Date stringtoDate(String string, String string2) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(b);
        try {
            simpleDateFormat.setLenient(false);
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            date = null;
        }
        return date;
    }

    public static Date stringtoDate(String string, String string2, ParsePosition parsePosition) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(b);
        try {
            simpleDateFormat.setLenient(false);
            date = simpleDateFormat.parse(string, parsePosition);
        }
        catch (Exception exception) {
            date = null;
        }
        return date;
    }

    public static String dateToString(Date date, String string) {
        String string2 = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(b);
        try {
            string2 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String formatDate(String string, String string2) {
        Date date;
        if (StringUtil.isNotEmpty(string) && StringUtil.isNotEmpty(string2) && (date = DateUtil.stringtoDate(string, string2)) != null) {
            string = DateUtil.dateToString(date, string2);
        }
        return string;
    }

    public static String getCurrDate(String string) {
        return DateUtil.dateToString(new Date(), string);
    }

    public static String dateSub(int n, String string, int n2) {
        Date date = DateUtil.stringtoDate(string, YYYY_MM_DD_HH_MM_SS);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n, n2);
        return DateUtil.dateToString(calendar.getTime(), YYYY_MM_DD_HH_MM_SS);
    }

    public static long timeSub(String string, String string2) {
        long l = DateUtil.stringtoDate(string, YYYY_MM_DD_HH_MM_SS).getTime();
        long l2 = DateUtil.stringtoDate(string2, YYYY_MM_DD_HH_MM_SS).getTime();
        return (l2 - l) / 1000L;
    }

    public static int getDaysOfMonth(String string, String string2) {
        int n = 0;
        n = string2.equals("1") || string2.equals("3") || string2.equals("5") || string2.equals("7") || string2.equals("8") || string2.equals("10") || string2.equals("12") ? 31 : (string2.equals("4") || string2.equals("6") || string2.equals("9") || string2.equals("11") ? 30 : (Integer.parseInt(string) % 4 == 0 && Integer.parseInt(string) % 100 != 0 || Integer.parseInt(string) % 400 == 0 ? 29 : 28));
        return n;
    }

    public static int getDaysOfMonth(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static int getToday() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static int getToMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static int getToYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static long dayDiff(Date date, Date date2) {
        return (date2.getTime() - date.getTime()) / 86400000L;
    }

    public static int yearDiff(String string, String string2) {
        Date date = DateUtil.stringtoDate(string, YYYY_MM_DD);
        Date date2 = DateUtil.stringtoDate(string2, YYYY_MM_DD);
        return DateUtil.getYear(date2) - DateUtil.getYear(date);
    }

    public static int yearDiffCurr(String string) {
        Date date = new Date();
        Date date2 = DateUtil.stringtoDate(string, YYYY_MM_DD);
        return DateUtil.getYear(date) - DateUtil.getYear(date2);
    }

    public static long dayDiffCurr(String string) {
        Date date = DateUtil.stringtoDate(DateUtil.currDay(), YYYY_MM_DD);
        Date date2 = DateUtil.stringtoDate(string, YYYY_MM_DD);
        return (date.getTime() - date2.getTime()) / 86400000L;
    }

    public static int getFirstWeekdayOfMonth(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(7);
        calendar.set(n, n2 - 1, 1);
        return calendar.get(7);
    }

    public static int getLastWeekdayOfMonth(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(7);
        calendar.set(n, n2 - 1, DateUtil.getDaysOfMonth(n, n2));
        return calendar.get(7);
    }

    public static String getCurrDateTime() {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.dateToString(calendar.getTime(), YYYY_MM_DD_HH_MM_SS);
    }

    public static String getAstro(String string) {
        String string2;
        if (!DateUtil.isDate(string)) {
            string2 = string;
            string = new StringBuilder(20).append("2000").append(string2).toString();
        }
        if (!DateUtil.isDate(string)) {
            return "";
        }
        int n = Integer.parseInt(string.substring(string.indexOf("-") + 1, string.lastIndexOf("-")));
        int n2 = Integer.parseInt(string.substring(string.lastIndexOf("-") + 1));
        String string3 = "\u9b54\u7faf\u6c34\u74f6\u53cc\u9c7c\u7261\u7f8a\u91d1\u725b\u53cc\u5b50\u5de8\u87f9\u72ee\u5b50\u5904\u5973\u5929\u79e4\u5929\u874e\u5c04\u624b\u9b54\u7faf";
        int[] nArray = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
        int n3 = n * 2 - (n2 < nArray[n - 1] ? 2 : 0);
        string2 = string3.substring(n3, n3 + 2);
        return new StringBuilder(17).append(string2).append("\u5ea7").toString();
    }

    public static boolean isDate(String string) {
        StringBuffer stringBuffer = new StringBuffer("^((\\d{2}(([02468][048])|([13579][26]))-?((((0?");
        stringBuffer.append("[13578])|(1[02]))-?((0?[1-9])|([1-2][0-9])|(3[01])))");
        stringBuffer.append("|(((0?[469])|(11))-?((0?[1-9])|([1-2][0-9])|(30)))|");
        stringBuffer.append("(0?2-?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][12");
        stringBuffer.append("35679])|([13579][01345789]))-?((((0?[13578])|(1[02]))");
        stringBuffer.append("-?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))");
        stringBuffer.append("-?((0?[1-9])|([1-2][0-9])|(30)))|(0?2-?((0?[");
        stringBuffer.append("1-9])|(1[0-9])|(2[0-8]))))))");
        Pattern pattern = Pattern.compile(stringBuffer.toString());
        return pattern.matcher(string).matches();
    }

    public static Date nextMonth(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(2, n);
        return calendar.getTime();
    }

    public static Date nextDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(6, n);
        return calendar.getTime();
    }

    public static String nextDay(int n, String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(6, n);
        return DateUtil.dateToString(calendar.getTime(), string);
    }

    public static Date nextWeek(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(4, n);
        return calendar.getTime();
    }

    public static String currDay() {
        return DateUtil.dateToString(new Date(), YYYY_MM_DD);
    }

    public static String befoDay(int n) {
        return DateUtil.befoDay(n, YYYY_MM_DD);
    }

    public static String befoDay(int n, String string) {
        return DateUtil.dateToString(DateUtil.nextDay(new Date(), -n), string);
    }

    public static String afterDay() {
        return DateUtil.dateToString(DateUtil.nextDay(new Date(), 1), YYYY_MM_DD);
    }

    public static int getDayNum() {
        int n = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(1900, 0, 1);
        Date date2 = gregorianCalendar2.getTime();
        n = (int)((date.getTime() - date2.getTime()) / 86400000L);
        return n;
    }

    public static Date getDateByNum(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1900, 0, 1);
        Date date = gregorianCalendar.getTime();
        date = DateUtil.nextDay(date, n);
        return date;
    }

    public static String getYmdDateCN(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() < 10) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, 4)).append(string.substring(5, 7)).append(string.substring(8, 10));
        return stringBuffer.toString();
    }

    public static String getFirstDayOfMonth(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return DateUtil.dateToString(calendar.getTime(), string);
    }

    public static String getLastDayOfMonth(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return DateUtil.dateToString(calendar.getTime(), string);
    }

    public static String longToDate(long l, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(b);
        return simpleDateFormat.format(l);
    }
}

