/*
 * Decompiled with CFR 0.152.
 */
package com.gm.sm2;

import com.gm.sm2.SM2Constants;
import com.gm.sm2.SM2KeyPair;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;

public class SM2KeyHelper {
    public static SM2KeyPair generateKeyPair() {
        SecureRandom secureRandom = new SecureRandom();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(SM2Constants.DOMAIN_PARAMS, secureRandom);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new SM2KeyPair(eCPublicKeyParameters.getQ().getAffineXCoord().getEncoded(), eCPublicKeyParameters.getQ().getAffineYCoord().getEncoded(), eCPrivateKeyParameters.getD().toByteArray(), eCPublicKeyParameters.getQ().getEncoded(false));
    }

    public static ECPublicKeyParameters buildECPublicKeyParameters(SM2KeyPair sM2KeyPair) {
        return SM2KeyHelper.buildECPublicKeyParameters(sM2KeyPair.getPublicKeyX(), sM2KeyPair.getPublicKeyY());
    }

    public static ECPublicKeyParameters buildECPublicKeyParameters(byte[] byArray) {
        ECPoint eCPoint = SM2Constants.CURVE.decodePoint(byArray);
        return new ECPublicKeyParameters(eCPoint, SM2Constants.DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters buildECPublicKeyParameters(byte[] byArray, byte[] byArray2) {
        ECPoint eCPoint = SM2Constants.CURVE.createPoint(new BigInteger(1, byArray), new BigInteger(1, byArray2));
        return new ECPublicKeyParameters(eCPoint, SM2Constants.DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters buildECPrivateKeyParameters(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        return new ECPrivateKeyParameters(bigInteger, SM2Constants.DOMAIN_PARAMS);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

