/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.security;

import com.google.zxing.common.BitMatrix;
import com.hanweb.common.util.security.MatrixToImageConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public final class MatrixToImageWriter {
    private static final MatrixToImageConfig a = new MatrixToImageConfig();

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        return MatrixToImageWriter.toBufferedImage(bitMatrix, a);
    }

    public static BufferedImage toBufferedImage(BitMatrix bitMatrix, MatrixToImageConfig matrixToImageConfig) {
        int n = bitMatrix.getWidth();
        int n2 = bitMatrix.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, matrixToImageConfig.a());
        int n3 = matrixToImageConfig.getPixelOnColor();
        int n4 = matrixToImageConfig.getPixelOffColor();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage.setRGB(i, j, bitMatrix.get(i, j) ? n3 : n4);
            }
        }
        return bufferedImage;
    }

    public static void writeToFile(BitMatrix bitMatrix, String string, File file) throws IOException {
        MatrixToImageWriter.writeToFile(bitMatrix, string, file, a);
    }

    public static void writeToFile(BitMatrix bitMatrix, String string, File file, MatrixToImageConfig matrixToImageConfig) throws IOException {
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig);
        if (!ImageIO.write((RenderedImage)bufferedImage, string, file)) {
            File file2 = file;
            String string2 = string;
            throw new IOException(new StringBuilder(71).append("Could not write an image of format ").append(string2).append(" to ").append(file2).toString());
        }
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream) throws IOException {
        MatrixToImageWriter.writeToStream(bitMatrix, string, outputStream, a);
    }

    public static void writeToStream(BitMatrix bitMatrix, String string, OutputStream outputStream, MatrixToImageConfig matrixToImageConfig) throws IOException {
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig);
        if (!ImageIO.write((RenderedImage)bufferedImage, string, outputStream)) {
            String string2 = string;
            throw new IOException(new StringBuilder(51).append("Could not write an image of format ").append(string2).toString());
        }
    }
}

