/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.suwell.ofd.custom.agent.CCIS;
import com.suwell.ofd.custom.agent.ConvertAgent;
import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.agent.ConvertException;
import com.suwell.ofd.custom.agent.CustomHttpClientFactory;
import com.suwell.ofd.custom.agent.TransferCallback;
import com.suwell.ofd.custom.agent.callback.CallbackProxy;
import com.suwell.ofd.custom.agent.callback.EmptyTransferCallback;
import com.suwell.ofd.custom.wrapper.Packet;
import com.suwell.ofd.custom.wrapper.io.AutoCloseInputStream;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPAgent
extends ConvertAgent {
    private static Logger log = LoggerFactory.getLogger(HTTPAgent.class);
    private static Set<String> prepare;
    private static Set<String> doing;
    private static Set<String> success;
    private static Long period;
    private static Long waitTime;
    private static final String HEADER_SERVER_PATH = "X-Server-Path";
    private String baseURL;
    private long delay = period;
    private CloseableHttpClient client;
    private ThreadLocal<String> hds = new ThreadLocal();
    private Map<String, String> headers;
    private long maxWaitTime = waitTime;

    private static Set<String> fill(String v) {
        String[] array;
        HashSet<String> set = new HashSet<String>();
        if (v != null && (array = v.split(",")).length > 0) {
            for (String s : array) {
                set.add(s.trim());
            }
        }
        return set;
    }

    public HTTPAgent(String baseURL, long delay) {
        this(baseURL);
        this.delay = delay;
        log.debug("Query delay {}", (Object)this.delay);
    }

    public HTTPAgent(String baseURL, Map<String, String> headers) {
        this(baseURL);
        this.headers = headers;
    }

    public HTTPAgent(String baseURL, long delay, int PoolSize) {
        this(baseURL, delay);
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = Executors.newFixedThreadPool(PoolSize);
    }

    public HTTPAgent(String baseURL) {
        this.baseURL = baseURL;
        log.debug("Base url {}", (Object)baseURL);
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        this.init();
    }

    public HTTPAgent setMaxWaitTime(long time) {
        this.maxWaitTime = time;
        return this;
    }

    private void addHeader(HttpRequestBase hr) {
        if (this.headers != null) {
            for (Map.Entry<String, String> en : this.headers.entrySet()) {
                hr.addHeader(en.getKey(), en.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload(InputStream packet, String token, boolean raise) throws IOException {
        log.debug("Upload...");
        if (packet == null) {
            throw new IOException("Packet is null");
        }
        CloseableHttpClient client = CustomHttpClientFactory.createCloseableHttpClient();
        HttpPost post = new HttpPost(this.baseURL + "upload");
        this.addHeader((HttpRequestBase)post);
        MultipartEntityBuilder meb = MultipartEntityBuilder.create().addPart("file", (ContentBody)new InputStreamBody((InputStream)new AutoCloseInputStream(packet), ContentType.DEFAULT_BINARY, "packet"));
        if (token != null) {
            meb.addPart("token", (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN));
            meb.addPart("raise", (ContentBody)new StringBody(String.valueOf(raise), ContentType.TEXT_PLAIN));
        }
        HttpEntity body = meb.build();
        post.setEntity(body);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        try {
            Header uh = response.getLastHeader(HEADER_SERVER_PATH);
            if (uh != null) {
                this.hds.set(uh.getValue());
            }
            log.debug("Response {}", (Object)response.getStatusLine());
            HttpEntity entity = response.getEntity();
            String ret = EntityUtils.toString((HttpEntity)entity);
            log.debug("Ticket {}", (Object)ret);
            EntityUtils.consume((HttpEntity)entity);
            if (ret != null && ret.startsWith("Failed")) {
                throw new IOException("upload failed!".concat(ret));
            }
            String string = ret;
            return string;
        }
        finally {
            IOTools.closeQuietly((Closeable)response);
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String query(String ticket) throws IOException {
        log.debug("Query {} ...", (Object)ticket);
        CloseableHttpClient client = this.client;
        HttpGet get = new HttpGet(this.baseURL + "query?ticket=" + ticket);
        this.addHeader((HttpRequestBase)get);
        if (this.hds.get() != null) {
            log.debug("query " + this.hds.get());
            get.addHeader(HEADER_SERVER_PATH, this.hds.get());
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        try {
            log.debug("Response {}", (Object)response.getStatusLine());
            HttpEntity entity = response.getEntity();
            String ret = EntityUtils.toString((HttpEntity)entity);
            log.debug("Return {}", (Object)ret);
            EntityUtils.consume((HttpEntity)entity);
            String string = ret;
            return string;
        }
        finally {
            IOTools.closeQuietly((Closeable)response);
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String ticket, final OutputStream out) throws IOException {
        if (out == null) {
            log.debug("Out is null, skip download...");
            return;
        }
        log.debug("Download {} ...", (Object)ticket);
        CloseableHttpClient client = this.client;
        HttpGet get = new HttpGet(this.baseURL + "download?ticket=" + ticket);
        this.addHeader((HttpRequestBase)get);
        if (this.hds.get() != null) {
            log.debug("query " + this.hds.get());
            get.addHeader(HEADER_SERVER_PATH, this.hds.get());
            this.hds.remove();
        }
        try {
            client.execute((HttpUriRequest)get, (ResponseHandler)new AbstractResponseHandler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void handleEntity(HttpEntity entity) throws IOException {
                    InputStream is = entity.getContent();
                    log.info("is {} ", (Object)entity.getContentLength());
                    try {
                        long l = HTTPAgent.copy(is, out);
                        log.info("Receive {}", (Object)l);
                    }
                    catch (Throwable throwable) {
                        IOTools.closeQuietly((Closeable[])new Closeable[]{out, is});
                        EntityUtils.consume((HttpEntity)entity);
                        throw throwable;
                    }
                    IOTools.closeQuietly((Closeable[])new Closeable[]{out, is});
                    EntityUtils.consume((HttpEntity)entity);
                    return null;
                }
            });
        }
        finally {
            get.releaseConnection();
        }
    }

    public void convert(InputStream packet, OutputStream result, String token, boolean raise) throws ConvertException, IOException {
        String ticket = this.upload(packet, token, raise);
        String ret = null;
        long wait = System.currentTimeMillis();
        while (true) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (this.maxWaitTime > 0L && System.currentTimeMillis() - wait > this.maxWaitTime) {
                throw new ConvertException("Waiting time exceeded !");
            }
            ret = this.query(ticket);
            if (ret == null) {
                log.warn("\u8f6c\u6362\u56e0\u4e3a\u672a\u77e5\u539f\u56e0\u5931\u8d25");
                break;
            }
            if (!prepare.contains(ret = ret.trim()) && !doing.contains(ret)) break;
            log.debug("Continue...");
        }
        if (ret == null || !success.contains(ret) && !ret.startsWith("http")) {
            throw new ConvertException("Failed " + ret);
        }
        this.download(ticket, result);
    }

    public void convertNoWait(InputStream packet, ConvertCallback callback, String token, boolean raise) throws IOException {
        Object tc = callback instanceof TransferCallback ? (TransferCallback)callback : new EmptyTransferCallback();
        tc.onUploadStart();
        final TransferCallback itc = tc;
        final String ticket = this.upload((InputStream)new CCIS(packet){

            public void onClose() {
                itc.onUploadEnd();
            }
        }, token, raise);
        tc.onTicket(ticket);
        if (callback == null) {
            log.debug("Callback is null, only upload");
            return;
        }
        CallbackProxy cc = new CallbackProxy(callback);
        this.executor.execute(new Runnable((ConvertCallback)cc, itc){
            final /* synthetic */ ConvertCallback val$cc;
            final /* synthetic */ TransferCallback val$itc;
            {
                this.val$cc = convertCallback;
                this.val$itc = transferCallback;
            }

            @Override
            public void run() {
                String ret;
                boolean start = false;
                while (true) {
                    try {
                        Thread.sleep(HTTPAgent.this.delay);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        ret = HTTPAgent.this.query(ticket);
                    }
                    catch (IOException e) {
                        this.val$cc.onException((Exception)e);
                        return;
                    }
                    if (ret == null) {
                        log.warn("\u8f6c\u6362\u56e0\u4e3a\u672a\u77e5\u539f\u56e0\u5931\u8d25");
                        break;
                    }
                    ret = ret.trim();
                    if (prepare.contains(ret)) {
                        log.debug("Prepare...");
                        continue;
                    }
                    if (!doing.contains(ret)) break;
                    if (!start) {
                        start = true;
                        this.val$cc.onStart();
                    }
                    log.debug("Doing...");
                }
                if (ret != null && (success.contains(ret) || ret.startsWith("http"))) {
                    try {
                        this.val$itc.onDownloadStart();
                        HTTPAgent.this.download(ticket, this.val$cc.openOutput());
                        this.val$itc.onDownloadEnd();
                        this.val$cc.onSuccess();
                    }
                    catch (IOException e) {
                        this.val$cc.onException((Exception)e);
                    }
                } else {
                    this.val$cc.onFailed(ret, null);
                }
            }
        });
    }

    public String submit(InputStream packet, String token, boolean raise) throws IOException {
        return this.upload(packet, token, raise);
    }

    public String getWebReaderPath(Packet packet) throws ConvertException, IOException {
        return this.getWebReaderPath(packet, null, false);
    }

    public String getWebReaderPath(Packet packet, String token, boolean raise) throws ConvertException, IOException {
        return this.getWebReaderPath(ConvertAgent.store((Packet)packet), token, raise);
    }

    public String getWebReaderPath(InputStream packet) throws ConvertException, IOException {
        return this.getWebReaderPath(packet, null, false);
    }

    public String getWebReaderPath(InputStream packet, String token, boolean raise) throws ConvertException, IOException {
        String url = this.baseURL + "reader?file=";
        String ticket = this.upload(packet, token, raise);
        String ret = null;
        while (true) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ret = this.query(ticket);
            if (ret == null) {
                log.warn("\u8f6c\u6362\u56e0\u4e3a\u672a\u77e5\u539f\u56e0\u5931\u8d25");
                break;
            }
            if (!prepare.contains(ret = ret.trim()) && !doing.contains(ret)) break;
            log.debug("Continue...");
        }
        if (ret != null && (success.contains(ret) || ret.startsWith("http"))) {
            return url + ticket;
        }
        throw new ConvertException("Failed " + ret);
    }

    public void close() throws IOException {
        super.close();
        IOTools.closeQuietly((Closeable)this.client);
    }

    private void init() {
        this.client = CustomHttpClientFactory.createCloseableHttpClient();
    }

    static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[8192];
        int total = 0;
        int len = -1;
        while ((len = in.read(bytes)) != -1) {
            out.write(bytes, 0, len);
            total += len;
        }
        out.flush();
        return total;
    }

    static {
        Properties p = new Properties();
        try {
            p.load(HTTPAgent.class.getResourceAsStream("/http.properties"));
            prepare = HTTPAgent.fill(p.getProperty("prepare", ""));
            doing = HTTPAgent.fill(p.getProperty("doing", ""));
            success = HTTPAgent.fill(p.getProperty("success", ""));
            waitTime = Long.valueOf(p.getProperty("waitTime", "-1"));
            period = Long.valueOf(p.getProperty("period", "1000"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

