/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.bank;

import com.suwell.extend.xbrl.BankConst;
import com.suwell.extend.xbrl.model.BankElectronicReceiptXbrl;
import com.suwell.extend.xbrl.util.NameUtil;
import com.suwell.ofd.custom.agent.AtomAgent;
import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.Packet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class BankCompoundBase
implements BankConst {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private static final BankElectronicReceiptXbrl BERX = new BankElectronicReceiptXbrl();

    public void createOFDAddXbrl(AtomAgent atomAgent, String template, InputStream data, FileOutputStream out) throws Exception {
        this.createOFDAddXbrl(atomAgent, template, data, out, null);
    }

    public void createOFDAddXbrl(AtomAgent atomAgent, String template, InputStream data, FileOutputStream out, String attachName) throws Exception {
        final boolean[] isclone = new boolean[]{false};
        data = new BufferedInputStream(data){

            @Override
            public void close() throws IOException {
                if (isclone[0]) {
                    super.close();
                }
            }
        };
        data.mark(0);
        String ifc = "";
        String pringdata = "";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SAXReader reader = new SAXReader(FACTORY.newSAXParser().getXMLReader());
            Document document = reader.read(data);
            Element e = document.getRootElement();
            List les = e.elements();
            for (Element le : les) {
                if ("IdentifyingCode".equals(le.getName())) {
                    ifc = le.getText();
                }
                if ("DateOfBookkeeping".equals(le.getName())) {
                    pringdata = le.getText().replace("-", "");
                }
                map.put(le.getName(), le.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data.reset();
        isclone[0] = true;
        Packet w = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        w.data(PackEntry.wrap((InputStream)data), template, new String[0]);
        if (!StringUtils.isEmpty((CharSequence)ifc) && StringUtils.isEmpty((CharSequence)attachName)) {
            w.attach("bker_issuer_" + pringdata + "_" + ifc + NameUtil.getID(), "xml", (Object)PackEntry.wrap((byte[])BERX.createXbrl(map).getBytes()), false);
        } else {
            w.attach(attachName, "xml", (Object)PackEntry.wrap((byte[])BERX.createXbrl(map).getBytes()), false);
        }
        atomAgent.formbuilder(w, (OutputStream)out);
    }

    public void createOFDAddXbrl(AtomAgent atomAgent, String template, byte[] data, FileOutputStream out) throws Exception {
        this.createOFDAddXbrl(atomAgent, template, data, out, null);
    }

    public void createOFDAddXbrl(AtomAgent atomAgent, String template, byte[] data, FileOutputStream out, String attachName) throws Exception {
        String ifc = "";
        String pringdata = "";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SAXReader reader = new SAXReader(FACTORY.newSAXParser().getXMLReader());
            Document document = reader.read((InputStream)new ByteArrayInputStream(data));
            Element e = document.getRootElement();
            List les = e.elements();
            for (Element le : les) {
                if ("IdentifyingCode".equals(le.getName())) {
                    ifc = le.getText();
                }
                if ("DateOfBookkeeping".equals(le.getName())) {
                    pringdata = le.getText().replace("-", "");
                }
                map.put(le.getName(), le.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Packet w = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        w.data(PackEntry.wrap((byte[])data), template, new String[0]);
        if (!StringUtils.isEmpty((CharSequence)ifc) && StringUtils.isEmpty((CharSequence)attachName)) {
            w.attach("bker_issuer_" + pringdata + "_" + ifc + NameUtil.getID(), "xml", (Object)PackEntry.wrap((byte[])BERX.createXbrl(map).getBytes()), false);
        } else {
            w.attach(attachName, "xml", (Object)PackEntry.wrap((byte[])BERX.createXbrl(map).getBytes()), false);
        }
        atomAgent.formbuilder(w, (OutputStream)out);
    }

    public void createOFD(AtomAgent atomAgent, String template, FileInputStream data, FileOutputStream out) throws Exception {
        Packet w = new Packet(Const.PackType.COMMON, Const.Target.OFD);
        w.data(PackEntry.wrap((InputStream)data), template, new String[0]);
        atomAgent.formbuilder(w, (OutputStream)out);
    }
}

