/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl.model;

import com.suwell.extend.xbrl.model.BankXbrlCommon;
import com.suwell.extend.xbrl.model.BankXbrlContext;
import com.suwell.extend.xbrl.model.BankXbrlReceiptBase;
import com.suwell.extend.xbrl.model.TemplateModel;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class BankElectronicReceiptXbrl
extends BankXbrlReceiptBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TemplateModel getTemplateModel() {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(BankElectronicReceiptXbrl.class.getResourceAsStream("/electronic-receipt.json"), "utf-8");
            TemplateModel templateModel = this.loadTemplateModel(reader).init();
            IOUtils.closeQuietly((Reader)reader);
            return templateModel;
        }
        catch (Exception e) {
            TemplateModel templateModel = null;
            return templateModel;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public String createXbrl(Map<String, String> data) throws Exception {
        Map<String, String> map = this.templateModel.adjust(data);
        String ifc = map.get(this.templateModel.getIdName());
        String dob = map.get("DateOfBookkeeping");
        ifc = this.getId(ifc);
        String year = dob.split("-")[0];
        String id = "As_Of_".concat(year).concat("_").concat("12_31");
        String suf = this.templateModel.getNameSpace().concat(":");
        StringWriter w = new StringWriter();
        BankXbrlCommon common = new BankXbrlCommon(w, id, this.templateModel.getHead());
        if (this.templateModel.getLink() != null) {
            common.addLink(this.templateModel.getLink().getType(), this.templateModel.getLink().getHerf());
        }
        common.addContext(new BankXbrlContext().addEntity(ifc).addPeriod(year.concat("-12-31"))).addUnit(map.get(this.templateModel.getUnit())).addCommonData(map, this.templateModel.getMoney(), suf);
        common.close();
        return w.toString();
    }
}

