/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl.model;

import com.suwell.extend.xbrl.model.BankXbrlCommon;
import com.suwell.extend.xbrl.model.TemplateModel;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DataToXbrlHandler
extends DefaultHandler {
    private BankXbrlCommon common;
    private TemplateModel templateModel;
    private Map<String, String> rmap = new HashMap<String, String>();
    private Map<String, String> imap = new HashMap<String, String>();
    private boolean item;
    private String name;
    private String suf;

    public DataToXbrlHandler(BankXbrlCommon common, TemplateModel templateModel) {
        this.common = common;
        this.templateModel = templateModel;
        this.suf = this.templateModel.getNameSpace().concat(":");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals("Root")) {
            this.name = null;
        } else if (qName.equals(this.templateModel.getItemName())) {
            this.item = true;
            this.name = null;
        } else {
            String k;
            TemplateModel.Box box = this.templateModel.getMap().get(qName);
            if (box != null && (k = box.getName()) != null) {
                this.name = k;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        try {
            if (qName.equals(this.templateModel.getItemName())) {
                this.common.addItemData(this.imap, this.templateModel.getMoney(), this.suf, this.templateModel.getItemName());
                this.imap.clear();
            } else if (qName.equals("Root")) {
                this.common.addCommonData(this.rmap, this.templateModel.getMoney(), this.suf);
            } else {
                this.name = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.name != null && ch.length > 0) {
            String v = new String(ch, start, length);
            Map<String, String> cv = this.templateModel.getValueMap().get(this.name);
            if (cv != null) {
                v = cv.get(v);
            }
            if (this.item) {
                this.imap.put(this.name, v);
            } else {
                this.rmap.put(this.name, v);
            }
        }
    }
}

