/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend.xbrl.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TemplateModel {
    private List<String> head;
    private String nameSpace;
    private String itemName;
    private Link link;
    private Map<String, Box> map;
    private Set<String> money;
    private Map<String, Map<String, String>> valueMap;
    private String unit;
    private String idName;
    private Box idBox;

    public String getUnit() {
        return this.unit;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public TemplateModel setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public List<String> getHead() {
        return this.head;
    }

    public String getIdName() {
        return this.idName;
    }

    public Box getIdBox() {
        return this.idBox;
    }

    public String getItemName() {
        if (this.itemName == null) {
            this.init();
        }
        return this.itemName;
    }

    public Link getLink() {
        return this.link;
    }

    public TemplateModel setLink(Link link) {
        this.link = link;
        return this;
    }

    public Map<String, Box> getMap() {
        return this.map;
    }

    public TemplateModel setMap(Map<String, Box> map) {
        this.map = map;
        return this;
    }

    public Set<String> getMoney() {
        if (this.money == null) {
            this.init();
        }
        return this.money;
    }

    public Map<String, Map<String, String>> getValueMap() {
        if (this.valueMap == null) {
            this.init();
        }
        return this.valueMap;
    }

    public TemplateModel init() {
        this.money = new HashSet<String>();
        this.valueMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Box> m : this.map.entrySet()) {
            switch (m.getValue().getType()) {
                case ItemName: {
                    this.itemName = m.getKey();
                    break;
                }
                case Money: {
                    this.money.add(m.getValue().name);
                    break;
                }
                case Unit: {
                    this.unit = m.getValue().name;
                    break;
                }
                case ID: {
                    this.idName = m.getValue().name;
                    this.idBox = m.getValue();
                    break;
                }
            }
            if (m.getValue().getValueMap() == null) continue;
            this.valueMap.put(m.getValue().name, m.getValue().valueMap);
        }
        return this;
    }

    protected Map<String, String> adjust(Map<String, String> data) throws ParseException {
        Map<String, Box> map = this.getMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Box> m : map.entrySet()) {
            String name = m.getKey();
            String ov = data.get(name);
            Box box = m.getValue();
            if (ov == null || StringUtils.isEmpty((CharSequence)ov)) continue;
            switch (box.getType()) {
                case Date: {
                    if (box.getSourceFormat() == null || box.getTargetFormat() == null || box.getSourceFormat().equals(box.getTargetFormat())) break;
                    SimpleDateFormat ds = new SimpleDateFormat(box.getSourceFormat());
                    SimpleDateFormat dt = new SimpleDateFormat(box.getTargetFormat());
                    ov = dt.format(ds.parse(ov));
                    break;
                }
                case Money: {
                    ov = ov.replace(",", "");
                    break;
                }
                default: {
                    Map<String, String> vm = box.getValueMap();
                    if (vm == null) break;
                    ov = vm.get(ov);
                }
            }
            name = box.getName();
            hashMap.put(name, ov);
        }
        return hashMap;
    }

    public static enum Type {
        Unit,
        Date,
        ItemName,
        Money,
        Common,
        ID;

    }

    public static class Box {
        private String name;
        private Type type = Type.Common;
        private Map<String, String> valueMap;
        private String sourceFormat;
        private String targetFormat;
        private List<Integer> split;

        public List<Integer> getSplit() {
            return this.split;
        }

        public String getName() {
            return this.name;
        }

        public Box setName(String name) {
            this.name = name;
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public Box setType(Type type) {
            this.type = type;
            return this;
        }

        public Map<String, String> getValueMap() {
            return this.valueMap;
        }

        public Box setValueMap(Map<String, String> valueMap) {
            this.valueMap = valueMap;
            return this;
        }

        public String getSourceFormat() {
            return this.sourceFormat;
        }

        public Box setSourceFormat(String sourceFormat) {
            this.sourceFormat = sourceFormat;
            return this;
        }

        public String getTargetFormat() {
            return this.targetFormat;
        }

        public Box setTargetFormat(String targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }
    }

    public static class Link {
        private String type;
        private String herf;

        public String getType() {
            return this.type;
        }

        public Link setType(String type) {
            this.type = type;
            return this;
        }

        public String getHerf() {
            return this.herf;
        }

        public Link setHerf(String herf) {
            this.herf = herf;
            return this;
        }
    }
}

