/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert;

import cpcns.convert.NoConvertorException;
import cpcns.convert.PoolNotFoundException;
import cpcns.convert.impl.BasePlugin;
import cpcns.convert.impl.ConvertorPool;
import cpcns.convert.impl.IConvertor;
import cpcns.convert.impl.IConvertorPlugin;
import cpcns.convert.impl.PluginClassLoader;
import cpcns.detect.Detectors;
import cpcns.util.FileUtils;
import cpcns.util.IOUtils;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Convertors {
    private static Log log = LogFactory.getLog(Convertors.class);
    private static final String PLUGIN_DIR_OLD = "PLUGIN_DIR";
    public static final String PLUGIN_DIR_NEW = "Plugin.Dir";
    private static final String PLUGIN_JAR_NAME = "(?i)plugin\\-.+\\.jar";
    private static Map<String, ConvertorPool<? extends IConvertor>> pools = new HashMap<String, ConvertorPool<? extends IConvertor>>();
    private static Map<String, TreeSet<E>> cache = new HashMap<String, TreeSet<E>>();

    private static void load() {
        ArrayList<URL> jars = new ArrayList<URL>();
        String dir = System.getProperty(PLUGIN_DIR_OLD);
        if (dir == null) {
            dir = System.getProperty(PLUGIN_DIR_NEW);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find plugin dir : " + dir));
        }
        if (dir != null) {
            String[] dirs;
            for (String path : dirs = dir.split(";")) {
                if (path == null || path.length() == 0) continue;
                File file = new File(path);
                if (path.startsWith(".")) {
                    file = new File(System.getProperty("user.dir"), path);
                }
                Convertors.find(jars, file, 1);
            }
        }
        for (URL url : jars) {
            Convertors.load(url);
        }
    }

    private static void load(URL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find and load plugin jar : " + url));
        }
        PluginClassLoader pcl = new PluginClassLoader(new URL[]{url}, Convertors.class.getClassLoader());
        ServiceLoader<IConvertorPlugin> sl = ServiceLoader.load(IConvertorPlugin.class, pcl);
        for (IConvertorPlugin plugin : sl) {
            String name = plugin.name();
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Find plugin : " + name));
            }
            if (plugin.load()) {
                ConvertorPool<? extends IConvertor> pool = new ConvertorPool<IConvertor>(name, plugin.size(), plugin.factory());
                pools.put(name, pool);
                if (plugin instanceof BasePlugin) {
                    BasePlugin ocp = (BasePlugin)plugin;
                    Map<String, Integer> map = ocp.canProcess();
                    for (Map.Entry<String, Integer> en : map.entrySet()) {
                        String type = en.getKey();
                        int cost = en.getValue();
                        TreeSet<E> set = cache.get(type);
                        if (set == null) {
                            set = new TreeSet();
                            cache.put(type, set);
                        }
                        set.add(new E(cost, pool));
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Load complete");
                continue;
            }
            log.warn((Object)"Load failed!");
        }
    }

    private static void find(List<URL> list, File file, int level) {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            String name = file.getName();
            if (name.matches(PLUGIN_JAR_NAME)) {
                try {
                    list.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            if (level > 2) {
                return;
            }
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    Convertors.find(list, f, level + 1);
                }
            }
        }
    }

    public static ConvertorPool<IConvertor> getPool(String name) {
        return pools.get(name);
    }

    public static ConvertorPool<IConvertor> findPool(String type) {
        return Convertors.findPool(type, 0);
    }

    private static ConvertorPool<IConvertor> findPool(String type, int index) {
        if (type == null) {
            return null;
        }
        TreeSet<E> set = cache.get(type);
        if (set != null && index < set.size()) {
            int i = 0;
            for (E o : set) {
                if (i++ != index) continue;
                return o.pool;
            }
        }
        return null;
    }

    private static boolean hasNext(String type, int index) {
        return Convertors.findPool(type, index + 1) != null;
    }

    public static void dispose() {
        cache.clear();
        for (ConvertorPool<? extends IConvertor> c : pools.values()) {
            c.dispose();
        }
    }

    public static boolean toOFD(String type, Object src, Object dest, Map<String, ?> args) throws PoolNotFoundException, NoConvertorException, Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert " + type + " to OFD"));
        }
        return Convertors.toOFD(type, src, dest, args, 0);
    }

    public static boolean convert(File src, File dst) throws PoolNotFoundException, NoConvertorException, Exception {
        return Convertors.convert(src, dst, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convert(File src, File dst, Map<String, ?> map) throws PoolNotFoundException, NoConvertorException, Exception {
        String name;
        int i;
        String suffix = Detectors.suffix((File)src);
        if (suffix == null && (i = (name = src.getName()).lastIndexOf(".")) != -1) {
            suffix = name.substring(i + 1);
        }
        if (suffix == null) {
            throw new NullPointerException("Unkown file format!");
        }
        if ("ofd".equals(suffix)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Source is ofd, return!");
            }
            return false;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        String name2 = src.getName().toLowerCase();
        Object source = src;
        if (!name2.endsWith("." + suffix)) {
            name2 = name2 + "." + suffix;
            source = FileUtils.openInputStream((File)src);
        }
        if (map != null) {
            args.putAll(map);
        }
        args.put("_srcName", name2);
        args.put("_dstName", dst.getName());
        try {
            boolean bl = Convertors.toOFD(suffix, source, dst, args);
            return bl;
        }
        finally {
            if (source instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)source));
            }
        }
    }

    private static boolean toOFD(String type, Object src, Object dst, Map<String, ?> args, int index) throws PoolNotFoundException, NoConvertorException, Exception {
        ConvertorPool<IConvertor> pool = Convertors.findPool(type.toLowerCase(), index);
        if (pool == null) {
            if (index == 0) {
                throw new PoolNotFoundException(type, index);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use pool " + pool.name()));
        }
        Exception ex = null;
        try {
            if (Convertors.doConvert(pool, src, dst, args)) {
                return true;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Convert failed!");
        }
        if (Convertors.hasNext(type, index)) {
            return Convertors.toOFD(type, src, dst, args, index + 1);
        }
        if (ex != null) {
            throw ex;
        }
        return false;
    }

    public static boolean convert(String name, Object src, Object dest, Map<String, ?> args) throws PoolNotFoundException, NoConvertorException, Exception {
        ConvertorPool<IConvertor> pool;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert use " + name));
        }
        if ((pool = Convertors.getPool(name)) == null) {
            throw new PoolNotFoundException(name);
        }
        return Convertors.doConvert(pool, src, dest, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doConvert(ConvertorPool<IConvertor> pool, Object src, Object dst, Map<String, ?> args) throws NoConvertorException, Exception {
        Object c = pool.get(1L, TimeUnit.MINUTES);
        if (c == null) {
            throw new NoConvertorException(pool.name());
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Convertor " + c));
            }
            boolean bl = c.convert(src, dst, args);
            return bl;
        }
        finally {
            pool.release((IConvertor)c);
        }
    }

    public static void main(String[] args) {
        System.setProperty(PLUGIN_DIR_NEW, "D:/build73/plugin");
        System.out.println(System.getProperty(PLUGIN_DIR_NEW));
        System.out.println(Convertors.getPool("pdf2ofd"));
    }

    static {
        Convertors.load();
    }

    private static class E
    implements Comparable<E> {
        private int cost;
        private ConvertorPool<? extends IConvertor> pool;

        public E(int cost, ConvertorPool<? extends IConvertor> pool) {
            this.cost = cost;
            this.pool = pool;
        }

        @Override
        public int compareTo(E o) {
            return this.cost - o.cost;
        }
    }
}

