/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.impl;

import cpcns.convert.impl.IConvertor;
import cpcns.convert.impl.PluginUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseConvertor
implements IConvertor {
    protected static Log log = LogFactory.getLog(BaseConvertor.class);
    private PluginUtil.Space[] spaces;
    protected Object src;
    protected Object dest;
    protected Map<String, ?> args;

    public void setSpaces(PluginUtil.Space[] spaces) {
        this.spaces = spaces;
    }

    @Override
    public final boolean convert(Object src, Object dest) throws Exception {
        return this.convert(src, dest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean convert(Object src, Object dest, Map<String, ?> args) throws Exception {
        Exception ex;
        this.src = src;
        this.dest = dest;
        this.args = args;
        long time = this.maxWaitTime();
        if (time <= 0L) {
            return this.doConvert();
        }
        FutureTask<Boolean> ft = new FutureTask<Boolean>(new Task());
        new Thread(ft, Thread.currentThread().getName()).start();
        try {
            Boolean b = ft.get(time, TimeUnit.MILLISECONDS);
            boolean bl = b == null ? false : b;
            return bl;
        }
        catch (TimeoutException e) {
            this.whenTimeout(e);
            ex = e;
        }
        catch (Exception e) {
            ex = e;
        }
        finally {
            this.release();
        }
        ft.cancel(true);
        this.destroy();
        throw ex;
    }

    protected void release() {
        this.dest = null;
        this.src = null;
        this.args = null;
    }

    protected abstract boolean doConvert() throws Exception;

    protected long maxWaitTime() throws Exception {
        long size = this.sourceSize();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Source size is " + size));
        }
        int m = 15;
        if (this.spaces != null) {
            if (size < 0L) {
                PluginUtil.Space s = this.spaces[this.spaces.length - 1];
                m = s.time;
            } else {
                for (PluginUtil.Space s : this.spaces) {
                    if (s.min >= size || size > s.max) continue;
                    m = s.time;
                    break;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timeout is " + m + " minutes"));
        }
        return TimeUnit.MINUTES.toMillis(m);
    }

    protected long sourceSize() throws IOException {
        return 0L;
    }

    protected void whenTimeout(TimeoutException e) {
        log.error((Object)("Timeout: " + e));
    }

    private class Task
    implements Callable<Boolean> {
        private Task() {
        }

        @Override
        public Boolean call() throws Exception {
            return BaseConvertor.this.doConvert();
        }
    }
}

