/*
 * Decompiled with CFR 0.152.
 */
package cpcns.convert.ziputils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvelopeOptions {
    protected static final Log LOG = LogFactory.getLog(EnvelopeOptions.class);
    public static final byte ENVELOP_MODE_PASSWORD = 0;
    public static final byte ENVELOP_MODE_MACHINE = 3;
    public static final byte ENVELOP_MODE_USBKEY = 8;
    private int envelopeMode = 0;
    private String password = null;
    private String machinecode = null;
    private String pubkeyLoc = null;

    public int getEnvelopeMode() {
        return this.envelopeMode;
    }

    public void setEnvelopeMode(int envelopeMode) {
        this.envelopeMode = envelopeMode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMachinecode() {
        return this.machinecode;
    }

    public void setMachinecode(String machinecode) {
        this.machinecode = machinecode;
    }

    public String getPubkeyLoc() {
        return this.pubkeyLoc;
    }

    public void setPubkeyLoc(String pubkeyLoc) {
        this.pubkeyLoc = pubkeyLoc;
    }

    public void reportSelf() {
        Properties prop = this.getProperty();
        prop.list(System.out);
    }

    private Properties getProperty() {
        Properties prop = new Properties();
        prop.setProperty("envelope_mode", String.valueOf(this.envelopeMode));
        if (this.password != null) {
            prop.setProperty("password", this.password);
        }
        if (this.machinecode != null) {
            prop.setProperty("machinecode", this.machinecode);
        }
        if (this.pubkeyLoc != null) {
            prop.setProperty("pubkeyloc", this.pubkeyLoc);
        }
        return prop;
    }

    public void saveToFile(String file) {
        Properties prop = this.getProperty();
        try {
            prop.store(new FileOutputStream(file), "OFD\u8f6c\u6362\u684c\u9762\u5de5\u5177\u5305\u88c5\u914d\u7f6e\u9879");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
    }

    public void loadFromFile(String file) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(f));
            this.envelopeMode = Integer.valueOf((String)prop.get("envelope_mode"));
            this.password = (String)prop.get("password");
            this.machinecode = (String)prop.get("machinecode");
            this.pubkeyLoc = (String)prop.get("pubkeyLoc");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
    }
}

