/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend;

import com.suwell.extend.SimpleStringTemplate;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FPXbrlCreator {
    private static final String TEMPLATE;
    private static final String DATA_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String UNDERLINE = "_";
    private static final String AXIS = "NumberOfEInvoiceReceiptLineNumberAxis";

    public static String createXBRL(String xml) throws Exception {
        if (xml == null) {
            throw new NullPointerException(" data is null !");
        }
        Document document = new SAXReader().read((Reader)new StringReader(xml));
        Element rootElement = document.getRootElement();
        HashMap<String, String> map = new HashMap<String, String>();
        FPXbrlCreator.templateData(rootElement, map);
        FPXbrlCreator.adjust(map);
        return SimpleStringTemplate.processTemplate(TEMPLATE, map);
    }

    static void adjust(Map<String, String> data) throws ParseException {
        String date = data.get("IssueDate");
        String no = data.get("InvoiceNo");
        SimpleDateFormat ds = new SimpleDateFormat(DATA_FORMAT);
        Date dt = ds.parse(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dt);
        String year = calendar.get(1) + "";
        String id = "As_of_".concat(year).concat(UNDERLINE).concat("12_31_").concat(AXIS).concat(UNDERLINE).concat(no);
        data.put("ID", id);
        data.put("Instant", year.concat("-12-31"));
    }

    static void templateData(Element element, Map<String, String> retain) {
        List es = element.elements();
        if (es != null && es.size() > 0) {
            for (Element e : es) {
                if (e.getName().contains("GoodsInfos")) {
                    return;
                }
                FPXbrlCreator.templateData(e, retain);
            }
        } else {
            String v = element.getTextTrim();
            String k = element.getName();
            retain.put(k, v != null ? v : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStream2String(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        try {
            String data;
            StringBuilder sb = new StringBuilder();
            while ((data = br.readLine()) != null) {
                sb.append(data).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            IOTools.closeQuietly((Closeable)br);
        }
    }

    public static void main(String[] args) throws Exception {
        String s = FPXbrlCreator.inputStream2String(new FileInputStream("D:\\1\\1.xml"));
        System.out.println(FPXbrlCreator.createXBRL(s));
    }

    static {
        InputStream stream = FPXbrlCreator.class.getResourceAsStream("/fp-template.xml");
        String xml = "";
        try {
            xml = FPXbrlCreator.inputStream2String(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEMPLATE = xml;
    }
}

