/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper;

import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.Utils;
import com.suwell.ofd.custom.wrapper.model.MarkPosition;
import com.suwell.ofd.custom.wrapper.model.Pair;
import com.suwell.ofd.custom.wrapper.model.SafeMaskInfo;
import com.suwell.ofd.custom.wrapper.model.SealInfo;
import com.suwell.ofd.custom.wrapper.model.SignInfo;
import com.suwell.ofd.custom.wrapper.model.TextInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class MainXML<E extends MainXML, T>
implements Closeable {
    private static final String BOOL_TRUE = "true";
    private static final String BOOL_FALSE = "false";
    protected final Document main = DocumentHelper.createDocument();
    protected final Element root;
    protected Document metadata;
    protected int index;
    private final E e;
    private boolean merge = true;

    protected MainXML() {
        this.main.setXMLEncoding("UTF-8");
        this.root = DocumentHelper.createElement((String)"FileRoot");
        this.main.setRootElement(this.root);
        this.e = this.init();
    }

    protected Element findOrNew(Element parent, String name) {
        if (parent == null || name == null) {
            return null;
        }
        Element e = parent.element(name);
        if (e == null) {
            e = parent.addElement(name);
        }
        return e;
    }

    protected void writeXML(Document doc, OutputStream os) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setIndent(true);
        XMLWriter xw = new XMLWriter(os, format);
        xw.write(doc);
        xw.flush();
    }

    public String data(T tpl, T fileLoc, String title, String hasNext, Pair<String, String> ... ps) {
        Element component = this.findOrNew(this.root, "DocBody").addElement("Component");
        String id = String.valueOf(this.index++);
        component.addAttribute("ID", id);
        Element data = component.addElement("Data");
        if (hasNext != null && hasNext.length() > 0) {
            data.addAttribute("Info_HasNext", hasNext);
        }
        if (title != null) {
            data.addAttribute("Title", title);
        }
        if (ps != null) {
            for (Pair<String, String> p : ps) {
                data.addAttribute(p.key(), p.value());
            }
        }
        if (tpl != null) {
            data.addElement("Template").setText(this.preset(tpl));
        }
        if (fileLoc != null) {
            data.addElement("FileLoc").setText(this.preset(fileLoc));
        }
        return id;
    }

    public String data(T data, String tplName, String hasnext, String[] relationNames) {
        Element component = this.findOrNew(this.root, "DocBody").addElement("Component");
        String id = String.valueOf(this.index++);
        component.addAttribute("ID", id);
        Element ed = component.addElement("Data");
        if (hasnext != null && hasnext.length() > 0) {
            ed.addAttribute("Info_HasNext", hasnext);
        }
        StringBuilder name = new StringBuilder(tplName);
        if (relationNames != null) {
            for (String rel : relationNames) {
                name.append(";").append(rel);
            }
        }
        ed.addElement("Template").setText("Template://" + name);
        ed.addElement("FileLoc").setText(this.preset(data));
        return id;
    }

    public String file(T in, String title, String format, String decryptName, String decryptParameter, Pair<String, String> ... ps) {
        Element component = this.findOrNew(this.root, "DocBody").addElement("Component");
        String id = String.valueOf(this.index++);
        component.addAttribute("ID", id);
        Element file = component.addElement("File");
        if (title != null) {
            file.addAttribute("Title", title);
        }
        if (format != null) {
            file.addAttribute("Format", format);
        }
        if (ps != null) {
            for (Pair<String, String> p : ps) {
                file.addAttribute(p.key(), p.value());
            }
        }
        Element fileLoc = file.addElement("FileLoc");
        if (in != null) {
            fileLoc.setText(this.preset(in));
        }
        if (decryptName != null) {
            Element dp = file.addElement("DecodeProvider");
            dp.addAttribute("Name", decryptName);
            if (decryptParameter != null) {
                dp.addElement("Parameter").addCDATA(decryptParameter);
            }
        }
        return id;
    }

    public String file(T in, String title, String format, Pair<String, String> ... ps) {
        return this.file(in, title, format, (String)null, (String)null, ps);
    }

    public E setMerge(boolean merge) {
        this.findOrNew(this.root, "DocBody").addAttribute("Merge", merge + "");
        return this.e;
    }

    public E metadata(Const.Meta key, Object value) {
        if (key == null || value == null) {
            return this.e;
        }
        if (this.metadata == null) {
            this.metadata = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"MetaRoot"));
        }
        Element md = this.metadata.getRootElement();
        switch (key) {
            case KEYWORDS: {
                String[] ks;
                for (String v : ks = ((String)value).split(",")) {
                    this.metadata(Const.Meta.KEYWORD, v.trim());
                }
                break;
            }
            case KEYWORD: {
                Element kse = this.findOrNew(md, Const.Meta.KEYWORDS.xmlName());
                kse.addElement(Const.Meta.KEYWORD.xmlName()).setText((String)value);
                break;
            }
            case CUSTOM_DATAS: {
                String[] cds;
                for (String v : cds = ((String)value).split(",")) {
                    this.metadata(Const.Meta.CUSTOM_DATA, v);
                }
                break;
            }
            case CUSTOM_DATA: {
                String[] kv = value instanceof String[] ? (String[])value : ((String)value).split("=");
                if (kv.length != 2) break;
                Element cde = this.findOrNew(md, Const.Meta.CUSTOM_DATAS.xmlName());
                cde.addElement(Const.Meta.CUSTOM_DATA.xmlName()).addAttribute("Name", kv[0]).setText(kv[1]);
                break;
            }
            case MOD_DATE: {
                this.findOrNew(md, key.xmlName()).setText(new SimpleDateFormat("yyyy-MM-dd").format(Utils.toDate(value)));
                break;
            }
            case EXTEND_FILE: {
                if (this.isT(value)) {
                    this.findOrNew(md, key.xmlName()).setText(this.preset(value));
                    break;
                }
                if (value instanceof InputStream) {
                    this.metadata(key, PackEntry.wrap((InputStream)value));
                    break;
                }
                if (!(value instanceof File)) break;
                this.metadata(key, PackEntry.wrap((File)value));
                break;
            }
            default: {
                this.findOrNew(md, key.xmlName()).setText((String)value);
            }
        }
        return this.e;
    }

    public E permission(Const.Perm name, Object value) {
        Element ep = this.findOrNew(this.root, "Permissions");
        switch (name) {
            case PRINT_COPIES: {
                this.findOrNew(ep, Const.Perm.PRINT.xmlName()).addAttribute("Copies", String.valueOf(Utils.toInteger(value)));
                break;
            }
            case COPY: 
            case SAVE_AS: 
            case EXPORT: {
                this.findOrNew(ep, "Export").addAttribute(name.xmlName(), String.valueOf(Utils.toBoolean(value)));
                break;
            }
            case VALID_START: 
            case VALID_END: {
                this.findOrNew(ep, "ValidPeriod").addAttribute(name.xmlName(), String.valueOf(Utils.toDate(value)));
                break;
            }
            case PRINT: 
            case ANNOT: 
            case ASSEM: 
            case SIGNATURE: 
            case WATERMARK: {
                this.findOrNew(ep, name.xmlName()).addAttribute("Value", String.valueOf(Utils.toBoolean(value)));
            }
        }
        return this.e;
    }

    public E view(Const.View name, Object value) {
        if (name == null || value == null) {
            return this.e;
        }
        Element vp = this.findOrNew(this.root, "VPreferences");
        this.findOrNew(vp, name.xmlName()).setText(value.toString());
        return this.e;
    }

    public E attach(String title, String type, T in, boolean visible) {
        return this.attach(title, type, -1L, false, this.preset(in), visible);
    }

    public E attach(String title, String type, URI in, boolean visible) {
        return this.attach(title, type, -1L, false, in.toString(), visible);
    }

    protected E attach(String title, String type, long fileSize, boolean emptyFile, String in, boolean visible) {
        Element as = this.findOrNew(this.root, "Attachs");
        Element attach = as.addElement("Attach");
        attach.addAttribute("AttachTitle", title);
        attach.addAttribute("LogicType", type);
        attach.addAttribute("Format", type);
        if (!visible) {
            attach.addAttribute("Visible", visible + "");
        }
        if (emptyFile) {
            attach.addAttribute("EmptyFile", String.valueOf(emptyFile));
            attach.addAttribute("FileSize", String.valueOf(fileSize));
        } else {
            attach.addElement("FileLoc").setText(in);
        }
        return this.e;
    }

    public E customTag(String tagroot, String prefix, String href, String version, Pair<String, String> ... otherRootAttrs) {
        Element ct = this.findOrNew(this.root, "CustomTag");
        if (otherRootAttrs != null) {
            for (Pair<String, String> attr : otherRootAttrs) {
                ct.addAttribute(attr.key(), attr.value());
            }
        }
        if (tagroot != null) {
            ct.addElement("TagRoot").setText(tagroot);
        }
        if (version != null) {
            ct.addElement("Version").setText(version);
        }
        Element ns = ct.addElement("NameSpace");
        ns.addAttribute("Prefix", prefix);
        if (href != null) {
            ns.addAttribute("Href", href);
        }
        return this.e;
    }

    protected Element newProvider(String parentName) {
        Element es = this.findOrNew(this.root, "Security");
        Element ep = es.addElement(parentName);
        return ep.addElement("Provider");
    }

    protected Element newSignature(String parentName) {
        Element es = this.findOrNew(this.root, "Security");
        Element ep = es.addElement(parentName);
        return ep;
    }

    @Deprecated
    public E signature(String provider, boolean lockSign) {
        Element external = this.newProvider("Signature").addAttribute("LockSign", lockSign + "").addElement("External");
        external.addAttribute("Name", provider);
        return this.e;
    }

    public E signature(String provider, boolean lockSign, SignInfo<T> signInfo) {
        Element signature = this.newSignature("Signature").addAttribute("LockSign", lockSign + "");
        signature.addElement("Provider").addElement("External").addAttribute("Name", provider);
        if (signInfo != null) {
            Element signinfo = signature.addElement("SignInfo").addAttribute("CertID", signInfo.getCertID()).addAttribute("Password", signInfo.getPassword());
            if (signInfo.getExtend().size() > 0) {
                for (Map.Entry<Const.SignatureExtendKey, String> extendKeyStringEntry : signInfo.getExtend().entrySet()) {
                    Element extend = signinfo.addElement("Extend");
                    extend.addAttribute("Name", extendKeyStringEntry.getKey().name());
                    extend.setText(extendKeyStringEntry.getValue());
                }
            }
            if (signInfo.getTextInfo() != null || signInfo.getImage() != null) {
                Element watermark = signinfo.addElement("Watermark");
                watermark.addAttribute("Printable", String.valueOf(signInfo.isPrintable()));
                watermark.addAttribute("Visible", String.valueOf(signInfo.isVisible()));
                if (signInfo.getTextInfo() != null) {
                    this.transferTextMark(watermark.addElement("TextMark"), signInfo.getTextInfo(), signInfo.getPosition());
                } else if (signInfo.getImage() != null) {
                    Element imageMark = watermark.addElement("ImageMark");
                    String type = signInfo.getType();
                    imageMark.addText(this.preset(signInfo.getImage()) + type != null ? ".".concat(type) : "");
                    this.transferMarkPosition(imageMark, signInfo.getPosition(), true);
                }
            }
        }
        return this.e;
    }

    protected Element transferTextMark(Element mark, TextInfo text, MarkPosition pos) {
        mark.setText(text.getText());
        mark.addAttribute("FontName", text.getFontName());
        if (!(text.getFontSize() > 0.0f)) {
            throw new IllegalArgumentException("FontSize Must be greater than 0 !");
        }
        mark.addAttribute("FontSize", String.valueOf(text.getFontSize()));
        mark.addAttribute("Color", text.getColor());
        mark.addAttribute("Rotate", String.valueOf(text.getRotate()));
        if (text.getOpacity() > 0 && text.getOpacity() <= 100) {
            mark.addAttribute("Opacity", text.getOpacity() + "");
        }
        if (text.isTile()) {
            mark.addAttribute("Tile", Boolean.TRUE + "");
        }
        if (text.getXAlign() == null) {
            mark.addAttribute("XPosType", Const.XAlign.Absolute.toString());
        } else {
            mark.addAttribute("XPosType", text.getXAlign().toString());
        }
        if (text.getYAlign() == null) {
            mark.addAttribute("YPosType", Const.YAlign.Absolute.toString());
        } else {
            mark.addAttribute("YPosType", text.getYAlign().toString());
        }
        if (text.getxStep() > 0) {
            mark.addAttribute("XStep", String.valueOf(text.getxStep()));
        }
        if (text.getyStep() > 0) {
            mark.addAttribute("YStep", String.valueOf(text.getyStep()));
        }
        if (text.isRichText()) {
            mark.addAttribute("RichText", String.valueOf(text.isRichText()));
        }
        if (text.isBold()) {
            mark.addAttribute("Bold", BOOL_TRUE);
        }
        if (text.isItalic()) {
            mark.addAttribute("Italic", BOOL_TRUE);
        }
        if (text.getLineSpace() > 0) {
            mark.addAttribute("LineSpace", text.getLineSpace() + "");
        }
        if (text.getCharSpace() > 0) {
            mark.addAttribute("CharSpace", text.getCharSpace() + "");
        }
        this.transferMarkPosition(mark, pos, false);
        return mark;
    }

    protected Element addMaker() {
        Element ws = this.findOrNew(this.root, "Watermarks");
        return ws.addElement("Watermark");
    }

    public E addImageMark(T image, MarkPosition pos, boolean printable, boolean visible, int opacity) {
        String target;
        Element watermark = this.addMaker();
        watermark.addAttribute("Printable", String.valueOf(printable));
        watermark.addAttribute("Visible", String.valueOf(visible));
        Element imageMark = watermark.addElement("ImageMark");
        if (opacity > 0) {
            imageMark.addAttribute("Opacity", String.valueOf(opacity));
        }
        if ((target = pos.getTarget()) != null) {
            watermark.addAttribute("Target", target);
        }
        this.transferMarkPosition(imageMark, pos, true);
        imageMark.addText(this.preset(image));
        return this.e;
    }

    private void transferMarkPosition(Element mark, MarkPosition pos, boolean isImageMark) {
        Element Parameter;
        if (mark == null || pos == null) {
            return;
        }
        Pair[] pairs = new Pair[]{new Pair<String, Const.XAlign>("XPosType", pos.getxAlign()), new Pair<String, Const.YAlign>("YPosType", pos.getyAlign()), new Pair<String, Integer>("XStep", pos.getxStep()), new Pair<String, Integer>("YStep", pos.getyStep()), new Pair<String, Integer>("Rotate", pos.getRotate()), new Pair<String, Boolean>("Tile", pos.isTile()), new Pair<String, Float>(isImageMark ? "PosX" : "X", Float.valueOf(pos.getX())), new Pair<String, Float>(isImageMark ? "PosY" : "Y", Float.valueOf(pos.getY())), new Pair<String, Float>("Height", Float.valueOf(pos.getHeight())), new Pair<String, Float>("Width", Float.valueOf(pos.getWidth())), new Pair<String, Float>("Width", Float.valueOf(pos.getWidth())), new Pair<String, Boolean>("AsPageObject", pos.isAsPageObject())};
        String pages = null;
        if (pos.getIndex() != null && pos.getIndex() != MarkPosition.INDEX_ALL) {
            pages = Utils.toString(pos.getIndex());
        } else if (pos.getPages() != null) {
            String string = pages = pages == null ? Utils.toString(pos.getPages()) : pages + "," + Utils.toString(pos.getPages());
        }
        if (pages != null) {
            mark.addAttribute("Pages", pages);
        }
        for (Pair pair : pairs) {
            if (pair.value() == null) continue;
            mark.addAttribute((String)pair.key(), String.valueOf(pair.value()));
        }
        if (pos.getMargin() != null) {
            Parameter = this.findOrNew(mark.getParent(), "Parameters").addElement("Parameter");
            Parameter.addAttribute("Name", "Margin");
            float[] margin = pos.getMargin();
            Parameter.setText(margin[0] + "," + margin[1] + "," + margin[2] + "," + margin[3]);
        }
        if (pos.isAsPageObject()) {
            Parameter = this.findOrNew(mark.getParent(), "Parameters").addElement("Parameter");
            Parameter.addAttribute("Name", "AsPageObject");
            Parameter.setText(BOOL_TRUE);
        }
    }

    protected void addTextMark(TextInfo text, MarkPosition pos, boolean printable, boolean visible, String flag) {
        String target;
        Element watermark = this.addMaker();
        watermark.addAttribute("Printable", String.valueOf(printable));
        watermark.addAttribute("Visible", String.valueOf(visible));
        if (flag != null) {
            watermark.addAttribute("Name", flag);
        }
        if ((target = pos.getTarget()) != null) {
            watermark.addAttribute("Target", target);
        }
        this.transferTextMark(watermark.addElement("TextMark"), text, pos);
    }

    public E addTimeStamp(String provider) {
        Element p = this.newProvider("Signature");
        p.getParent().addAttribute("TimeStamp", BOOL_TRUE);
        Element external = p.addElement("External");
        external.addAttribute("Name", provider);
        return this.e;
    }

    public E seal(String provider, String oesClass, SealInfo info) {
        Element ep = this.newProvider("EleSeal");
        Element external = ep.addElement("External");
        external.addAttribute("Name", provider);
        external.addAttribute("OESClassName", oesClass);
        this.transferSealInfo(info, ep.getParent());
        return this.e;
    }

    protected void transferSealInfo(SealInfo info, Element eSeal) {
        Element e = eSeal.addElement("SealInfo");
        e.addAttribute("SealID", info.getSealID());
        if (info.getLocInfos() != null) {
            for (SealInfo.LocInfo sl : info.getLocInfos()) {
                Element li = e.addElement("LocInfo");
                li.addAttribute("X", String.valueOf(sl.getPosX()));
                li.addAttribute("Y", String.valueOf(sl.getPosY()));
                li.addAttribute("W", String.valueOf(sl.getWidth()));
                li.addAttribute("H", String.valueOf(sl.getHeight()));
                li.addAttribute("Index", String.valueOf(sl.getIndex()));
            }
            return;
        }
        e.addAttribute("PosX", String.valueOf(info.getX()));
        e.addAttribute("PosY", String.valueOf(info.getY()));
        e.addAttribute("SealWidth", String.valueOf(info.getWidth()));
        e.addAttribute("SealHeight", String.valueOf(info.getHeight()));
        if (info.getUserID() != null) {
            e.addAttribute("UserID", info.getUserID());
        }
        if (info.isPercentPos()) {
            e.addAttribute("PercentPos", Boolean.TRUE.toString());
        }
        if (info.getPassword() != null) {
            e.addAttribute("Password", info.getPassword());
        }
        if (info.getExtend().size() > 0) {
            for (Map.Entry<Const.SignatureExtendKey, String> extendKeyStringEntry : info.getExtend().entrySet()) {
                Element extend = e.addElement("Extend");
                extend.addAttribute("Name", extendKeyStringEntry.getKey().name());
                extend.setText(extendKeyStringEntry.getValue());
            }
        }
        if (info.getTypeC() != null) {
            e.addAttribute("Type", info.getTypeC());
            if (info.getTypeC().equals(SealInfo.NativeType.All.toString()) && info.getStampAnnot() != null) {
                for (SealInfo.StampAnnot sa : info.getStampAnnot()) {
                    Element el = e.addElement("StampAnnot");
                    el.addAttribute("Type", sa.getType().toString());
                    el.addAttribute("Boundary", sa.getX() + " " + sa.getY() + " " + sa.getWidth() + " " + sa.getHeight());
                }
            }
        } else {
            switch (info.getType()) {
                case 0: {
                    e.addAttribute("Type", "First");
                    break;
                }
                case 0x7FFFFFFF: {
                    e.addAttribute("Type", "Last");
                    break;
                }
                case -1: {
                    e.addAttribute("Type", "All");
                    break;
                }
                default: {
                    e.addAttribute("Type", "Custom");
                    e.addAttribute("PageIndex", String.valueOf(info.getPageIndex()));
                }
            }
        }
    }

    public E envelope(Const.EnvelopeType type, String password, Map<Const.EnvelopePerm, Boolean> perms, String provider, Pair<Const.EnvelopeMeta, Object> ... meta) {
        Element env = this.findOrNew(this.root, "Envelope");
        this.transferEnvMeta(env, meta);
        this.transferEnvPerm(env, perms);
        if (provider != null) {
            env.addElement("Provider").addAttribute("Name", provider);
        }
        Element pwd = env.addElement("Password");
        pwd.addAttribute("Type", type.toString());
        if (password != null) {
            pwd.addAttribute("Val", password);
        }
        return this.e;
    }

    protected void transferEnvPerm(Element env, Map<Const.EnvelopePerm, Boolean> perms) {
        if (perms == null || perms.isEmpty()) {
            return;
        }
        Element pm = env.addElement("Permission");
        for (Const.EnvelopePerm perm : Const.EnvelopePerm.values()) {
            this.findOrNew(pm, String.valueOf((Object)perm)).setText(String.valueOf(false));
        }
        for (Map.Entry entry : perms.entrySet()) {
            Boolean v = (Boolean)entry.getValue();
            if (v == null) continue;
            this.findOrNew(pm, ((Const.EnvelopePerm)((Object)entry.getKey())).xmlName()).setText(String.valueOf(v));
        }
    }

    protected void transferEnvMeta(Element env, Pair<Const.EnvelopeMeta, Object> ... meta) {
        if (meta == null || meta.length == 0) {
            return;
        }
        Element m = env.addElement("Meta");
        for (Pair<Const.EnvelopeMeta, Object> pair : meta) {
            if (pair.key() == null) continue;
            m.addAttribute(pair.key().xmlName(), String.valueOf(pair.value()));
        }
    }

    public E seceret(int index, float x, float y, float width, float height) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element sc = ep.addElement("Seceret");
        sc.addAttribute("PageIndex", String.valueOf(index));
        sc.addAttribute("PosX", String.valueOf(x));
        sc.addAttribute("PosY", String.valueOf(y));
        sc.addAttribute("Width", String.valueOf(width));
        sc.addAttribute("Height", String.valueOf(height));
        return this.e;
    }

    public E rotate(float rotate, int ... pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element er = ep.addElement("Rotate");
        er.addAttribute("Rotate", String.valueOf(rotate));
        er.addAttribute("Pages", Utils.toString(pages));
        return this.e;
    }

    public E deletePage(int ... pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element dp = this.findOrNew(ep, "DeletePage");
        dp.addAttribute("Pages", Utils.toString(pages));
        return this.e;
    }

    public E swapPage(Pair<Integer, Integer> ... swap) {
        Element ep = this.findOrNew(this.root, "Operate");
        if (swap != null) {
            for (Pair<Integer, Integer> pair : swap) {
                Element page = ep.addElement("SwapPage");
                page.addAttribute("PageIndex1", String.valueOf(pair.key()));
                page.addAttribute("PageIndex2", String.valueOf(pair.value()));
            }
        }
        return this.e;
    }

    public E removeSeal(Const.SealMode mode, boolean delete) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element RemoveSeal = this.findOrNew(ep, "RemoveSeal");
        RemoveSeal.addAttribute(mode.xmlName(), String.valueOf(delete));
        return this.e;
    }

    public E insertPage(T source, int srcStart, int srcEnd, int index) {
        return this.insertPage(source, srcStart, srcEnd, index, "ofd");
    }

    public E invoke(String type, String module, String method, Pair<String, String> ... pairs) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element invoke = ep.addElement("Invoke");
        if (type != null) {
            invoke.addAttribute("Type", type);
        }
        if (module != null) {
            invoke.addAttribute("Module", module);
        }
        if (method != null) {
            invoke.addAttribute("Method", method);
        }
        if (pairs != null && pairs.length > 0) {
            for (Pair<String, String> pair : pairs) {
                Element arg = invoke.addElement("Argument").addCDATA(pair.value());
                if (pair.key() == null) continue;
                arg.addAttribute("Name", pair.key());
            }
        }
        return this.e;
    }

    public E insertPage(T source, int srcStart, int srcEnd, int index, String format) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element page = this.findOrNew(ep, "InsertPage");
        page.addAttribute("FileLoc", this.preset(source));
        if (srcStart > 0) {
            page.addAttribute("From", String.valueOf(srcStart));
        }
        if (srcEnd > 0) {
            page.addAttribute("To", String.valueOf(srcEnd));
        }
        page.addAttribute("Index", String.valueOf(index));
        if (format != null) {
            page.addAttribute("Format", format);
        }
        return this.e;
    }

    public E resultEncryptProvider(String name, String parameter) {
        if (name == null) {
            throw new NullPointerException("name is null !");
        }
        Element rep = this.findOrNew(this.root, "ResultEncryptProvider");
        rep.addAttribute("Name", name);
        if (parameter != null) {
            rep.addElement("Parameter").addCDATA(parameter);
        }
        return this.e;
    }

    public E safeMask(SafeMaskInfo<T> safeMaskInfo) {
        SafeMaskInfo.EncryptMode encryptMode;
        Element sm = this.findOrNew(this.root, "SafeMask");
        SafeMaskInfo.EncryptType encryptType = safeMaskInfo.getEncryptType();
        if (encryptType != null) {
            sm.element("EncryptType").addAttribute("Type", encryptType.name());
        }
        if ((encryptMode = safeMaskInfo.getEncryptMode()) != null) {
            switch (encryptMode) {
                case Pin: {
                    if (safeMaskInfo.getPassword() == null || safeMaskInfo.getPassword().length() == 0) {
                        throw new IllegalArgumentException("Password is null !");
                    }
                    if (safeMaskInfo.getPassword().length() > 50) {
                        throw new IllegalArgumentException("The password contains a maximum of 50 characters !");
                    }
                    sm.addElement("EncryptMode").addElement("Pin").addAttribute("Password", safeMaskInfo.getPassword());
                    break;
                }
                case Cert: {
                    T[] t = safeMaskInfo.getEncryptModeValue();
                    if (t == null || t.length == 0) {
                        throw new IllegalArgumentException("EncryptModeValue is null !");
                    }
                    Element ce = sm.addElement("EncryptMode").addElement("Cert");
                    for (int i = 0; i < t.length; ++i) {
                        String v = this.preset(t[i]);
                        ce.addElement("CertLoc").setText(v);
                    }
                    break;
                }
            }
        }
        if (safeMaskInfo.getPermissions().size() > 0) {
            Element p = sm.addElement("Permissions");
            Set<Map.Entry<String, String>> set = safeMaskInfo.getPermissions().entrySet();
            for (Map.Entry<String, String> entry : set) {
                p.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        return this.e;
    }

    private boolean isT(Object o) {
        try {
            Utils.getClassT(this, 1).cast(o);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected abstract String preset(T var1);

    protected abstract E init();
}

