/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper;

import com.suwell.ofd.custom.wrapper.Packet;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public abstract class PackEntry
implements Closeable {
    protected MessageDigest digester;
    protected byte[] result;
    protected byte[] hash;

    public abstract InputStream open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public byte[] digestResult() {
        return this.result;
    }

    public void setHash(byte[] hash) {
        if (hash != null) {
            this.hash = hash;
            if (this.digester == null) {
                try {
                    this.digester = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void digest() throws IOException {
        if (this.digester != null) {
            if (this.result == null) {
                this.result = this.digester.digest();
            }
            if (this.hash != null && !Arrays.equals(this.result, this.hash)) {
                throw new IOException("Hash is not match");
            }
        }
    }

    public static PackEntry wrap(InputStream in) {
        return PackEntry.wrap(in, null);
    }

    public static PackEntry wrap(File in) {
        return PackEntry.wrap(in, null);
    }

    public static PackEntry wrap(InputStream in, MessageDigest md) {
        return in == null ? null : new Stream(in, md);
    }

    public static PackEntry wrap(File in, MessageDigest md) {
        return in == null ? null : new Filer(in, md);
    }

    public static PackEntry wrap(byte[] in) {
        return PackEntry.wrap(new ByteArrayInputStream(in));
    }

    public static class Name
    extends PackEntry {
        private Packet packet;
        private String name;
        private PackEntry e;

        Name(Packet packet, String name) {
            this.packet = packet;
            this.name = name;
        }

        public String value() {
            return this.name;
        }

        @Override
        public InputStream open() throws IOException {
            if (this.e == null) {
                this.e = this.packet.findEntry(this.name);
            }
            return this.e == null ? null : this.e.open();
        }

        @Override
        public byte[] digestResult() {
            return this.e.digestResult();
        }

        @Override
        public void close() {
            IOTools.closeQuietly((Closeable)this.e);
        }
    }

    public static class Stream
    extends PackEntry {
        private InputStream in;

        private Stream(InputStream in, MessageDigest md) {
            this.in = in;
            this.digester = md;
        }

        @Override
        public InputStream open() throws IOException {
            return this.digester == null ? this.in : new DigestInputStream(this.in, this.digester){

                @Override
                public void close() throws IOException {
                    super.close();
                    Stream.this.digest();
                }
            };
        }

        @Override
        public void close() throws IOException {
            IOTools.closeQuietly((Closeable)this.in);
        }
    }

    public static class Filer
    extends PackEntry {
        private InputStream fis;
        private File file;

        private Filer(File file, MessageDigest md) {
            this.file = file;
            this.digester = md;
        }

        @Override
        public InputStream open() throws IOException {
            if (this.fis == null) {
                this.fis = IOTools.openInputStream(this.file);
                if (this.digester != null) {
                    return new DigestInputStream(this.fis, this.digester){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            Filer.this.digest();
                        }
                    };
                }
            }
            return this.fis;
        }

        @Override
        public void close() throws IOException {
            IOTools.closeQuietly((Closeable)this.fis);
        }
    }
}

