/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.MainXML;
import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.PackException;
import com.suwell.ofd.custom.wrapper.Utils;
import com.suwell.ofd.custom.wrapper.io.AutoCloseInputStream;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import com.suwell.ofd.custom.wrapper.model.CA;
import com.suwell.ofd.custom.wrapper.model.CipherProvider;
import com.suwell.ofd.custom.wrapper.model.Common;
import com.suwell.ofd.custom.wrapper.model.GetTogether;
import com.suwell.ofd.custom.wrapper.model.Group;
import com.suwell.ofd.custom.wrapper.model.ImageInfo;
import com.suwell.ofd.custom.wrapper.model.InvokePair;
import com.suwell.ofd.custom.wrapper.model.MarkPosition;
import com.suwell.ofd.custom.wrapper.model.PageNumber;
import com.suwell.ofd.custom.wrapper.model.Pair;
import com.suwell.ofd.custom.wrapper.model.SealImage;
import com.suwell.ofd.custom.wrapper.model.SealInfo;
import com.suwell.ofd.custom.wrapper.model.SignInfo;
import com.suwell.ofd.custom.wrapper.model.SimpleTextInfo;
import com.suwell.ofd.custom.wrapper.model.Template;
import com.suwell.ofd.custom.wrapper.model.TextInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class Packet
extends MainXML<Packet, PackEntry> {
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
    private static final String PREFIX = Packet.class.getSimpleName() + "-SF-";
    private static final String META_NAME = PREFIX + "Meta.xml";
    private final Map<String, PackEntry> entities;
    private boolean packed;
    private boolean closed;

    public Packet(Const.PackType type, Const.Target target) {
        this(type.value(), target);
    }

    public Packet(String custom, Const.Target target) {
        if (target == null) {
            target = Const.Target.OFD;
        }
        this.entities = new LinkedHashMap<String, PackEntry>();
        this.root.addAttribute("Target", target.value());
        this.root.addAttribute("Type", custom);
    }

    public Packet autoVersion() {
        this.root.addAttribute("AutoVersion", "true");
        return this;
    }

    public Packet(Const.Target target, boolean decryptSeal, boolean decryptContent, boolean decryptImage) {
        if (target == null) {
            target = Const.Target.OFD;
        }
        this.entities = new LinkedHashMap<String, PackEntry>();
        this.root.addAttribute("Target", target.value());
        this.root.addAttribute("Type", "Native.parser");
        this.root.addAttribute("DecryptSeal", decryptSeal + "");
        this.root.addAttribute("DecryptContent", decryptContent + "");
        this.root.addAttribute("DecryptImage", decryptImage + "");
    }

    public Packet decryptSeal(boolean decryptSeal, boolean decryptContent, boolean decryptImage) {
        this.root.addAttribute("DecryptSeal", decryptSeal + "");
        this.root.addAttribute("DecryptContent", decryptContent + "");
        this.root.addAttribute("DecryptImage", decryptImage + "");
        return this;
    }

    public static Packet common() {
        return new Packet(Const.PackType.COMMON, Const.Target.OFD);
    }

    public static Packet commonSplit(int ... splitPoint) {
        Packet packet = new Packet("common.split", Const.Target.MERGE);
        packet.clip(0.0f, 0.0f, 0.0f, 0.0f, splitPoint);
        return packet;
    }

    public static Packet archivesSeal(Pair<String, String>[] ps, float x, float y, int opacity, boolean moveable, String tid, int ... pages) {
        String text = "";
        if (ps != null) {
            StringBuilder sb = new StringBuilder();
            for (Pair<String, String> p : ps) {
                sb.append(p.key());
                if (p.key() == null) continue;
                sb.append('=').append(p.value()).append(';');
            }
            text = sb.deleteCharAt(sb.length() - 1).toString();
        }
        Packet packet = new Packet("archives.seal", Const.Target.OFD);
        TextInfo info = new TextInfo(text, "perch", 15.0f);
        if (opacity > 0) {
            info.setOpacity(opacity);
        }
        packet.addTextMark(info, new MarkPosition(x, y, 0.0f, 0.0f, pages).setTile(moveable), true, true, "Archives".concat(tid != null ? ":" + tid : ""));
        return packet;
    }

    public static Packet archivesSeal(Pair<String, String>[] ps, float x, float y, int opacity, int ... pages) {
        return Packet.archivesSeal(ps, x, y, opacity, false, null, pages);
    }

    public static Packet html() {
        return new Packet(Const.PackType.HTML, Const.Target.OFD);
    }

    @Override
    protected String preset(PackEntry packEntry) {
        return this.presetEntry(packEntry, null).value();
    }

    @Override
    protected Packet init() {
        return this;
    }

    public PackEntry.Name presetEntry(PackEntry in) {
        return this.presetEntry(in, null);
    }

    public PackEntry.Name presetEntry(PackEntry in, String suffix) {
        return this.presetEntry(in, null, suffix);
    }

    public PackEntry.Name presetEntry(PackEntry in, String name, String suffix) {
        if (in instanceof PackEntry.Name) {
            return (PackEntry.Name)in;
        }
        String string = name = name == null ? Utils.UUID() : name;
        if (suffix != null) {
            name = suffix.startsWith(".") ? name + suffix : name + "." + suffix;
            this.entities.put(name, in);
            return new PackEntry.Name(this, name);
        }
        this.entities.put(name, in);
        return new PackEntry.Name(this, name);
    }

    PackEntry findEntry(String name) {
        return this.entities.get(name);
    }

    public Packet fileHandler(String name, String fhClass, Pair<String, String> ... parameters) {
        Element fh = this.findOrNew(this.root, "FileHandler");
        fh.addAttribute("Name", name);
        fh.addAttribute("ClassName", fhClass);
        if (parameters != null) {
            for (Pair<String, String> pair : parameters) {
                Element param = fh.addElement("Param");
                param.addAttribute("Name", pair.key());
                param.setText(pair.value());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(OutputStream out) throws IOException {
        if (this.packed) {
            throw new IOException("Already packed");
        }
        this.packed = true;
        if (this.index == 0) {
            throw new IOException("Need at least one file or data!");
        }
        long time = 1531549140000L;
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(out);
        try {
            for (Map.Entry<String, PackEntry> en : this.entities.entrySet()) {
                PackEntry e = en.getValue();
                if (e == null || e instanceof PackEntry.Name) continue;
                ZipArchiveEntry zae = new ZipArchiveEntry(en.getKey());
                zae.setTime(time);
                zaos.putArchiveEntry((ArchiveEntry)zae);
                IOTools.copy(new AutoCloseInputStream(e.open()), (OutputStream)zaos);
                zaos.closeArchiveEntry();
            }
            if (this.entities.containsKey(META_NAME)) {
                this.root.addElement("Metadata").setText(META_NAME);
            } else if (this.metadata != null) {
                String metaName = "_Metadata.xml";
                if (this.entities.containsKey(metaName)) {
                    metaName = "_" + metaName;
                }
                ZipArchiveEntry zae = new ZipArchiveEntry(metaName);
                zae.setTime(time);
                zaos.putArchiveEntry((ArchiveEntry)zae);
                this.root.addElement("Metadata").setText(metaName);
                this.writeXML(this.metadata, (OutputStream)zaos);
                zaos.closeArchiveEntry();
            }
            ZipArchiveEntry zae = new ZipArchiveEntry("Main.xml");
            zae.setTime(time);
            zaos.putArchiveEntry((ArchiveEntry)zae);
            this.writeXML(this.main, (OutputStream)zaos);
            zaos.closeArchiveEntry();
            zaos.finish();
        }
        finally {
            IOTools.closeQuietly((Closeable)zaos);
            IOTools.closeQuietly((Closeable)this);
        }
    }

    public String data(Template tpl) throws PackException {
        return this.data(tpl, null);
    }

    public String data(Template tpl, String hasnext) throws PackException {
        Map<String, PackEntry> sheet;
        String handler;
        ArrayList<Pair<String, String>> lp = new ArrayList<Pair<String, String>>();
        if (tpl.getOfficeType() != null) {
            lp.add(new Pair<String, String>("TempType", tpl.getOfficeType().toString()));
        }
        if (tpl.getDataType() != null) {
            lp.add(new Pair<String, String>("DataType", tpl.getDataType().toString()));
        }
        if ((handler = tpl.getHandler()) != null) {
            lp.add(new Pair<String, String>("DataHandler", tpl.getHandler()));
        }
        if ((sheet = tpl.getSheet()) != null) {
            for (Map.Entry<String, PackEntry> pair : sheet.entrySet()) {
                this.entities.put(pair.getKey(), pair.getValue());
            }
        }
        return this.data(tpl.getTemplate(), tpl.getData(), tpl.getTitle(), hasnext, lp.toArray(new Pair[lp.size()]));
    }

    public String data(PackEntry data, String tplName, String ... relationNames) {
        return this.data(data, tplName, (String)null, relationNames);
    }

    public String file(Common common) throws PackException {
        ArrayList<Pair<String, String>> lp = new ArrayList<Pair<String, String>>();
        if (common.getDPI() > 0) {
            lp.add(new Pair<String, String>("ImageDPI", String.valueOf(common.getDPI())));
        }
        if (common.getWidth() > 0.0f) {
            lp.add(new Pair<String, String>("PageWidth", String.valueOf(common.getWidth())));
        }
        if (common.getHeight() > 0.0f) {
            lp.add(new Pair<String, String>("PageHeight", String.valueOf(common.getHeight())));
        }
        if (common.getArgument() != null) {
            String args = common.getArgument().value();
            lp.add(new Pair<String, String>("Argument", args));
        }
        URI uri = common.getURI();
        PackEntry.Name pn = null;
        if (uri != null) {
            pn = new PackEntry.Name(this, uri.toString());
        } else {
            PackEntry in = common.getData();
            GetTogether together = common.getTogether();
            if (in != null) {
                pn = this.presetEntry(in, PREFIX + this.index, common.getFormat());
            } else if (together != null) {
                pn = this.presetEntry(together.getMainPath().value(), together.getMainPath().key(), common.getFormat());
                Map<String, PackEntry> items = together.getItems();
                if (items != null && items.size() > 0) {
                    for (Map.Entry<String, PackEntry> entryEntry : items.entrySet()) {
                        this.presetEntry(entryEntry.getValue(), entryEntry.getKey(), null);
                    }
                }
            }
        }
        if (common.getDecryptInfo() != null) {
            return this.file(pn, common.getTitle(), common.getFormat(), common.getDecryptInfo().key(), common.getDecryptInfo().value(), lp.toArray(new Pair[lp.size()]));
        }
        return this.file(pn, common.getTitle(), common.getFormat(), lp.toArray(new Pair[lp.size()]));
    }

    @Deprecated
    public Outline outline(String title, String refID) {
        Element outline = this.findOrNew(this.root, "Outline");
        return new Outline(outline).append(title, refID);
    }

    public Outline outline(String title, int pageIndex, float left, float top) {
        Element outline = this.findOrNew(this.root, "Outline");
        return new Outline(outline).append(title, pageIndex, left, top);
    }

    public Packet metadata(InputStream in) {
        this.entities.put(META_NAME, PackEntry.wrap(in));
        return this;
    }

    public Packet attach(String title, String type, InputStream in) throws PackException {
        return this.attach(title, type, PackEntry.wrap(in));
    }

    @Override
    public Packet attach(String title, String type, InputStream in, boolean visible) throws PackException {
        return (Packet)this.attach(title, type, PackEntry.wrap(in), visible);
    }

    public Packet attach(String title, String type, PackEntry in) throws PackException {
        this.attach(title, type, in, true);
        return this;
    }

    public Packet customTag(String tagroot, String prefix, String href, Pair<String, String> ... otherRootAttrs) {
        return (Packet)this.customTag(tagroot, prefix, href, (String)null, otherRootAttrs);
    }

    @Deprecated
    public Packet imageMark(InputStream image, String imageType, MarkPosition pos, boolean printable, boolean visible, String name) {
        this.addImageMark(PackEntry.wrap(image), imageType, pos, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, name);
        return this;
    }

    @Deprecated
    public Packet addImageMark(PackEntry image, String imageType, MarkPosition pos, Const.XAlign xAlign, Const.YAlign yAlign, boolean printable, boolean visible, String flag) {
        this.addImageMark(new ImageInfo(image, imageType, 0), pos, xAlign, yAlign, printable, visible, flag, 255, pos.isPattern());
        return this;
    }

    @Deprecated
    public Packet addImageMark(InputStream image, String imageType, MarkPosition position, boolean printable, boolean visible, String flag, int alpha) {
        int a = 0;
        if (alpha < 255) {
            a = alpha / 255 * 100;
        }
        this.addImageMark(new ImageInfo(PackEntry.wrap(image), imageType, a), position, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, flag, alpha, true);
        return this;
    }

    @Deprecated
    public Packet addImageMark(URI uri, String imageType, MarkPosition position, boolean printable, boolean visible, String flag, int alpha) {
        this.addImageMark(new ImageInfo(uri, imageType), position, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, flag, alpha, true);
        return this;
    }

    @Deprecated
    public Packet addImageMark(URI uri, String imageType, MarkPosition pos, boolean printable, boolean visible, String flag, int alpha, boolean isTile) {
        this.addImageMark(new ImageInfo(uri, imageType), pos, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, flag, alpha, isTile);
        return this;
    }

    @Deprecated
    public Packet addImageMark(InputStream image, String imageType, MarkPosition pos, boolean printable, boolean visible, String flag, int alpha, boolean isTile) {
        this.addImageMark(new ImageInfo(image, imageType), pos, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, flag, alpha, isTile);
        return this;
    }

    private Element transferImageMark(ImageInfo imageInfo, MarkPosition pos, Const.XAlign xAlign, Const.YAlign yAlign, int alpha, boolean isTile) {
        Element mark = DocumentHelper.createElement((String)"ImageMark");
        if (imageInfo.getUri() != null) {
            mark.setText(imageInfo.getUri().toString());
        } else {
            mark.setText(this.presetEntry(imageInfo.getEntry(), imageInfo.getImageType()).value());
        }
        if (pos.getX() != -3.4028235E38f && pos.getY() != -3.4028235E38f) {
            mark.addAttribute("PosX", String.valueOf(pos.getX()));
            mark.addAttribute("PosY", String.valueOf(pos.getY()));
        }
        if (xAlign == null) {
            mark.addAttribute("XPosType", Const.XAlign.Absolute.toString());
        } else {
            mark.addAttribute("XPosType", xAlign.toString());
        }
        if (yAlign == null) {
            mark.addAttribute("YPosType", Const.YAlign.Absolute.toString());
        } else {
            mark.addAttribute("YPosType", yAlign.toString());
        }
        if (pos.getWidth() != 0.0f) {
            mark.addAttribute("Width", String.valueOf(pos.getWidth()));
        }
        if (pos.getHeight() != 0.0f) {
            mark.addAttribute("Height", String.valueOf(pos.getHeight()));
        }
        String pages = null;
        if (pos.getIndex() != null || pos.getIndex() != MarkPosition.INDEX_ALL) {
            pages = Utils.toString(pos.getIndex());
        }
        if (pos.getPages() != null && pos.getPages().length != 0) {
            String string = pages = pages == null ? Utils.toString(pos.getPages()) : pages + "," + Utils.toString(pos.getPages());
        }
        if (pages != null) {
            mark.addAttribute("Pages", pages);
        }
        if (alpha >= 0 && alpha <= 255) {
            mark.addAttribute("Alpha", alpha + "");
        }
        if (isTile || pos.isPattern()) {
            mark.addAttribute("Tile", isTile + "");
        }
        if (imageInfo.getOpacity() > 0 && imageInfo.getOpacity() <= 100) {
            mark.addAttribute("Opacity", imageInfo.getOpacity() + "");
        }
        if (imageInfo.getRotate() != 0) {
            mark.addAttribute("Rotate", String.valueOf(imageInfo.getRotate()));
        }
        if (imageInfo.isTile()) {
            mark.addAttribute("Tile", Boolean.TRUE + "");
        }
        if (imageInfo.getxStep() > 0) {
            mark.addAttribute("XStep", String.valueOf(imageInfo.getxStep()));
        }
        if (imageInfo.getyStep() > 0) {
            mark.addAttribute("YStep", String.valueOf(imageInfo.getyStep()));
        }
        return mark;
    }

    @Deprecated
    public void addImageMark(ImageInfo imageInfo, MarkPosition pos, boolean printable, boolean visible) {
        this.addImageMark(imageInfo, pos, null, null, printable, visible, null, -1, false);
    }

    @Deprecated
    public void addImageMark(ImageInfo imageInfo, MarkPosition pos, Const.XAlign xAlign, Const.YAlign yAlign, boolean printable, boolean visible) {
        this.addImageMark(imageInfo, pos, xAlign, yAlign, printable, visible, null, -1, false);
    }

    private void addImageMark(ImageInfo imageInfo, MarkPosition pos, Const.XAlign xAlign, Const.YAlign yAlign, boolean printable, boolean visible, String flag, int alpha, boolean isTile) {
        Element watermark = this.addMaker();
        watermark.addAttribute("Printable", String.valueOf(printable));
        watermark.addAttribute("Visible", String.valueOf(visible));
        if (flag != null) {
            watermark.addAttribute("Name", flag);
        }
        watermark.add(this.transferImageMark(imageInfo, pos, xAlign, yAlign, alpha, isTile));
    }

    public Packet imageMark(InputStream image, String imageType, MarkPosition pos) {
        return this.imageMark(image, imageType, pos, true, true);
    }

    public Packet imageMark(InputStream image, String imageType, MarkPosition pos, int a, boolean tile) {
        return this.addImageMark(image, imageType, pos, true, true, "tile", a, tile);
    }

    public Packet imageMark(InputStream image, String imageType, Const.XAlign xa, Const.YAlign ya, MarkPosition pos) {
        return this.imageMark(image, imageType, xa, ya, pos, true, true);
    }

    public Packet imageMark(InputStream image, String imageType, MarkPosition pos, boolean printable, boolean visible) {
        this.addImageMark(PackEntry.wrap(image), imageType, pos, Const.XAlign.Absolute, Const.YAlign.Absolute, printable, visible, null);
        return this;
    }

    public Packet imageMark(InputStream image, String imageType, Const.XAlign xa, Const.YAlign ya, MarkPosition pos, boolean printable, boolean visible) {
        this.addImageMark(PackEntry.wrap(image), imageType, pos, xa, ya, printable, visible, null);
        return this;
    }

    public Packet textMark(TextInfo text, MarkPosition pos, boolean printable, boolean visible, String name) {
        this.addTextMark(text, pos, printable, visible, name);
        return this;
    }

    @Deprecated
    public Packet textMark(TextInfo text, MarkPosition pos, boolean printable, boolean visible, boolean tile) {
        this.addTextMark(text, pos, printable, visible, null);
        return this;
    }

    public Packet addDiagonalTexMark(TextInfo text, Const.LocationStyle style, float x, int w, int ... pages) {
        MarkPosition markPosition = new MarkPosition(x, 0.0f, (float)w, -1.0f, pages);
        Element watermark = this.addMaker();
        watermark.addAttribute("Printable", String.valueOf(true));
        watermark.addAttribute("Visible", String.valueOf(true));
        Element textMark = this.transferTextMark(watermark.addElement("TextMark"), text, markPosition);
        textMark.addAttribute("Style", style.name());
        return this;
    }

    public Packet textMark(TextInfo text, MarkPosition pos) {
        return this.textMark(text, pos, true, true);
    }

    public Packet textMark(TextInfo text, MarkPosition pos, boolean printable, boolean visible) {
        this.addTextMark(text, pos, printable, visible, null);
        return this;
    }

    @Deprecated
    public Packet signature(CA ca) throws PackException {
        this.newProvider("Signature").add(this.tranferCA(ca));
        return this;
    }

    @Override
    public Packet signature(String provider, boolean lockSign, SignInfo<PackEntry> signInfo) {
        Element signature = this.newSignature("Signature").addAttribute("LockSign", lockSign + "");
        signature.addElement("Provider").addElement("External").addAttribute("Name", provider);
        if (signInfo != null) {
            Element signinfo = signature.addElement("SignInfo").addAttribute("CertID", signInfo.getCertID()).addAttribute("Password", signInfo.getPassword());
            if (signInfo.getTextInfo() != null || signInfo.getImage() != null) {
                Element watermark = signinfo.addElement("Watermark");
                watermark.addAttribute("Printable", String.valueOf(signInfo.isPrintable()));
                watermark.addAttribute("Visible", String.valueOf(signInfo.isVisible()));
                if (signInfo.getTextInfo() != null) {
                    this.transferTextMark(watermark.addElement("TextMark"), signInfo.getTextInfo(), signInfo.getPosition());
                } else if (signInfo.getImage() != null) {
                    watermark.add(this.transferImageMark(new ImageInfo(signInfo.getImage(), signInfo.getType(), 0), signInfo.getPosition(), null, null, -1, false));
                }
            }
        }
        return this;
    }

    @Deprecated
    public Packet signature(String provider, String oesClass) throws PackException {
        Element external = this.newProvider("Signature").addElement("External");
        external.addAttribute("Name", provider);
        external.addAttribute("OESClassName", oesClass);
        return this;
    }

    private Element tranferCA(CA ca) {
        PackEntry cer;
        Element buildin = DocumentHelper.createElement((String)"Buildin");
        buildin.addAttribute("DigestMethod", ca.getDigestMethod());
        buildin.addAttribute("SignaturMethod", ca.getSignMethod());
        PackEntry pfx = ca.getPfx();
        if (pfx != null) {
            Element loc = buildin.addElement("P12FileLoc");
            loc.setText(this.presetEntry(pfx).value());
            loc.addAttribute("Password", ca.getPfxPassword());
        }
        if ((cer = ca.getCertificate()) != null) {
            buildin.addElement("CerFileLoc").setText(this.presetEntry(cer).value());
        }
        return buildin;
    }

    @Deprecated
    public Packet seal(CA ca, SealImage image, SealInfo info) throws PackException {
        Element provider = this.newProvider("EleSeal");
        Element buildin = this.tranferCA(ca);
        provider.add(buildin);
        Element path = buildin.addElement("IconPath");
        path.addAttribute("SealID", image.getSealID());
        path.addAttribute("Width", String.valueOf(image.getWidth()));
        path.addAttribute("Height", String.valueOf(image.getHeight()));
        path.addAttribute("Name", "AutoSealName");
        PackEntry img = image.getData();
        if (img != null) {
            path.setText(this.presetEntry(img).value());
        }
        this.transferSealInfo(info, provider.getParent());
        return this;
    }

    @Deprecated
    public Packet seal(CA ca, InputStream esl, SealInfo info) throws PackException {
        return this.seal(ca, PackEntry.wrap(esl), info);
    }

    @Deprecated
    public Packet seal(CA ca, PackEntry esl, SealInfo info) throws PackException {
        Element provider = this.newProvider("EleSeal");
        Element buildin = this.tranferCA(ca);
        provider.add(buildin);
        if (esl != null) {
            buildin.addElement("StandardESL").setText(this.presetEntry(esl).value());
        }
        this.transferSealInfo(info, provider.getParent());
        return this;
    }

    @Deprecated
    public Packet envelope(Const.EnvelopeType type, String password, Map<Const.EnvelopePerm, Boolean> perms, Pair<Const.EnvelopeMeta, Object> ... meta) {
        return (Packet)this.envelope(type, password, perms, (String)null, meta);
    }

    @Deprecated
    public Packet envelope(Const.EnvelopeType type, String value, String provider, Pair<Const.EnvelopeMeta, Object> ... meta) {
        return (Packet)this.envelope(type, value, null, provider, meta);
    }

    @Deprecated
    public Packet encrypt(CipherProvider provider, Map<Const.EntryScope, Boolean> scope, SimpleTextInfo textInfo) {
        Element encrypt = this.findOrNew(this.root, "Encrypt");
        this.analysisProvider(provider, encrypt.addElement("Provider"));
        if (scope != null) {
            Element es = encrypt.addElement("EntryScope");
            for (Map.Entry<Const.EntryScope, Boolean> p : scope.entrySet()) {
                es.addAttribute(p.getKey().xmlName(), String.valueOf(p.getValue()));
            }
        }
        if (textInfo != null) {
            Element text = encrypt.addElement("PredefineText");
            text.addAttribute("TextFont", textInfo.getFontName());
            text.addAttribute("TextSize", String.valueOf(textInfo.getFontSize()));
            text.addAttribute("TextColor", textInfo.getColor());
        }
        return this;
    }

    private void analysisProvider(CipherProvider provider, Element ep) {
        Group<String, String, String>[] paras;
        ep.addAttribute("Name", provider.getName());
        String className = provider.getOecClassName();
        if (className != null) {
            ep.addAttribute("OECClassName", className);
        }
        if ((paras = provider.getParameters()) != null) {
            for (Group<String, String, String> para : paras) {
                Element pm = ep.addElement("Parameter");
                pm.setText((String)para.value());
                pm.addAttribute("Name", (String)para.key());
                pm.addAttribute("Value", (String)para.value());
            }
        }
    }

    @Deprecated
    public Packet decrypt(CipherProvider provider) {
        Element decrypt = this.findOrNew(this.root, "Decrypt");
        this.analysisProvider(provider, decrypt.addElement("Provider"));
        return this;
    }

    @Deprecated
    public Packet envelope(CipherProvider provider, Map<Const.EnvelopePerm, Boolean> perms, Pair<Const.EnvelopeMeta, Object> ... meta) throws PackException {
        Element env = this.findOrNew(this.root, "Envelope");
        this.transferEnvMeta(env, meta);
        this.transferEnvPerm(env, perms);
        Element key = env.addElement("Key");
        this.analysisProvider(provider, key.addElement("Provider"));
        return this;
    }

    public Packet attachImage(MarkPosition position, int alpha, boolean isTop, PackEntry image, String type) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element sc = ep.addElement("AttachImage");
        sc.addAttribute("X", String.valueOf(position.getX()));
        sc.addAttribute("Y", String.valueOf(position.getY()));
        sc.addAttribute("W", String.valueOf(position.getWidth()));
        sc.addAttribute("H", String.valueOf(position.getHeight()));
        String pages = null;
        if (position.getIndex() != null || position.getIndex() != MarkPosition.INDEX_ALL) {
            pages = Utils.toString(position.getIndex());
        }
        if (position.getPages() != null && position.getPages().length != 0) {
            pages = pages == null ? Utils.toString(position.getPages()) : pages + "," + Utils.toString(position.getPages());
        }
        sc.addAttribute("Pages", pages);
        if (alpha >= 0 && alpha <= 255) {
            sc.addAttribute("Alpha", String.valueOf(alpha));
        } else {
            sc.addAttribute("Alpha", String.valueOf(255));
        }
        if (isTop) {
            sc.addAttribute("Layer", "Top");
        } else {
            sc.addAttribute("Layer", "Bottom");
        }
        Element mark = sc.addElement("FileLoc");
        mark.setText(this.presetEntry(image, type).value());
        return this;
    }

    @Override
    public Packet insertPage(InputStream source, int srcStart, int srcEnd, int index) {
        return (Packet)this.insertPage(PackEntry.wrap(source), srcStart, srcEnd, index);
    }

    @Override
    public Packet insertPage(InputStream source, int srcStart, int srcEnd, int index, String format) {
        return (Packet)this.insertPage(PackEntry.wrap(source), srcStart, srcEnd, index, format);
    }

    public Packet imageOptimize(int quality) {
        Element operate = this.findOrNew(this.root, "Operate");
        if (quality > 0 && quality <= 100) {
            Element io = this.findOrNew(operate, "ImageOptimize");
            io.addAttribute("Quality", quality + "");
        }
        return this;
    }

    public Packet optimize(boolean opCompress) {
        Element ep = this.findOrNew(this.root, "Operate");
        if (opCompress) {
            ep.addAttribute("Optimize", opCompress + "");
        }
        return this;
    }

    @Deprecated
    public Packet mergeGU(Const.MergeType type, float widthLimit, float heightLimit, int countLimit) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element gu = this.findOrNew(ep, "MergeGU");
        gu.addAttribute("Type", type.toString());
        if (widthLimit > 0.0f) {
            gu.addAttribute("CountLimit", String.valueOf(widthLimit));
        }
        if (heightLimit > 0.0f) {
            gu.addAttribute("HeightLimit", String.valueOf(heightLimit));
        }
        if (countLimit > 0) {
            gu.addAttribute("WidthLimit", String.valueOf(countLimit));
        }
        return this;
    }

    public Packet addEmptyAttach(String name, String format, long fileSize) {
        this.attach(name, format, fileSize, true, null, true);
        return this;
    }

    public Packet removeAttach(Const.RemoveAttachType type, String ... attach) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element ra = ep.addElement("RemoveAttach");
        ra.addAttribute("Type", type.toString());
        if (attach != null) {
            for (String string : attach) {
                ra.addElement("Attach").setText(string);
            }
        }
        return this;
    }

    public Packet invoke(InvokePair invokePair) {
        this.invoke(null, invokePair.getModule(), invokePair.getMethod(), new Pair<String, String>("arg", GSON.toJson((Object)invokePair)));
        return this;
    }

    public Packet clip(float x, float y, float w, float h, int ... pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element clip = ep.addElement("Clip");
        clip.addAttribute("X", x + "");
        clip.addAttribute("Y", y + "");
        clip.addAttribute("W", w + "");
        clip.addAttribute("H", h + "");
        clip.addAttribute("Pages", Utils.toString(pages));
        return this;
    }

    private Element findRPCOperate() {
        Element ep = this.findOrNew(this.root, "Operate");
        return this.findOrNew(ep, "RPCOperate");
    }

    public Packet graftingAnnotation(PackEntry ofd) {
        Element ro = this.findRPCOperate();
        Element ga = ro.addElement("GraftingAnnotation");
        ga.addElement("AnnotFile").setText(this.presetEntry(ofd, "ofd").value());
        return this;
    }

    public Packet clip(String type, String pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element clip = ep.addElement("Clip");
        if (type != null) {
            clip.addAttribute("Flag", type);
        }
        clip.addAttribute("Pages", pages);
        return this;
    }

    public Packet addMask(float x, float y, float w, float h, boolean readOnly, int ... pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element mask = ep.addElement("AddMask");
        mask.addAttribute("X", x + "");
        mask.addAttribute("Y", y + "");
        mask.addAttribute("W", w + "");
        mask.addAttribute("H", h + "");
        mask.addAttribute("ReadOnly", readOnly + "");
        mask.addAttribute("Pages", Utils.toString(pages));
        return this;
    }

    public Packet addMask(float x, float y, float w, float h, int ... pages) {
        return this.addMask(x, y, w, h, true, pages);
    }

    public Packet removeAnnot(String type, int ... pages) {
        return this.removeAnnot(null, type, pages);
    }

    public Packet removeAnnot(Const.AnnotType annotType, String subType, int ... pages) {
        Element ep = this.findOrNew(this.root, "Operate");
        Element ra = ep.addElement("RemoveAnnot");
        ra.addAttribute("PageIndex", Utils.toString(pages));
        if (annotType == Const.AnnotType.all) {
            return this;
        }
        if (annotType != null) {
            ra.addAttribute("Type", annotType.name());
        }
        if (subType != null) {
            ra.addAttribute("Name", subType);
        }
        return this;
    }

    public Packet embedFont(boolean exclude, String ... names) {
        block5: {
            Element ef;
            block4: {
                if (!exclude && names == null) {
                    return this;
                }
                Element ep = this.findOrNew(this.root, "Operate");
                ef = this.findOrNew(ep, "EmbedFont");
                if (!exclude) break block4;
                Element ex = this.findOrNew(ef, "Exclude");
                if (names == null) break block5;
                for (String name : names) {
                    ex.addElement("Font").setText(name);
                }
                break block5;
            }
            Element in = this.findOrNew(ef, "Include");
            if (names != null) {
                for (String name : names) {
                    in.addElement("Font").setText(name);
                }
            }
        }
        return this;
    }

    public Packet addPageNumber(boolean deleteOld, PageNumber pageNumber) {
        if (pageNumber == null) {
            return this;
        }
        Element ep = this.findOrNew(this.root, "Operate");
        Element epn = ep.addElement("PageNumber");
        epn.addAttribute("Operator", deleteOld ? "Update" : "Add");
        Map<String, String> as = pageNumber.toMap();
        for (String key : as.keySet()) {
            epn.addAttribute(key, as.get(key));
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (PackEntry e : this.entities.values()) {
            e.close();
        }
        this.entities.clear();
    }

    public static class Outline {
        private Element node;

        private Outline(Element node) {
            this.node = node;
        }

        @Deprecated
        public Outline append(String title, String refID) {
            Element e = this.node.addElement("Node");
            e.addAttribute("Title", title);
            e.addAttribute("ComponentID", refID);
            return new Outline(e);
        }

        public Outline append(String title, int pageIndex, float left, float top) {
            Element e = this.node.addElement("Node");
            e.addAttribute("Title", title);
            e.addAttribute("PageIndex", pageIndex + "");
            e.addAttribute("Top", top + "");
            e.addAttribute("Left", left + "");
            return new Outline(e);
        }
    }
}

