/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.model.Pair;

public class MarkPosition {
    public static final int[] INDEX_ALL = new int[0];
    private float x;
    private float y;
    private float width;
    private float height;
    private int[] index;
    private Pair<Integer, Integer>[] pages;
    @Deprecated
    private boolean isPattern;
    private String target;
    private Const.XAlign xAlign = Const.XAlign.Absolute;
    private Const.YAlign yAlign = Const.YAlign.Absolute;
    private int xStep;
    private int yStep;
    private boolean tile;
    private int rotate;
    private float[] margin;
    private boolean asPageObject;

    public MarkPosition(int[] index) {
        this.index = index;
    }

    @Deprecated
    public MarkPosition(int[] index, Const.PatternType type) {
        this.index = index;
        this.isPattern = true;
        if (type.value() != null && type.value().length == 2) {
            this.width = type.value()[0];
            this.height = type.value()[1];
        }
    }

    public MarkPosition(float width, float height, int[] index) {
        this(width, height, Type.Size, index);
    }

    public MarkPosition(float x, float y, float width, float height, int[] index) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.index = index;
    }

    public MarkPosition(float p1, float p2, Type type, int[] index) {
        switch (type) {
            case Size: {
                this.width = p1;
                this.height = p2;
                break;
            }
            default: {
                this.x = p1;
                this.y = p2;
            }
        }
        this.index = index;
    }

    public MarkPosition(float x, float y, float width, float height, Pair<Integer, Integer> ... pages) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.pages = pages;
    }

    public MarkPosition(float x, float y, float width, float height, int[] index, Pair<Integer, Integer> ... pages) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.index = index;
        this.pages = pages;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int[] getIndex() {
        return this.index;
    }

    public Pair<Integer, Integer>[] getPages() {
        return this.pages;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Const.XAlign getxAlign() {
        return this.xAlign;
    }

    public MarkPosition setxAlign(Const.XAlign xAlign) {
        this.xAlign = xAlign;
        return this;
    }

    public Const.YAlign getyAlign() {
        return this.yAlign;
    }

    public MarkPosition setyAlign(Const.YAlign yAlign) {
        this.yAlign = yAlign;
        return this;
    }

    public Integer getxStep() {
        if (this.xStep <= 0) {
            return null;
        }
        return this.xStep;
    }

    public MarkPosition setxStep(int xStep) {
        this.xStep = xStep;
        return this;
    }

    public Integer getyStep() {
        if (this.yStep <= 0) {
            return null;
        }
        return this.yStep;
    }

    public MarkPosition setyStep(int yStep) {
        this.yStep = yStep;
        return this;
    }

    public boolean isTile() {
        return this.tile;
    }

    public MarkPosition setTile(boolean tile) {
        this.tile = tile;
        return this;
    }

    public Integer getRotate() {
        if (this.rotate <= 0) {
            return null;
        }
        return this.rotate;
    }

    public MarkPosition setRotate(int rotate) {
        this.rotate = rotate;
        return this;
    }

    public MarkPosition setMargin(float left, float top, float right, float bottom) {
        this.margin = new float[]{left, top, right, bottom};
        return this;
    }

    public float[] getMargin() {
        return this.margin;
    }

    public boolean isAsPageObject() {
        return this.asPageObject;
    }

    public MarkPosition setAsPageObject(boolean asPageObject) {
        this.asPageObject = asPageObject;
        return this;
    }

    public static enum Type {
        Location,
        Size;

    }
}

