/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.PackEntry;
import com.suwell.ofd.custom.wrapper.model.Argument;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class Template {
    private Type officeType;
    private String title;
    private String handler;
    private PackEntry template;
    private PackEntry data;
    private Map<String, PackEntry> sheet;
    private DataType dataType;
    private Argument argument;

    public Template(String title, String handler, InputStream data) {
        this(title, handler, PackEntry.wrap(data));
    }

    public Template(String title, String handler, PackEntry data) {
        this.title = title;
        this.handler = handler;
        this.data = data;
    }

    public Template(String title, Type type, PackEntry template, PackEntry data) {
        this.title = title;
        this.officeType = type;
        this.data = data;
        this.template = template;
    }

    public Template(String title, InputStream template, InputStream data) {
        this(title, PackEntry.wrap(template), PackEntry.wrap(data), null);
    }

    public Template(String title, InputStream template, InputStream data, Map<String, InputStream> sheet) {
        this(title, PackEntry.wrap(template), PackEntry.wrap(data), Template.to(sheet));
    }

    public Template(String title, PackEntry template, PackEntry data, Map<String, PackEntry> sheet) {
        this.title = title;
        this.template = template;
        this.data = data;
        this.sheet = sheet;
    }

    private static Map<String, PackEntry> to(Map<String, InputStream> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, PackEntry> nm = new HashMap<String, PackEntry>(map.size());
        for (String key : map.keySet()) {
            nm.put(key, PackEntry.wrap(map.get(key)));
        }
        return nm;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHandler() {
        return this.handler;
    }

    public PackEntry getTemplate() {
        return this.template;
    }

    public PackEntry getData() {
        return this.data;
    }

    public Map<String, PackEntry> getSheet() {
        return this.sheet;
    }

    public Type getOfficeType() {
        return this.officeType;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public Template setArgument(Argument argument) {
        this.argument = argument;
        return this;
    }

    public Template setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static enum DataType {
        XML,
        JSON;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Type {
        WPS,
        DOC,
        DOCX;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

