/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.wrapper.model;

import com.suwell.ofd.custom.wrapper.Const;
import com.suwell.ofd.custom.wrapper.model.Argument;
import com.suwell.ofd.custom.wrapper.model.Pair;
import java.util.HashMap;
import java.util.Map;

public class WebArgument
extends Argument {
    private static final String ARG_WEB_CONVERT = "webConvertArgs";
    private static final String WEB_CONVERT_AFTER = "webConvertAfter";
    private static final String JOINT_MARK = "&";
    private static final String PAPERSIZE = "papersize";
    private static final String PAPERWIDTH = "paperwidth";
    private static final String PAPERHEIGHT = "paperheight";
    private static final String PAPERBACKGROUNDS = "paperbackgrounds";
    private static final String PAPERMARGIN = "papermargin";
    private static final String LANDSCAPE = "landscape";
    private Map<String, String> webConvertArgs = new HashMap<String, String>();
    protected Map<String, String> webConvertAfter = new HashMap<String, String>();
    private Model model = Model.API;

    public WebArgument() {
    }

    public WebArgument(Model model) {
        this.model = model;
    }

    public WebArgument setWebPageSize(Const.PageSize webPageSize, Pair<Const.WebMargin, Float> ... margin) {
        block11: {
            block12: {
                if (webPageSize == null) break block11;
                if (this.model != Model.API) break block12;
                switch (webPageSize) {
                    case ADAPTIVE: {
                        this.webConvertArgs.put(PAPERSIZE, webPageSize.toString());
                        break;
                    }
                    default: {
                        this.webConvertArgs.put(PAPERSIZE, webPageSize.toString() + "W");
                        if (margin != null && margin.length > 0) {
                            this.webConvertAfter.put("PageWidth", webPageSize.getSize().key().toString());
                            this.webConvertAfter.put("PageHeight", webPageSize.getSize().value().toString());
                            for (Pair<Const.WebMargin, Float> pair : margin) {
                                this.webConvertAfter.put(pair.key().name(), pair.value() + "");
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            if (this.model == Model.PLUGIN) {
                this.webConvertArgs.put(PAPERSIZE, webPageSize.toString());
                if (margin != null && margin.length > 0) {
                    for (Pair<Const.WebMargin, Float> pair : margin) {
                        if (pair.key().equals((Object)Const.WebMargin.TopMargin)) {
                            this.webConvertArgs.put("margintop", pair.value() + "");
                        }
                        if (pair.key().equals((Object)Const.WebMargin.BottomMargin)) {
                            this.webConvertArgs.put("marginbottom", pair.value() + "");
                        }
                        if (pair.key().equals((Object)Const.WebMargin.LeftMargin)) {
                            this.webConvertArgs.put("marginleft", pair.value() + "");
                        }
                        if (!pair.key().equals((Object)Const.WebMargin.RightMargin)) continue;
                        this.webConvertArgs.put("marginright", pair.value() + "");
                    }
                }
            }
        }
        return this;
    }

    public WebArgument setWebPageSize(int width, int height, Pair<Const.WebMargin, Float> ... margin) {
        this.webConvertArgs.put(PAPERSIZE, "CUSTOM");
        this.webConvertArgs.put(PAPERWIDTH, String.valueOf(width));
        if (margin != null && margin.length > 0) {
            this.webConvertAfter.put("PageWidth", width + "");
            this.webConvertAfter.put("PageHeight", height + "");
            for (Pair<Const.WebMargin, Float> pair : margin) {
                this.webConvertAfter.put(pair.key().name(), pair.value() + "");
            }
        } else {
            this.webConvertArgs.put(PAPERHEIGHT, String.valueOf(height));
        }
        return this;
    }

    public WebArgument setPaperBackgrounds(Const.Opinion opinion) {
        this.webConvertArgs.put(PAPERBACKGROUNDS, opinion.toString());
        return this;
    }

    public WebArgument setPaperMargin(Const.PaperMargin paperMargin) {
        this.webConvertArgs.put(PAPERMARGIN, paperMargin.toString());
        return this;
    }

    public WebArgument setFirstTop(float topMargin) {
        this.setPaperMargin(Const.PaperMargin.CUSTOMMARGIN);
        this.webConvertArgs.put("margintop", topMargin + "");
        return this;
    }

    public WebArgument setLandScape(Const.Opinion opinion) {
        this.webConvertArgs.put(LANDSCAPE, opinion.toString());
        return this;
    }

    @Override
    public String value() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.webConvertArgs.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(JOINT_MARK);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            this.map.put(ARG_WEB_CONVERT, sb.toString());
        }
        sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.webConvertAfter.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(JOINT_MARK);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            this.map.put(WEB_CONVERT_AFTER, sb.toString());
        }
        return super.value();
    }

    public static WebArgument buildOnePageArg(float topMargin, float bottomMargin, float leftMargin, float rightMargin) {
        WebArgument webArgument = new WebArgument(){

            @Override
            public String value() {
                if (this.webConvertAfter.size() > 0) {
                    throw new IllegalArgumentException("OnePage Multipage parameters cannot be set !");
                }
                return super.value();
            }
        };
        webArgument.setPaperMargin(Const.PaperMargin.CUSTOMMARGIN);
        webArgument.webConvertArgs.put("margintop", topMargin + "");
        webArgument.webConvertArgs.put("marginbottom", bottomMargin + "");
        webArgument.webConvertArgs.put("marginleft", leftMargin + "");
        webArgument.webConvertArgs.put("marginright", rightMargin + "");
        return webArgument;
    }

    public static void main(String[] args) {
        WebArgument webArgument = WebArgument.buildOnePageArg(10.0f, 20.0f, 30.0f, 40.0f);
        System.out.println(webArgument.value());
    }

    public static enum Model {
        API,
        PLUGIN;

    }
}

