/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.rpc.mgr.utils;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CustomJsonParser
extends TypeAdapter<Element> {
    public static final String CDATA = "!CDATA";
    private Element root;
    private Element current;
    private String name;

    public CustomJsonParser() {
        this.current = this.root = DocumentHelper.createDocument().addElement("Root");
    }

    public Element parse(String json) throws JsonSyntaxException {
        return this.parse(new StringReader(json));
    }

    public Element parse(Reader json) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(json);
            Element element = this.parse(jsonReader);
            if (element != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public Element parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        boolean lenient = json.isLenient();
        json.setLenient(true);
        try {
            Element element = this.moreParse(json);
            return element;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", (Throwable)e);
        }
        finally {
            json.setLenient(lenient);
        }
    }

    public Element moreParse(JsonReader reader) throws JsonParseException {
        boolean isEmpty = true;
        try {
            reader.peek();
            isEmpty = false;
            return this.read(reader);
        }
        catch (EOFException e) {
            if (isEmpty) {
                return null;
            }
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public void write(JsonWriter out, Element value) throws IOException {
    }

    public Element read(JsonReader in) throws IOException {
        if (this.current == null) {
            return null;
        }
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                String v = in.nextString();
                if (v.startsWith(CDATA)) {
                    v = v.substring(CDATA.length());
                    this.current.addCDATA(v);
                    break;
                }
                this.current.addText(v);
                break;
            }
            case BOOLEAN: {
                this.current.addText(String.valueOf(in.nextBoolean()));
                break;
            }
            case NULL: {
                in.nextNull();
                break;
            }
            case BEGIN_ARRAY: {
                in.beginArray();
                String name = this.name;
                int i = 0;
                while (in.hasNext()) {
                    if (i > 0) {
                        this.current = this.current.getParent().addElement(name);
                    }
                    this.read(in);
                    ++i;
                }
                in.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                in.beginObject();
                while (in.hasNext()) {
                    this.name = in.nextName();
                    this.current = this.current.addElement(this.name);
                    this.read(in);
                    this.current = this.current.getParent();
                }
                in.endObject();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.current;
    }
}

