/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.rpc.mgr.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;

public class JsonToXml {
    private static final String FL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String ES = "<{0}{1}>";
    private static final String EE = "</{0}>";
    private static final String DF = "";
    private static final String ARRT = " {0}=\"{1}\"";
    private static final String RT = "Root";
    private StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    private String json;
    private JsonElement jsonObject;

    public JsonToXml(String json) {
        this.json = json;
        this.jsonObject = new JsonParser().parse(json).getAsJsonObject();
    }

    public String convert() {
        this.sb.append(this.format(RT, false, new Pair[0]));
        this.classify(this.jsonObject, null, false);
        this.sb.append(this.format(RT, true, new Pair[0]));
        return this.sb.toString();
    }

    private void classify(JsonElement e, String name, boolean ape) {
        if (ape) {
            this.sb.append(this.format(name, false, new Pair[0]));
        }
        if (e.isJsonArray()) {
            this.convertJsonArray((JsonArray)e, name);
        } else if (e.isJsonObject()) {
            this.convertJsonObject((JsonObject)e);
        } else if (e.isJsonPrimitive()) {
            this.convertJsonPrimitive((JsonPrimitive)e);
        }
        if (ape) {
            this.sb.append(this.format(name, true, new Pair[0]));
        }
    }

    private void convertJsonArray(JsonArray e, String name) {
        for (int i = 0; i < e.size(); ++i) {
            JsonElement arrayElement = e.get(i);
            this.classify(arrayElement, name, true);
        }
    }

    private void convertJsonObject(JsonObject e) {
        Set set = e.entrySet();
        for (Map.Entry s : set) {
            JsonElement je = (JsonElement)s.getValue();
            this.classify(je, (String)s.getKey(), !je.isJsonArray());
        }
    }

    private void convertJsonPrimitive(JsonPrimitive e) {
        this.sb.append(e.getAsString());
    }

    private String format(String name, boolean isEnd, Pair<String, String> ... attr) {
        String at = DF;
        if (attr != null && attr.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Pair<String, String> p : attr) {
                if (p.getKey() == null || p.getValue() == null) continue;
                sb.append(MessageFormat.format(ARRT, p.getKey(), p.getValue()));
            }
            at = sb.toString();
        }
        String result = !isEnd ? MessageFormat.format(ES, name, at) : MessageFormat.format(EE, name);
        return result;
    }

    class Pair<K, V> {
        private K k;
        private V v;

        Pair(K k, V v) {
            this.k = k;
            this.v = v;
        }

        K getKey() {
            return this.k;
        }

        V getValue() {
            return this.v;
        }
    }
}

