/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.sdk.invoice;

import com.suwell.rpc.mgr.ACIS;
import com.suwell.rpc.mgr.CircularFifoQueue;
import com.suwell.rpc.mgr.WebHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;

public class Consumer {
    private final WebHelper helper;
    private final Semaphore semaphore;
    private final CircularFifoQueue<ACIS> queue;
    public static boolean credible = true;

    public Consumer(String url, int count) {
        this.helper = new WebHelper(url, count);
        this.semaphore = new Semaphore(count);
        this.queue = new CircularFifoQueue<ACIS>(count * 10){

            @Override
            protected void onPopup(ACIS o) {
                try {
                    o.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    public String[] post(String methodName, List<NameValuePair> pairs) throws IOException {
        if (pairs == null || pairs.isEmpty()) {
            throw new NullPointerException("Data is empty");
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, Consts.UTF_8);
        return this.post(methodName, (HttpEntity)entity);
    }

    public String[] post(String methodName, NameValuePair ... pairs) throws IOException {
        if (pairs == null || pairs.length == 0) {
            throw new NullPointerException("Data is empty");
        }
        return this.post(methodName, Arrays.asList(pairs));
    }

    public String[] post(String methodName, HttpEntity entity) throws IOException {
        boolean acquired = false;
        try {
            this.semaphore.acquire();
            acquired = true;
            HttpPost post = new HttpPost(this.helper.url() + methodName);
            if (entity == null) {
                throw new NullPointerException("entity is empty");
            }
            post.setEntity(entity);
            String ret = this.helper.request((HttpRequestBase)post, WebHelper.RH_TEXT);
            String server = this.helper.header("X-Server-Path");
            if (server == null) {
                server = this.helper.header("Server");
            }
            String[] stringArray = new String[]{ret, server};
            return stringArray;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            if (acquired) {
                this.semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream down(String methodName, String name, String flag) throws IOException {
        URI uri = null;
        try {
            URIBuilder builder = new URIBuilder(this.helper.url() + methodName);
            builder.setParameter("name", name);
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        HttpGet req = new HttpGet(uri);
        if (flag != null) {
            req.setHeader("X-Server-Path", flag);
        }
        ACIS is = this.helper.request((HttpRequestBase)req).toStream();
        if (!credible) {
            CircularFifoQueue<ACIS> circularFifoQueue = this.queue;
            synchronized (circularFifoQueue) {
                this.queue.add(is);
            }
        }
        return is;
    }

    public void shutdown() {
        this.helper.close();
    }

    public String toString() {
        return "Consumer[" + this.helper.url() + "]";
    }
}

