/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.sdk.invoice;

import com.google.gson.Gson;
import com.suwell.rpc.mgr.utils.DataType;
import com.suwell.sdk.invoice.Consumer;
import com.suwell.sdk.invoice.Extend;
import com.suwell.sdk.invoice.Reply;
import com.suwell.sdk.invoice.Result;
import com.suwell.sdk.invoice.SealSignParam;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceHelper {
    private static Logger log = LoggerFactory.getLogger(InvoiceHelper.class);
    static final String ACTION = "invoice/compound";
    static final String X2Y_URL = "x2y/convert";
    private static Consumer consumer;
    private static Gson gson;

    public static void init(URL serverURL, int maxLockCount) {
        consumer = new Consumer(serverURL.toString(), maxLockCount);
    }

    public static void destroy() {
        if (consumer != null) {
            consumer.shutdown();
        }
    }

    public static Result convertForm(String data, String id, Extend extend, DataType dt) {
        return InvoiceHelper.convertForm(data, id, null, extend, dt);
    }

    public static Result convertForm(String data, String id, String meta, Extend extend, DataType dt) {
        if (dt != null) {
            data = dt.convert(data);
        }
        return InvoiceHelper.convertForm(data, id, meta, extend);
    }

    public static Result convertForm(String data, String id, String meta, Extend extend) {
        return InvoiceHelper.convertForm(data, id, meta, null, extend);
    }

    public static Result convertForm(String data, String id, String meta, String areaCode, Extend extend) {
        Result result = new Result();
        try {
            ArrayList<BasicNameValuePair> bnvps = new ArrayList<BasicNameValuePair>(3);
            bnvps.add(new BasicNameValuePair("data", data));
            bnvps.add(new BasicNameValuePair("id", id));
            if (meta != null && meta.length() > 0) {
                bnvps.add(new BasicNameValuePair("meta", meta));
            }
            if (areaCode != null && areaCode.length() > 0) {
                bnvps.add(new BasicNameValuePair("areaCode", areaCode));
            }
            if (extend != null) {
                bnvps.add(new BasicNameValuePair("extend", new Gson().toJson((Object)extend)));
            }
            String[] ret = consumer.post(ACTION, (NameValuePair[])bnvps.toArray(new BasicNameValuePair[bnvps.size()]));
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            result.consumer = consumer;
            result.flag = ret[1];
            result.name = reply.getName();
            result.returnCode = reply.getCode();
            result.returnMsg = reply.getMsg();
            result.sealSignParam = reply.getSealInfos() == null ? null : reply.getSealInfos().toArray(new SealSignParam[0]);
            result.formats = reply.getFormats() == null ? null : reply.getFormats().toArray(new String[reply.getFormats().size()]);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            result.returnCode = 1;
            result.returnMsg = e.getMessage();
        }
        return result;
    }

    public static Result convertForm(String data, String id, String meta, String areaCode, Extend.EleSeal es, Extend.ResultType ... formats) {
        return InvoiceHelper.convertForm(data, id, meta, areaCode, new Extend().setEleSeals(es).setResultType(formats));
    }

    public static Result convertForm(String data, String id, String areaCode, Extend.EleSeal es, Extend.ResultType ... formats) {
        return InvoiceHelper.convertForm(data, id, null, areaCode, es, formats);
    }

    public static Result convertForm(String data, String id, String areaCode, Extend.ResultType ... formats) {
        return InvoiceHelper.convertForm(data, id, null, areaCode, null, formats);
    }

    public static Result convertForm(String data, String id, Extend.ResultType ... formats) {
        return InvoiceHelper.convertForm(data, id, null, null, null, formats);
    }

    public static Result convertForm(String data, String id) {
        return InvoiceHelper.convertForm(data, id, null);
    }

    public static Result ofd2Other(InputStream in, Extend.ResultType ... formats) {
        return InvoiceHelper.x2y(in, "ofd", formats);
    }

    public static Result ofd2Other(String in, Extend.ResultType ... formats) {
        return InvoiceHelper.x2yBase64(in, "ofd", formats);
    }

    public static Map<String, ?> info() {
        return null;
    }

    static Result x2y(InputStream in, String sf, Extend.ResultType ... formats) {
        Result result = new Result();
        if (sf == null || sf.length() == 0) {
            result.returnCode = 1;
            result.returnMsg = "src file format is null !";
            return result;
        }
        try {
            MultipartEntityBuilder meb = MultipartEntityBuilder.create().addPart("file", (ContentBody)new InputStreamBody(in, ContentType.DEFAULT_BINARY, "file"));
            meb.addTextBody("sFormat", sf);
            meb.addTextBody("extend", new Gson().toJson((Object)new Extend().setResultType(formats)));
            String[] ret = consumer.post(X2Y_URL, meb.build());
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            result.consumer = consumer;
            result.flag = ret[1];
            result.name = reply.getName();
            result.returnCode = reply.getCode();
            result.returnMsg = reply.getMsg();
            result.sealSignParam = reply.getSealInfos() == null ? null : reply.getSealInfos().toArray(new SealSignParam[0]);
            result.formats = reply.getFormats() == null ? null : reply.getFormats().toArray(new String[reply.getFormats().size()]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.returnCode = 1;
            result.returnMsg = e.getMessage();
        }
        return result;
    }

    static Result x2yBase64(String base64, String sf, Extend.ResultType ... formats) {
        Result result = new Result();
        if (sf == null || sf.length() == 0) {
            result.returnCode = 1;
            result.returnMsg = "src file format is null !";
            return result;
        }
        try {
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            meb.addTextBody("base64", base64);
            meb.addTextBody("sFormat", sf);
            meb.addTextBody("extend", new Gson().toJson((Object)new Extend().setResultType(formats)));
            String[] ret = consumer.post("x2y/convert/base64", meb.build());
            Reply reply = (Reply)gson.fromJson(ret[0], Reply.class);
            result.consumer = consumer;
            result.flag = ret[1];
            result.name = reply.getName();
            result.returnCode = reply.getCode();
            result.returnMsg = reply.getMsg();
            result.sealSignParam = reply.getSealInfos() == null ? null : reply.getSealInfos().toArray(new SealSignParam[0]);
            result.formats = reply.getFormats() == null ? null : reply.getFormats().toArray(new String[reply.getFormats().size()]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.returnCode = 1;
            result.returnMsg = e.getMessage();
        }
        return result;
    }

    public static Result pdf2ofd(InputStream in) {
        return InvoiceHelper.x2y(in, "pdf", Extend.createOFDResultType());
    }

    public static int copyResult(Result result, OutputStream output) throws IOException {
        InputStream in = result.fetch();
        if (in == null) {
            return -1;
        }
        return InvoiceHelper.copy(in, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] bytes = new byte[8192];
            int total = 0;
            int len = -1;
            while ((len = in.read(bytes)) != -1) {
                out.write(bytes, 0, len);
                total += len;
            }
            out.flush();
            int n = total;
            return n;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResult(Result result, ItemStoreable output) throws IOException {
        InputStream in = result.fetch();
        if (in == null) {
            throw new IOException("result stream is null !");
        }
        HashSet<Closeable> closeables = new HashSet<Closeable>();
        closeables.add(in);
        File c = null;
        try {
            String[] rs = result.getFormats();
            if (rs == null || rs.length == 0 || rs.length == 1 && "ofdpdftiff".contains(rs[0].toLowerCase().trim())) {
                OutputStream callout;
                String format = "ofd";
                if (rs != null && rs.length != 0) {
                    format = rs[0].toLowerCase().trim();
                }
                if ((callout = output.getOutputStream(format, "result." + format)) != null) {
                    closeables.add(callout);
                    IOUtils.copy((InputStream)in, (OutputStream)callout);
                } else {
                    throw new NullPointerException("getOutputStream is null type = ofd name = result.ofd !");
                }
                return;
            }
            c = File.createTempFile("cache_", ".c");
            FileOutputStream out = new FileOutputStream(c);
            closeables.add(out);
            InvoiceHelper.copy(in, out);
            ZipFile zip = new ZipFile(c, "utf-8");
            Enumeration ez = zip.getEntries();
            while (ez.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)ez.nextElement();
                InputStream zfin = zip.getInputStream(zae);
                closeables.add(zfin);
                String name = zae.getName();
                String type = name.toLowerCase().substring(name.lastIndexOf(".") + 1);
                OutputStream callout = output.getOutputStream(type, name);
                if (callout == null) {
                    throw new NullPointerException("getOutputStream is null type = " + type + " name = " + name + " !");
                }
                closeables.add(callout);
                IOUtils.copy((InputStream)zfin, (OutputStream)callout);
                zfin.close();
            }
        }
        finally {
            for (Closeable closeable : closeables) {
                IOUtils.closeQuietly((Closeable)closeable);
            }
            if (c != null) {
                c.delete();
            }
        }
    }

    static {
        gson = new Gson();
    }

    public static interface ItemStoreable {
        public OutputStream getOutputStream(String var1, String var2);
    }
}

