package fr.delthas.javamp3;

import java.io.*;

@SuppressWarnings({"Duplicates", "PointlessArithmeticExpression"})
final class Decoder {
  private static final float INV_SQUARE_2 = 0.70710678118654752440f;
  private static final int[] BITRATE_LAYER_I = {0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000};
  private static final int[] BITRATE_LAYER_II = {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000};
  private static final int[] BITRATE_LAYER_III = {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};
  private static final int[] SAMPLING_FREQUENCY = {44100, 48000, 32000};
  private static final float[] SCALEFACTORS = {2.00000000000000f, 1.58740105196820f, 1.25992104989487f, 1.00000000000000f, 0.79370052598410f, 0.62996052494744f, 0.50000000000000f, 0.39685026299205f, 0.31498026247372f, 0.25000000000000f, 0.19842513149602f, 0.15749013123686f, 0.12500000000000f, 0.09921256574801f, 0.07874506561843f, 0.06250000000000f, 0.04960628287401f, 0.03937253280921f, 0.03125000000000f, 0.02480314143700f, 0.01968626640461f, 0.01562500000000f, 0.01240157071850f, 0.00984313320230f, 0.00781250000000f, 0.00620078535925f, 0.00492156660115f, 0.00390625000000f, 0.00310039267963f, 0.00246078330058f, 0.00195312500000f, 0.00155019633981f, 0.00123039165029f, 0.00097656250000f, 0.00077509816991f, 0.00061519582514f, 0.00048828125000f, 0.00038754908495f, 0.00030759791257f, 0.00024414062500f, 0.00019377454248f, 0.00015379895629f, 0.00012207031250f, 0.00009688727124f, 0.00007689947814f, 0.00006103515625f, 0.00004844363562f, 0.00003844973907f, 0.00003051757813f, 0.00002422181781f, 0.00001922486954f, 0.00001525878906f, 0.00001211090890f, 0.00000961243477f, 0.00000762939453f, 0.00000605545445f, 0.00000480621738f, 0.00000381469727f, 0.00000302772723f, 0.00000240310869f, 0.00000190734863f, 0.00000151386361f, 0.00000120155435f};
  private static final int[] SCALEFACTOR_SIZES_LAYER_III = {
          0, 0, 0, 1, 0, 2, 0, 3,
          3, 0, 1, 1, 1, 2, 1, 3,
          2, 1, 2, 2, 2, 3, 3, 1,
          3, 2, 3, 3, 4, 2, 4, 3};
  private static final int[] SCALEFACTOR_BAND_INDICES_LAYER_III = {
          0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162,
          196, 238, 288, 342, 418, 576,
          0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192
          ,
          
          0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156,
          190, 230, 276, 330, 384, 576,
          0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192
          ,
          
          0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194,
          240, 296, 364, 448, 550, 576,
          0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192
  };
  private static final float[] CS_ALIASING_LAYER_III = {0.857493f, 0.881742f, 0.949629f, 0.983315f, 0.995518f, 0.999161f, 0.999899f, 0.999993f};
  private static final float[] CA_ALIASING_LAYER_III = {-0.514496f, -0.471732f, -0.313377f, -0.181913f, -0.094574f, -0.040966f, -0.014199f, -0.003700f};
  private static final float[] POWTAB_LAYER_III;
  private static final float[] IS_RATIOS_LAYER_III;
  private static final float[] IMDCT_WINDOW_LAYER_III;
  private static final float[] PRE_FRACTOR_LAYER_I;
  private static final float[] NIK_COEFFICIENTS;
  private static final float[] SYNTH_WINDOW_TABLE_LAYER_III;
  private static final float[] DI_COEFFICIENTS = {0.000000000f, -0.000015259f, -0.000015259f, -0.000015259f, -0.000015259f, -0.000015259f, -0.000015259f, -0.000030518f, -0.000030518f, -0.000030518f, -0.000030518f, -0.000045776f, -0.000045776f, -0.000061035f, -0.000061035f, -0.000076294f, -0.000076294f, -0.000091553f, -0.000106812f, -0.000106812f, -0.000122070f, -0.000137329f, -0.000152588f, -0.000167847f, -0.000198364f, -0.000213623f, -0.000244141f, -0.000259399f, -0.000289917f, -0.000320435f, -0.000366211f, -0.000396729f, -0.000442505f, -0.000473022f, -0.000534058f, -0.000579834f, -0.000625610f, -0.000686646f, -0.000747681f, -0.000808716f, -0.000885010f, -0.000961304f, -0.001037598f, -0.001113892f, -0.001205444f, -0.001296997f, -0.001388550f, -0.001480103f, -0.001586914f, -0.001693726f, -0.001785278f, -0.001907349f, -0.002014160f, -0.002120972f, -0.002243042f, -0.002349854f, -0.002456665f, -0.002578735f, -0.002685547f, -0.002792358f, -0.002899170f, -0.002990723f, -0.003082275f, -0.003173828f, 0.003250122f, 0.003326416f, 0.003387451f, 0.003433228f, 0.003463745f, 0.003479004f, 0.003479004f, 0.003463745f, 0.003417969f, 0.003372192f, 0.003280640f, 0.003173828f, 0.003051758f, 0.002883911f, 0.002700806f, 0.002487183f, 0.002227783f, 0.001937866f, 0.001617432f, 0.001266479f, 0.000869751f, 0.000442505f, -0.000030518f, -0.000549316f, -0.001098633f, -0.001693726f, -0.002334595f, -0.003005981f, -0.003723145f, -0.004486084f, -0.005294800f, -0.006118774f, -0.007003784f, -0.007919312f, -0.008865356f, -0.009841919f, -0.010848999f, -0.011886597f, -0.012939453f, -0.014022827f, -0.015121460f, -0.016235352f, -0.017349243f, -0.018463135f, -0.019577026f, -0.020690918f, -0.021789551f, -0.022857666f, -0.023910522f, -0.024932861f, -0.025909424f, -0.026840210f, -0.027725220f, -0.028533936f, -0.029281616f, -0.029937744f, -0.030532837f, -0.031005859f, -0.031387329f, -0.031661987f, -0.031814575f, -0.031845093f, -0.031738281f, -0.031478882f, 0.031082153f, 0.030517578f, 0.029785156f, 0.028884888f, 0.027801514f, 0.026535034f, 0.025085449f, 0.023422241f, 0.021575928f, 0.019531250f, 0.017257690f, 0.014801025f, 0.012115479f, 0.009231567f, 0.006134033f, 0.002822876f, -0.000686646f, -0.004394531f, -0.008316040f, -0.012420654f, -0.016708374f, -0.021179199f, -0.025817871f, -0.030609131f, -0.035552979f, -0.040634155f, -0.045837402f, -0.051132202f, -0.056533813f, -0.061996460f, -0.067520142f, -0.073059082f, -0.078628540f, -0.084182739f, -0.089706421f, -0.095169067f, -0.100540161f, -0.105819702f, -0.110946655f, -0.115921021f, -0.120697021f, -0.125259399f, -0.129562378f, -0.133590698f, -0.137298584f, -0.140670776f, -0.143676758f, -0.146255493f, -0.148422241f, -0.150115967f, -0.151306152f, -0.151962280f, -0.152069092f, -0.151596069f, -0.150497437f, -0.148773193f, -0.146362305f, -0.143264771f, -0.139450073f, -0.134887695f, -0.129577637f, -0.123474121f, -0.116577148f, -0.108856201f, 0.100311279f, 0.090927124f, 0.080688477f, 0.069595337f, 0.057617187f, 0.044784546f, 0.031082153f, 0.016510010f, 0.001068115f, -0.015228271f, -0.032379150f, -0.050354004f, -0.069168091f, -0.088775635f, -0.109161377f, -0.130310059f, -0.152206421f, -0.174789429f, -0.198059082f, -0.221984863f, -0.246505737f, -0.271591187f, -0.297210693f, -0.323318481f, -0.349868774f, -0.376800537f, -0.404083252f, -0.431655884f, -0.459472656f, -0.487472534f, -0.515609741f, -0.543823242f, -0.572036743f, -0.600219727f, -0.628295898f, -0.656219482f, -0.683914185f, -0.711318970f, -0.738372803f, -0.765029907f, -0.791213989f, -0.816864014f, -0.841949463f, -0.866363525f, -0.890090942f, -0.913055420f, -0.935195923f, -0.956481934f, -0.976852417f, -0.996246338f, -1.014617920f, -1.031936646f, -1.048156738f, -1.063217163f, -1.077117920f, -1.089782715f, -1.101211548f, -1.111373901f, -1.120223999f, -1.127746582f, -1.133926392f, -1.138763428f, -1.142211914f, -1.144287109f, 1.144989014f, 1.144287109f, 1.142211914f, 1.138763428f, 1.133926392f, 1.127746582f, 1.120223999f, 1.111373901f, 1.101211548f, 1.089782715f, 1.077117920f, 1.063217163f, 1.048156738f, 1.031936646f, 1.014617920f, 0.996246338f, 0.976852417f, 0.956481934f, 0.935195923f, 0.913055420f, 0.890090942f, 0.866363525f, 0.841949463f, 0.816864014f, 0.791213989f, 0.765029907f, 0.738372803f, 0.711318970f, 0.683914185f, 0.656219482f, 0.628295898f, 0.600219727f, 0.572036743f, 0.543823242f, 0.515609741f, 0.487472534f, 0.459472656f, 0.431655884f, 0.404083252f, 0.376800537f, 0.349868774f, 0.323318481f, 0.297210693f, 0.271591187f, 0.246505737f, 0.221984863f, 0.198059082f, 0.174789429f, 0.152206421f, 0.130310059f, 0.109161377f, 0.088775635f, 0.069168091f, 0.050354004f, 0.032379150f, 0.015228271f, -0.001068115f, -0.016510010f, -0.031082153f, -0.044784546f, -0.057617187f, -0.069595337f, -0.080688477f, -0.090927124f, 0.100311279f, 0.108856201f, 0.116577148f, 0.123474121f, 0.129577637f, 0.134887695f, 0.139450073f, 0.143264771f, 0.146362305f, 0.148773193f, 0.150497437f, 0.151596069f, 0.152069092f, 0.151962280f, 0.151306152f, 0.150115967f, 0.148422241f, 0.146255493f, 0.143676758f, 0.140670776f, 0.137298584f, 0.133590698f, 0.129562378f, 0.125259399f, 0.120697021f, 0.115921021f, 0.110946655f, 0.105819702f, 0.100540161f, 0.095169067f, 0.089706421f, 0.084182739f, 0.078628540f, 0.073059082f, 0.067520142f, 0.061996460f, 0.056533813f, 0.051132202f, 0.045837402f, 0.040634155f, 0.035552979f, 0.030609131f, 0.025817871f, 0.021179199f, 0.016708374f, 0.012420654f, 0.008316040f, 0.004394531f, 0.000686646f, -0.002822876f, -0.006134033f, -0.009231567f, -0.012115479f, -0.014801025f, -0.017257690f, -0.019531250f, -0.021575928f, -0.023422241f, -0.025085449f, -0.026535034f, -0.027801514f, -0.028884888f, -0.029785156f, -0.030517578f, 0.031082153f, 0.031478882f, 0.031738281f, 0.031845093f, 0.031814575f, 0.031661987f, 0.031387329f, 0.031005859f, 0.030532837f, 0.029937744f, 0.029281616f, 0.028533936f, 0.027725220f, 0.026840210f, 0.025909424f, 0.024932861f, 0.023910522f, 0.022857666f, 0.021789551f, 0.020690918f, 0.019577026f, 0.018463135f, 0.017349243f, 0.016235352f, 0.015121460f, 0.014022827f, 0.012939453f, 0.011886597f, 0.010848999f, 0.009841919f, 0.008865356f, 0.007919312f, 0.007003784f, 0.006118774f, 0.005294800f, 0.004486084f, 0.003723145f, 0.003005981f, 0.002334595f, 0.001693726f, 0.001098633f, 0.000549316f, 0.000030518f, -0.000442505f, -0.000869751f, -0.001266479f, -0.001617432f, -0.001937866f, -0.002227783f, -0.002487183f, -0.002700806f, -0.002883911f, -0.003051758f, -0.003173828f, -0.003280640f, -0.003372192f, -0.003417969f, -0.003463745f, -0.003479004f, -0.003479004f, -0.003463745f, -0.003433228f, -0.003387451f, -0.003326416f, 0.003250122f, 0.003173828f, 0.003082275f, 0.002990723f, 0.002899170f, 0.002792358f, 0.002685547f, 0.002578735f, 0.002456665f, 0.002349854f, 0.002243042f, 0.002120972f, 0.002014160f, 0.001907349f, 0.001785278f, 0.001693726f, 0.001586914f, 0.001480103f, 0.001388550f, 0.001296997f, 0.001205444f, 0.001113892f, 0.001037598f, 0.000961304f, 0.000885010f, 0.000808716f, 0.000747681f, 0.000686646f, 0.000625610f, 0.000579834f, 0.000534058f, 0.000473022f, 0.000442505f, 0.000396729f, 0.000366211f, 0.000320435f, 0.000289917f, 0.000259399f, 0.000244141f, 0.000213623f, 0.000198364f, 0.000167847f, 0.000152588f, 0.000137329f, 0.000122070f, 0.000106812f, 0.000106812f, 0.000091553f, 0.000076294f, 0.000076294f, 0.000061035f, 0.000061035f, 0.000045776f, 0.000045776f, 0.000030518f, 0.000030518f, 0.000030518f, 0.000030518f, 0.000015259f, 0.000015259f, 0.000015259f, 0.000015259f, 0.000015259f, 0.000015259f};
  private static final int[] SHIFT_ENDIANESS = {255, 254, 253, 252, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
  private static final int[] SB_LIMIT = {27, 30, 8, 12};
  private static final int[][] NBAL = {{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2}, {4, 4, 3, 3, 3, 3, 3, 3}, {4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
  private static final int[][][] QUANTIZATION_INDEX_LAYER_II = {{{0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}}, {{0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}}, {{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}}, {{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}}};
  private static final int[] NLEVELS = {3, 5, 7, 9, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767, 65535};
  private static final float[] C_LAYER_II = {1.33333333333f, 1.60000000000f, 1.14285714286f, 1.77777777777f, 1.06666666666f, 1.03225806452f, 1.01587301587f, 1.00787401575f, 1.00392156863f, 1.00195694716f, 1.00097751711f, 1.00048851979f, 1.00024420024f, 1.00012208522f, 1.00006103888f, 1.00003051851f, 1.00001525902f};
  private static final float[] D_LAYER_II = {0.50000000000f, 0.50000000000f, 0.25000000000f, 0.50000000000f, 0.12500000000f, 0.06250000000f, 0.03125000000f, 0.01562500000f, 0.00781250000f, 0.00390625000f, 0.00195312500f, 0.00097656250f, 0.00048828125f, 0.00024414063f, 0.00012207031f, 0.00006103516f, 0.00003051758f};
  private static final boolean[] GROUPING_LAYER_II = {true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
  private static final int[] BITS_LAYER_II = {5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
  private static final int[] HUFFMAN_TABLE_LAYER_III = {
          //g_huffman_table_1[7] = {
          0x0201, 0x0000, 0x0201, 0x0010, 0x0201, 0x0001, 0x0011,
          //},g_huffman_table_2[17] = {
          0x0201, 0x0000, 0x0401, 0x0201, 0x0010, 0x0001, 0x0201, 0x0011, 0x0401, 0x0201, 0x0020,
          0x0021, 0x0201, 0x0012, 0x0201, 0x0002, 0x0022,
          //},g_huffman_table_3[17] = {
          0x0401, 0x0201, 0x0000, 0x0001, 0x0201, 0x0011, 0x0201, 0x0010, 0x0401, 0x0201, 0x0020,
          0x0021, 0x0201, 0x0012, 0x0201, 0x0002, 0x0022,
          //},g_huffman_table_5[31] = {
          0x0201, 0x0000, 0x0401, 0x0201, 0x0010, 0x0001, 0x0201, 0x0011, 0x0801, 0x0401, 0x0201,
          0x0020, 0x0002, 0x0201, 0x0021, 0x0012, 0x0801, 0x0401, 0x0201, 0x0022, 0x0030, 0x0201,
          0x0003, 0x0013, 0x0201, 0x0031, 0x0201, 0x0032, 0x0201, 0x0023, 0x0033,
          //},g_huffman_table_6[31] = {
          0x0601, 0x0401, 0x0201, 0x0000, 0x0010, 0x0011, 0x0601, 0x0201, 0x0001, 0x0201, 0x0020,
          0x0021, 0x0601, 0x0201, 0x0012, 0x0201, 0x0002, 0x0022, 0x0401, 0x0201, 0x0031, 0x0013,
          0x0401, 0x0201, 0x0030, 0x0032, 0x0201, 0x0023, 0x0201, 0x0003, 0x0033,
          //},g_huffman_table_7[71] = {
          0x0201, 0x0000, 0x0401, 0x0201, 0x0010, 0x0001, 0x0801, 0x0201, 0x0011, 0x0401, 0x0201,
          0x0020, 0x0002, 0x0021, 0x1201, 0x0601, 0x0201, 0x0012, 0x0201, 0x0022, 0x0030, 0x0401,
          0x0201, 0x0031, 0x0013, 0x0401, 0x0201, 0x0003, 0x0032, 0x0201, 0x0023, 0x0004, 0x0a01,
          0x0401, 0x0201, 0x0040, 0x0041, 0x0201, 0x0014, 0x0201, 0x0042, 0x0024, 0x0c01, 0x0601,
          0x0401, 0x0201, 0x0033, 0x0043, 0x0050, 0x0401, 0x0201, 0x0034, 0x0005, 0x0051, 0x0601,
          0x0201, 0x0015, 0x0201, 0x0052, 0x0025, 0x0401, 0x0201, 0x0044, 0x0035, 0x0401, 0x0201,
          0x0053, 0x0054, 0x0201, 0x0045, 0x0055,
          //},g_huffman_table_8[71] = {
          0x0601, 0x0201, 0x0000, 0x0201, 0x0010, 0x0001, 0x0201, 0x0011, 0x0401, 0x0201, 0x0021,
          0x0012, 0x0e01, 0x0401, 0x0201, 0x0020, 0x0002, 0x0201, 0x0022, 0x0401, 0x0201, 0x0030,
          0x0003, 0x0201, 0x0031, 0x0013, 0x0e01, 0x0801, 0x0401, 0x0201, 0x0032, 0x0023, 0x0201,
          0x0040, 0x0004, 0x0201, 0x0041, 0x0201, 0x0014, 0x0042, 0x0c01, 0x0601, 0x0201, 0x0024,
          0x0201, 0x0033, 0x0050, 0x0401, 0x0201, 0x0043, 0x0034, 0x0051, 0x0601, 0x0201, 0x0015,
          0x0201, 0x0005, 0x0052, 0x0601, 0x0201, 0x0025, 0x0201, 0x0044, 0x0035, 0x0201, 0x0053,
          0x0201, 0x0045, 0x0201, 0x0054, 0x0055,
          //},g_huffman_table_9[71] = {
          0x0801, 0x0401, 0x0201, 0x0000, 0x0010, 0x0201, 0x0001, 0x0011, 0x0a01, 0x0401, 0x0201,
          0x0020, 0x0021, 0x0201, 0x0012, 0x0201, 0x0002, 0x0022, 0x0c01, 0x0601, 0x0401, 0x0201,
          0x0030, 0x0003, 0x0031, 0x0201, 0x0013, 0x0201, 0x0032, 0x0023, 0x0c01, 0x0401, 0x0201,
          0x0041, 0x0014, 0x0401, 0x0201, 0x0040, 0x0033, 0x0201, 0x0042, 0x0024, 0x0a01, 0x0601,
          0x0401, 0x0201, 0x0004, 0x0050, 0x0043, 0x0201, 0x0034, 0x0051, 0x0801, 0x0401, 0x0201,
          0x0015, 0x0052, 0x0201, 0x0025, 0x0044, 0x0601, 0x0401, 0x0201, 0x0005, 0x0054, 0x0053,
          0x0201, 0x0035, 0x0201, 0x0045, 0x0055,
          //},g_huffman_table_10[127] = {
          0x0201, 0x0000, 0x0401, 0x0201, 0x0010, 0x0001, 0x0a01, 0x0201, 0x0011, 0x0401, 0x0201,
          0x0020, 0x0002, 0x0201, 0x0021, 0x0012, 0x1c01, 0x0801, 0x0401, 0x0201, 0x0022, 0x0030,
          0x0201, 0x0031, 0x0013, 0x0801, 0x0401, 0x0201, 0x0003, 0x0032, 0x0201, 0x0023, 0x0040,
          0x0401, 0x0201, 0x0041, 0x0014, 0x0401, 0x0201, 0x0004, 0x0033, 0x0201, 0x0042, 0x0024,
          0x1c01, 0x0a01, 0x0601, 0x0401, 0x0201, 0x0050, 0x0005, 0x0060, 0x0201, 0x0061, 0x0016,
          0x0c01, 0x0601, 0x0401, 0x0201, 0x0043, 0x0034, 0x0051, 0x0201, 0x0015, 0x0201, 0x0052,
          0x0025, 0x0401, 0x0201, 0x0026, 0x0036, 0x0071, 0x1401, 0x0801, 0x0201, 0x0017, 0x0401,
          0x0201, 0x0044, 0x0053, 0x0006, 0x0601, 0x0401, 0x0201, 0x0035, 0x0045, 0x0062, 0x0201,
          0x0070, 0x0201, 0x0007, 0x0064, 0x0e01, 0x0401, 0x0201, 0x0072, 0x0027, 0x0601, 0x0201,
          0x0063, 0x0201, 0x0054, 0x0055, 0x0201, 0x0046, 0x0073, 0x0801, 0x0401, 0x0201, 0x0037,
          0x0065, 0x0201, 0x0056, 0x0074, 0x0601, 0x0201, 0x0047, 0x0201, 0x0066, 0x0075, 0x0401,
          0x0201, 0x0057, 0x0076, 0x0201, 0x0067, 0x0077,
          //},g_huffman_table_11[127] = {
          0x0601, 0x0201, 0x0000, 0x0201, 0x0010, 0x0001, 0x0801, 0x0201, 0x0011, 0x0401, 0x0201,
          0x0020, 0x0002, 0x0012, 0x1801, 0x0801, 0x0201, 0x0021, 0x0201, 0x0022, 0x0201, 0x0030,
          0x0003, 0x0401, 0x0201, 0x0031, 0x0013, 0x0401, 0x0201, 0x0032, 0x0023, 0x0401, 0x0201,
          0x0040, 0x0004, 0x0201, 0x0041, 0x0014, 0x1e01, 0x1001, 0x0a01, 0x0401, 0x0201, 0x0042,
          0x0024, 0x0401, 0x0201, 0x0033, 0x0043, 0x0050, 0x0401, 0x0201, 0x0034, 0x0051, 0x0061,
          0x0601, 0x0201, 0x0016, 0x0201, 0x0006, 0x0026, 0x0201, 0x0062, 0x0201, 0x0015, 0x0201,
          0x0005, 0x0052, 0x1001, 0x0a01, 0x0601, 0x0401, 0x0201, 0x0025, 0x0044, 0x0060, 0x0201,
          0x0063, 0x0036, 0x0401, 0x0201, 0x0070, 0x0017, 0x0071, 0x1001, 0x0601, 0x0401, 0x0201,
          0x0007, 0x0064, 0x0072, 0x0201, 0x0027, 0x0401, 0x0201, 0x0053, 0x0035, 0x0201, 0x0054,
          0x0045, 0x0a01, 0x0401, 0x0201, 0x0046, 0x0073, 0x0201, 0x0037, 0x0201, 0x0065, 0x0056,
          0x0a01, 0x0601, 0x0401, 0x0201, 0x0055, 0x0057, 0x0074, 0x0201, 0x0047, 0x0066, 0x0401,
          0x0201, 0x0075, 0x0076, 0x0201, 0x0067, 0x0077,
          //},g_huffman_table_12[127] = {
          0x0c01, 0x0401, 0x0201, 0x0010, 0x0001, 0x0201, 0x0011, 0x0201, 0x0000, 0x0201, 0x0020,
          0x0002, 0x1001, 0x0401, 0x0201, 0x0021, 0x0012, 0x0401, 0x0201, 0x0022, 0x0031, 0x0201,
          0x0013, 0x0201, 0x0030, 0x0201, 0x0003, 0x0040, 0x1a01, 0x0801, 0x0401, 0x0201, 0x0032,
          0x0023, 0x0201, 0x0041, 0x0033, 0x0a01, 0x0401, 0x0201, 0x0014, 0x0042, 0x0201, 0x0024,
          0x0201, 0x0004, 0x0050, 0x0401, 0x0201, 0x0043, 0x0034, 0x0201, 0x0051, 0x0015, 0x1c01,
          0x0e01, 0x0801, 0x0401, 0x0201, 0x0052, 0x0025, 0x0201, 0x0053, 0x0035, 0x0401, 0x0201,
          0x0060, 0x0016, 0x0061, 0x0401, 0x0201, 0x0062, 0x0026, 0x0601, 0x0401, 0x0201, 0x0005,
          0x0006, 0x0044, 0x0201, 0x0054, 0x0045, 0x1201, 0x0a01, 0x0401, 0x0201, 0x0063, 0x0036,
          0x0401, 0x0201, 0x0070, 0x0007, 0x0071, 0x0401, 0x0201, 0x0017, 0x0064, 0x0201, 0x0046,
          0x0072, 0x0a01, 0x0601, 0x0201, 0x0027, 0x0201, 0x0055, 0x0073, 0x0201, 0x0037, 0x0056,
          0x0801, 0x0401, 0x0201, 0x0065, 0x0074, 0x0201, 0x0047, 0x0066, 0x0401, 0x0201, 0x0075,
          0x0057, 0x0201, 0x0076, 0x0201, 0x0067, 0x0077,
          //},g_huffman_table_13[511] = {
          0x0201, 0x0000, 0x0601, 0x0201, 0x0010, 0x0201, 0x0001, 0x0011, 0x1c01, 0x0801, 0x0401,
          0x0201, 0x0020, 0x0002, 0x0201, 0x0021, 0x0012, 0x0801, 0x0401, 0x0201, 0x0022, 0x0030,
          0x0201, 0x0003, 0x0031, 0x0601, 0x0201, 0x0013, 0x0201, 0x0032, 0x0023, 0x0401, 0x0201,
          0x0040, 0x0004, 0x0041, 0x4601, 0x1c01, 0x0e01, 0x0601, 0x0201, 0x0014, 0x0201, 0x0033,
          0x0042, 0x0401, 0x0201, 0x0024, 0x0050, 0x0201, 0x0043, 0x0034, 0x0401, 0x0201, 0x0051,
          0x0015, 0x0401, 0x0201, 0x0005, 0x0052, 0x0201, 0x0025, 0x0201, 0x0044, 0x0053, 0x0e01,
          0x0801, 0x0401, 0x0201, 0x0060, 0x0006, 0x0201, 0x0061, 0x0016, 0x0401, 0x0201, 0x0080,
          0x0008, 0x0081, 0x1001, 0x0801, 0x0401, 0x0201, 0x0035, 0x0062, 0x0201, 0x0026, 0x0054,
          0x0401, 0x0201, 0x0045, 0x0063, 0x0201, 0x0036, 0x0070, 0x0601, 0x0401, 0x0201, 0x0007,
          0x0055, 0x0071, 0x0201, 0x0017, 0x0201, 0x0027, 0x0037, 0x4801, 0x1801, 0x0c01, 0x0401,
          0x0201, 0x0018, 0x0082, 0x0201, 0x0028, 0x0401, 0x0201, 0x0064, 0x0046, 0x0072, 0x0801,
          0x0401, 0x0201, 0x0084, 0x0048, 0x0201, 0x0090, 0x0009, 0x0201, 0x0091, 0x0019, 0x1801,
          0x0e01, 0x0801, 0x0401, 0x0201, 0x0073, 0x0065, 0x0201, 0x0056, 0x0074, 0x0401, 0x0201,
          0x0047, 0x0066, 0x0083, 0x0601, 0x0201, 0x0038, 0x0201, 0x0075, 0x0057, 0x0201, 0x0092,
          0x0029, 0x0e01, 0x0801, 0x0401, 0x0201, 0x0067, 0x0085, 0x0201, 0x0058, 0x0039, 0x0201,
          0x0093, 0x0201, 0x0049, 0x0086, 0x0601, 0x0201, 0x00a0, 0x0201, 0x0068, 0x000a, 0x0201,
          0x00a1, 0x001a, 0x4401, 0x1801, 0x0c01, 0x0401, 0x0201, 0x00a2, 0x002a, 0x0401, 0x0201,
          0x0095, 0x0059, 0x0201, 0x00a3, 0x003a, 0x0801, 0x0401, 0x0201, 0x004a, 0x0096, 0x0201,
          0x00b0, 0x000b, 0x0201, 0x00b1, 0x001b, 0x1401, 0x0801, 0x0201, 0x00b2, 0x0401, 0x0201,
          0x0076, 0x0077, 0x0094, 0x0601, 0x0401, 0x0201, 0x0087, 0x0078, 0x00a4, 0x0401, 0x0201,
          0x0069, 0x00a5, 0x002b, 0x0c01, 0x0601, 0x0401, 0x0201, 0x005a, 0x0088, 0x00b3, 0x0201,
          0x003b, 0x0201, 0x0079, 0x00a6, 0x0601, 0x0401, 0x0201, 0x006a, 0x00b4, 0x00c0, 0x0401,
          0x0201, 0x000c, 0x0098, 0x00c1, 0x3c01, 0x1601, 0x0a01, 0x0601, 0x0201, 0x001c, 0x0201,
          0x0089, 0x00b5, 0x0201, 0x005b, 0x00c2, 0x0401, 0x0201, 0x002c, 0x003c, 0x0401, 0x0201,
          0x00b6, 0x006b, 0x0201, 0x00c4, 0x004c, 0x1001, 0x0801, 0x0401, 0x0201, 0x00a8, 0x008a,
          0x0201, 0x00d0, 0x000d, 0x0201, 0x00d1, 0x0201, 0x004b, 0x0201, 0x0097, 0x00a7, 0x0c01,
          0x0601, 0x0201, 0x00c3, 0x0201, 0x007a, 0x0099, 0x0401, 0x0201, 0x00c5, 0x005c, 0x00b7,
          0x0401, 0x0201, 0x001d, 0x00d2, 0x0201, 0x002d, 0x0201, 0x007b, 0x00d3, 0x3401, 0x1c01,
          0x0c01, 0x0401, 0x0201, 0x003d, 0x00c6, 0x0401, 0x0201, 0x006c, 0x00a9, 0x0201, 0x009a,
          0x00d4, 0x0801, 0x0401, 0x0201, 0x00b8, 0x008b, 0x0201, 0x004d, 0x00c7, 0x0401, 0x0201,
          0x007c, 0x00d5, 0x0201, 0x005d, 0x00e0, 0x0a01, 0x0401, 0x0201, 0x00e1, 0x001e, 0x0401,
          0x0201, 0x000e, 0x002e, 0x00e2, 0x0801, 0x0401, 0x0201, 0x00e3, 0x006d, 0x0201, 0x008c,
          0x00e4, 0x0401, 0x0201, 0x00e5, 0x00ba, 0x00f0, 0x2601, 0x1001, 0x0401, 0x0201, 0x00f1,
          0x001f, 0x0601, 0x0401, 0x0201, 0x00aa, 0x009b, 0x00b9, 0x0201, 0x003e, 0x0201, 0x00d6,
          0x00c8, 0x0c01, 0x0601, 0x0201, 0x004e, 0x0201, 0x00d7, 0x007d, 0x0201, 0x00ab, 0x0201,
          0x005e, 0x00c9, 0x0601, 0x0201, 0x000f, 0x0201, 0x009c, 0x006e, 0x0201, 0x00f2, 0x002f,
          0x2001, 0x1001, 0x0601, 0x0401, 0x0201, 0x00d8, 0x008d, 0x003f, 0x0601, 0x0201, 0x00f3,
          0x0201, 0x00e6, 0x00ca, 0x0201, 0x00f4, 0x004f, 0x0801, 0x0401, 0x0201, 0x00bb, 0x00ac,
          0x0201, 0x00e7, 0x00f5, 0x0401, 0x0201, 0x00d9, 0x009d, 0x0201, 0x005f, 0x00e8, 0x1e01,
          0x0c01, 0x0601, 0x0201, 0x006f, 0x0201, 0x00f6, 0x00cb, 0x0401, 0x0201, 0x00bc, 0x00ad,
          0x00da, 0x0801, 0x0201, 0x00f7, 0x0401, 0x0201, 0x007e, 0x007f, 0x008e, 0x0601, 0x0401,
          0x0201, 0x009e, 0x00ae, 0x00cc, 0x0201, 0x00f8, 0x008f, 0x1201, 0x0801, 0x0401, 0x0201,
          0x00db, 0x00bd, 0x0201, 0x00ea, 0x00f9, 0x0401, 0x0201, 0x009f, 0x00eb, 0x0201, 0x00be,
          0x0201, 0x00cd, 0x00fa, 0x0e01, 0x0401, 0x0201, 0x00dd, 0x00ec, 0x0601, 0x0401, 0x0201,
          0x00e9, 0x00af, 0x00dc, 0x0201, 0x00ce, 0x00fb, 0x0801, 0x0401, 0x0201, 0x00bf, 0x00de,
          0x0201, 0x00cf, 0x00ee, 0x0401, 0x0201, 0x00df, 0x00ef, 0x0201, 0x00ff, 0x0201, 0x00ed,
          0x0201, 0x00fd, 0x0201, 0x00fc, 0x00fe,
          //},g_huffman_table_15[511] = {
          0x1001, 0x0601, 0x0201, 0x0000, 0x0201, 0x0010, 0x0001, 0x0201, 0x0011, 0x0401, 0x0201,
          0x0020, 0x0002, 0x0201, 0x0021, 0x0012, 0x3201, 0x1001, 0x0601, 0x0201, 0x0022, 0x0201,
          0x0030, 0x0031, 0x0601, 0x0201, 0x0013, 0x0201, 0x0003, 0x0040, 0x0201, 0x0032, 0x0023,
          0x0e01, 0x0601, 0x0401, 0x0201, 0x0004, 0x0014, 0x0041, 0x0401, 0x0201, 0x0033, 0x0042,
          0x0201, 0x0024, 0x0043, 0x0a01, 0x0601, 0x0201, 0x0034, 0x0201, 0x0050, 0x0005, 0x0201,
          0x0051, 0x0015, 0x0401, 0x0201, 0x0052, 0x0025, 0x0401, 0x0201, 0x0044, 0x0053, 0x0061,
          0x5a01, 0x2401, 0x1201, 0x0a01, 0x0601, 0x0201, 0x0035, 0x0201, 0x0060, 0x0006, 0x0201,
          0x0016, 0x0062, 0x0401, 0x0201, 0x0026, 0x0054, 0x0201, 0x0045, 0x0063, 0x0a01, 0x0601,
          0x0201, 0x0036, 0x0201, 0x0070, 0x0007, 0x0201, 0x0071, 0x0055, 0x0401, 0x0201, 0x0017,
          0x0064, 0x0201, 0x0072, 0x0027, 0x1801, 0x1001, 0x0801, 0x0401, 0x0201, 0x0046, 0x0073,
          0x0201, 0x0037, 0x0065, 0x0401, 0x0201, 0x0056, 0x0080, 0x0201, 0x0008, 0x0074, 0x0401,
          0x0201, 0x0081, 0x0018, 0x0201, 0x0082, 0x0028, 0x1001, 0x0801, 0x0401, 0x0201, 0x0047,
          0x0066, 0x0201, 0x0083, 0x0038, 0x0401, 0x0201, 0x0075, 0x0057, 0x0201, 0x0084, 0x0048,
          0x0601, 0x0401, 0x0201, 0x0090, 0x0019, 0x0091, 0x0401, 0x0201, 0x0092, 0x0076, 0x0201,
          0x0067, 0x0029, 0x5c01, 0x2401, 0x1201, 0x0a01, 0x0401, 0x0201, 0x0085, 0x0058, 0x0401,
          0x0201, 0x0009, 0x0077, 0x0093, 0x0401, 0x0201, 0x0039, 0x0094, 0x0201, 0x0049, 0x0086,
          0x0a01, 0x0601, 0x0201, 0x0068, 0x0201, 0x00a0, 0x000a, 0x0201, 0x00a1, 0x001a, 0x0401,
          0x0201, 0x00a2, 0x002a, 0x0201, 0x0095, 0x0059, 0x1a01, 0x0e01, 0x0601, 0x0201, 0x00a3,
          0x0201, 0x003a, 0x0087, 0x0401, 0x0201, 0x0078, 0x00a4, 0x0201, 0x004a, 0x0096, 0x0601,
          0x0401, 0x0201, 0x0069, 0x00b0, 0x00b1, 0x0401, 0x0201, 0x001b, 0x00a5, 0x00b2, 0x0e01,
          0x0801, 0x0401, 0x0201, 0x005a, 0x002b, 0x0201, 0x0088, 0x0097, 0x0201, 0x00b3, 0x0201,
          0x0079, 0x003b, 0x0801, 0x0401, 0x0201, 0x006a, 0x00b4, 0x0201, 0x004b, 0x00c1, 0x0401,
          0x0201, 0x0098, 0x0089, 0x0201, 0x001c, 0x00b5, 0x5001, 0x2201, 0x1001, 0x0601, 0x0401,
          0x0201, 0x005b, 0x002c, 0x00c2, 0x0601, 0x0401, 0x0201, 0x000b, 0x00c0, 0x00a6, 0x0201,
          0x00a7, 0x007a, 0x0a01, 0x0401, 0x0201, 0x00c3, 0x003c, 0x0401, 0x0201, 0x000c, 0x0099,
          0x00b6, 0x0401, 0x0201, 0x006b, 0x00c4, 0x0201, 0x004c, 0x00a8, 0x1401, 0x0a01, 0x0401,
          0x0201, 0x008a, 0x00c5, 0x0401, 0x0201, 0x00d0, 0x005c, 0x00d1, 0x0401, 0x0201, 0x00b7,
          0x007b, 0x0201, 0x001d, 0x0201, 0x000d, 0x002d, 0x0c01, 0x0401, 0x0201, 0x00d2, 0x00d3,
          0x0401, 0x0201, 0x003d, 0x00c6, 0x0201, 0x006c, 0x00a9, 0x0601, 0x0401, 0x0201, 0x009a,
          0x00b8, 0x00d4, 0x0401, 0x0201, 0x008b, 0x004d, 0x0201, 0x00c7, 0x007c, 0x4401, 0x2201,
          0x1201, 0x0a01, 0x0401, 0x0201, 0x00d5, 0x005d, 0x0401, 0x0201, 0x00e0, 0x000e, 0x00e1,
          0x0401, 0x0201, 0x001e, 0x00e2, 0x0201, 0x00aa, 0x002e, 0x0801, 0x0401, 0x0201, 0x00b9,
          0x009b, 0x0201, 0x00e3, 0x00d6, 0x0401, 0x0201, 0x006d, 0x003e, 0x0201, 0x00c8, 0x008c,
          0x1001, 0x0801, 0x0401, 0x0201, 0x00e4, 0x004e, 0x0201, 0x00d7, 0x007d, 0x0401, 0x0201,
          0x00e5, 0x00ba, 0x0201, 0x00ab, 0x005e, 0x0801, 0x0401, 0x0201, 0x00c9, 0x009c, 0x0201,
          0x00f1, 0x001f, 0x0601, 0x0401, 0x0201, 0x00f0, 0x006e, 0x00f2, 0x0201, 0x002f, 0x00e6,
          0x2601, 0x1201, 0x0801, 0x0401, 0x0201, 0x00d8, 0x00f3, 0x0201, 0x003f, 0x00f4, 0x0601,
          0x0201, 0x004f, 0x0201, 0x008d, 0x00d9, 0x0201, 0x00bb, 0x00ca, 0x0801, 0x0401, 0x0201,
          0x00ac, 0x00e7, 0x0201, 0x007e, 0x00f5, 0x0801, 0x0401, 0x0201, 0x009d, 0x005f, 0x0201,
          0x00e8, 0x008e, 0x0201, 0x00f6, 0x00cb, 0x2201, 0x1201, 0x0a01, 0x0601, 0x0401, 0x0201,
          0x000f, 0x00ae, 0x006f, 0x0201, 0x00bc, 0x00da, 0x0401, 0x0201, 0x00ad, 0x00f7, 0x0201,
          0x007f, 0x00e9, 0x0801, 0x0401, 0x0201, 0x009e, 0x00cc, 0x0201, 0x00f8, 0x008f, 0x0401,
          0x0201, 0x00db, 0x00bd, 0x0201, 0x00ea, 0x00f9, 0x1001, 0x0801, 0x0401, 0x0201, 0x009f,
          0x00dc, 0x0201, 0x00cd, 0x00eb, 0x0401, 0x0201, 0x00be, 0x00fa, 0x0201, 0x00af, 0x00dd,
          0x0e01, 0x0601, 0x0401, 0x0201, 0x00ec, 0x00ce, 0x00fb, 0x0401, 0x0201, 0x00bf, 0x00ed,
          0x0201, 0x00de, 0x00fc, 0x0601, 0x0401, 0x0201, 0x00cf, 0x00fd, 0x00ee, 0x0401, 0x0201,
          0x00df, 0x00fe, 0x0201, 0x00ef, 0x00ff,
          //},g_huffman_table_16[511] = {
          0x0201, 0x0000, 0x0601, 0x0201, 0x0010, 0x0201, 0x0001, 0x0011, 0x2a01, 0x0801, 0x0401,
          0x0201, 0x0020, 0x0002, 0x0201, 0x0021, 0x0012, 0x0a01, 0x0601, 0x0201, 0x0022, 0x0201,
          0x0030, 0x0003, 0x0201, 0x0031, 0x0013, 0x0a01, 0x0401, 0x0201, 0x0032, 0x0023, 0x0401,
          0x0201, 0x0040, 0x0004, 0x0041, 0x0601, 0x0201, 0x0014, 0x0201, 0x0033, 0x0042, 0x0401,
          0x0201, 0x0024, 0x0050, 0x0201, 0x0043, 0x0034, 0x8a01, 0x2801, 0x1001, 0x0601, 0x0401,
          0x0201, 0x0005, 0x0015, 0x0051, 0x0401, 0x0201, 0x0052, 0x0025, 0x0401, 0x0201, 0x0044,
          0x0035, 0x0053, 0x0a01, 0x0601, 0x0401, 0x0201, 0x0060, 0x0006, 0x0061, 0x0201, 0x0016,
          0x0062, 0x0801, 0x0401, 0x0201, 0x0026, 0x0054, 0x0201, 0x0045, 0x0063, 0x0401, 0x0201,
          0x0036, 0x0070, 0x0071, 0x2801, 0x1201, 0x0801, 0x0201, 0x0017, 0x0201, 0x0007, 0x0201,
          0x0055, 0x0064, 0x0401, 0x0201, 0x0072, 0x0027, 0x0401, 0x0201, 0x0046, 0x0065, 0x0073,
          0x0a01, 0x0601, 0x0201, 0x0037, 0x0201, 0x0056, 0x0008, 0x0201, 0x0080, 0x0081, 0x0601,
          0x0201, 0x0018, 0x0201, 0x0074, 0x0047, 0x0201, 0x0082, 0x0201, 0x0028, 0x0066, 0x1801,
          0x0e01, 0x0801, 0x0401, 0x0201, 0x0083, 0x0038, 0x0201, 0x0075, 0x0084, 0x0401, 0x0201,
          0x0048, 0x0090, 0x0091, 0x0601, 0x0201, 0x0019, 0x0201, 0x0009, 0x0076, 0x0201, 0x0092,
          0x0029, 0x0e01, 0x0801, 0x0401, 0x0201, 0x0085, 0x0058, 0x0201, 0x0093, 0x0039, 0x0401,
          0x0201, 0x00a0, 0x000a, 0x001a, 0x0801, 0x0201, 0x00a2, 0x0201, 0x0067, 0x0201, 0x0057,
          0x0049, 0x0601, 0x0201, 0x0094, 0x0201, 0x0077, 0x0086, 0x0201, 0x00a1, 0x0201, 0x0068,
          0x0095, 0xdc01, 0x7e01, 0x3201, 0x1a01, 0x0c01, 0x0601, 0x0201, 0x002a, 0x0201, 0x0059,
          0x003a, 0x0201, 0x00a3, 0x0201, 0x0087, 0x0078, 0x0801, 0x0401, 0x0201, 0x00a4, 0x004a,
          0x0201, 0x0096, 0x0069, 0x0401, 0x0201, 0x00b0, 0x000b, 0x00b1, 0x0a01, 0x0401, 0x0201,
          0x001b, 0x00b2, 0x0201, 0x002b, 0x0201, 0x00a5, 0x005a, 0x0601, 0x0201, 0x00b3, 0x0201,
          0x00a6, 0x006a, 0x0401, 0x0201, 0x00b4, 0x004b, 0x0201, 0x000c, 0x00c1, 0x1e01, 0x0e01,
          0x0601, 0x0401, 0x0201, 0x00b5, 0x00c2, 0x002c, 0x0401, 0x0201, 0x00a7, 0x00c3, 0x0201,
          0x006b, 0x00c4, 0x0801, 0x0201, 0x001d, 0x0401, 0x0201, 0x0088, 0x0097, 0x003b, 0x0401,
          0x0201, 0x00d1, 0x00d2, 0x0201, 0x002d, 0x00d3, 0x1201, 0x0601, 0x0401, 0x0201, 0x001e,
          0x002e, 0x00e2, 0x0601, 0x0401, 0x0201, 0x0079, 0x0098, 0x00c0, 0x0201, 0x001c, 0x0201,
          0x0089, 0x005b, 0x0e01, 0x0601, 0x0201, 0x003c, 0x0201, 0x007a, 0x00b6, 0x0401, 0x0201,
          0x004c, 0x0099, 0x0201, 0x00a8, 0x008a, 0x0601, 0x0201, 0x000d, 0x0201, 0x00c5, 0x005c,
          0x0401, 0x0201, 0x003d, 0x00c6, 0x0201, 0x006c, 0x009a, 0x5801, 0x5601, 0x2401, 0x1001,
          0x0801, 0x0401, 0x0201, 0x008b, 0x004d, 0x0201, 0x00c7, 0x007c, 0x0401, 0x0201, 0x00d5,
          0x005d, 0x0201, 0x00e0, 0x000e, 0x0801, 0x0201, 0x00e3, 0x0401, 0x0201, 0x00d0, 0x00b7,
          0x007b, 0x0601, 0x0401, 0x0201, 0x00a9, 0x00b8, 0x00d4, 0x0201, 0x00e1, 0x0201, 0x00aa,
          0x00b9, 0x1801, 0x0a01, 0x0601, 0x0401, 0x0201, 0x009b, 0x00d6, 0x006d, 0x0201, 0x003e,
          0x00c8, 0x0601, 0x0401, 0x0201, 0x008c, 0x00e4, 0x004e, 0x0401, 0x0201, 0x00d7, 0x00e5,
          0x0201, 0x00ba, 0x00ab, 0x0c01, 0x0401, 0x0201, 0x009c, 0x00e6, 0x0401, 0x0201, 0x006e,
          0x00d8, 0x0201, 0x008d, 0x00bb, 0x0801, 0x0401, 0x0201, 0x00e7, 0x009d, 0x0201, 0x00e8,
          0x008e, 0x0401, 0x0201, 0x00cb, 0x00bc, 0x009e, 0x00f1, 0x0201, 0x001f, 0x0201, 0x000f,
          0x002f, 0x4201, 0x3801, 0x0201, 0x00f2, 0x3401, 0x3201, 0x1401, 0x0801, 0x0201, 0x00bd,
          0x0201, 0x005e, 0x0201, 0x007d, 0x00c9, 0x0601, 0x0201, 0x00ca, 0x0201, 0x00ac, 0x007e,
          0x0401, 0x0201, 0x00da, 0x00ad, 0x00cc, 0x0a01, 0x0601, 0x0201, 0x00ae, 0x0201, 0x00db,
          0x00dc, 0x0201, 0x00cd, 0x00be, 0x0601, 0x0401, 0x0201, 0x00eb, 0x00ed, 0x00ee, 0x0601,
          0x0401, 0x0201, 0x00d9, 0x00ea, 0x00e9, 0x0201, 0x00de, 0x0401, 0x0201, 0x00dd, 0x00ec,
          0x00ce, 0x003f, 0x00f0, 0x0401, 0x0201, 0x00f3, 0x00f4, 0x0201, 0x004f, 0x0201, 0x00f5,
          0x005f, 0x0a01, 0x0201, 0x00ff, 0x0401, 0x0201, 0x00f6, 0x006f, 0x0201, 0x00f7, 0x007f,
          0x0c01, 0x0601, 0x0201, 0x008f, 0x0201, 0x00f8, 0x00f9, 0x0401, 0x0201, 0x009f, 0x00fa,
          0x00af, 0x0801, 0x0401, 0x0201, 0x00fb, 0x00bf, 0x0201, 0x00fc, 0x00cf, 0x0401, 0x0201,
          0x00fd, 0x00df, 0x0201, 0x00fe, 0x00ef,
          //},g_huffman_table_24[512] = {
          0x3c01, 0x0801, 0x0401, 0x0201, 0x0000, 0x0010, 0x0201, 0x0001, 0x0011, 0x0e01, 0x0601,
          0x0401, 0x0201, 0x0020, 0x0002, 0x0021, 0x0201, 0x0012, 0x0201, 0x0022, 0x0201, 0x0030,
          0x0003, 0x0e01, 0x0401, 0x0201, 0x0031, 0x0013, 0x0401, 0x0201, 0x0032, 0x0023, 0x0401,
          0x0201, 0x0040, 0x0004, 0x0041, 0x0801, 0x0401, 0x0201, 0x0014, 0x0033, 0x0201, 0x0042,
          0x0024, 0x0601, 0x0401, 0x0201, 0x0043, 0x0034, 0x0051, 0x0601, 0x0401, 0x0201, 0x0050,
          0x0005, 0x0015, 0x0201, 0x0052, 0x0025, 0xfa01, 0x6201, 0x2201, 0x1201, 0x0a01, 0x0401,
          0x0201, 0x0044, 0x0053, 0x0201, 0x0035, 0x0201, 0x0060, 0x0006, 0x0401, 0x0201, 0x0061,
          0x0016, 0x0201, 0x0062, 0x0026, 0x0801, 0x0401, 0x0201, 0x0054, 0x0045, 0x0201, 0x0063,
          0x0036, 0x0401, 0x0201, 0x0071, 0x0055, 0x0201, 0x0064, 0x0046, 0x2001, 0x0e01, 0x0601,
          0x0201, 0x0072, 0x0201, 0x0027, 0x0037, 0x0201, 0x0073, 0x0401, 0x0201, 0x0070, 0x0007,
          0x0017, 0x0a01, 0x0401, 0x0201, 0x0065, 0x0056, 0x0401, 0x0201, 0x0080, 0x0008, 0x0081,
          0x0401, 0x0201, 0x0074, 0x0047, 0x0201, 0x0018, 0x0082, 0x1001, 0x0801, 0x0401, 0x0201,
          0x0028, 0x0066, 0x0201, 0x0083, 0x0038, 0x0401, 0x0201, 0x0075, 0x0057, 0x0201, 0x0084,
          0x0048, 0x0801, 0x0401, 0x0201, 0x0091, 0x0019, 0x0201, 0x0092, 0x0076, 0x0401, 0x0201,
          0x0067, 0x0029, 0x0201, 0x0085, 0x0058, 0x5c01, 0x2201, 0x1001, 0x0801, 0x0401, 0x0201,
          0x0093, 0x0039, 0x0201, 0x0094, 0x0049, 0x0401, 0x0201, 0x0077, 0x0086, 0x0201, 0x0068,
          0x00a1, 0x0801, 0x0401, 0x0201, 0x00a2, 0x002a, 0x0201, 0x0095, 0x0059, 0x0401, 0x0201,
          0x00a3, 0x003a, 0x0201, 0x0087, 0x0201, 0x0078, 0x004a, 0x1601, 0x0c01, 0x0401, 0x0201,
          0x00a4, 0x0096, 0x0401, 0x0201, 0x0069, 0x00b1, 0x0201, 0x001b, 0x00a5, 0x0601, 0x0201,
          0x00b2, 0x0201, 0x005a, 0x002b, 0x0201, 0x0088, 0x00b3, 0x1001, 0x0a01, 0x0601, 0x0201,
          0x0090, 0x0201, 0x0009, 0x00a0, 0x0201, 0x0097, 0x0079, 0x0401, 0x0201, 0x00a6, 0x006a,
          0x00b4, 0x0c01, 0x0601, 0x0201, 0x001a, 0x0201, 0x000a, 0x00b0, 0x0201, 0x003b, 0x0201,
          0x000b, 0x00c0, 0x0401, 0x0201, 0x004b, 0x00c1, 0x0201, 0x0098, 0x0089, 0x4301, 0x2201,
          0x1001, 0x0801, 0x0401, 0x0201, 0x001c, 0x00b5, 0x0201, 0x005b, 0x00c2, 0x0401, 0x0201,
          0x002c, 0x00a7, 0x0201, 0x007a, 0x00c3, 0x0a01, 0x0601, 0x0201, 0x003c, 0x0201, 0x000c,
          0x00d0, 0x0201, 0x00b6, 0x006b, 0x0401, 0x0201, 0x00c4, 0x004c, 0x0201, 0x0099, 0x00a8,
          0x1001, 0x0801, 0x0401, 0x0201, 0x008a, 0x00c5, 0x0201, 0x005c, 0x00d1, 0x0401, 0x0201,
          0x00b7, 0x007b, 0x0201, 0x001d, 0x00d2, 0x0901, 0x0401, 0x0201, 0x002d, 0x00d3, 0x0201,
          0x003d, 0x00c6, 0x55fa, 0x0401, 0x0201, 0x006c, 0x00a9, 0x0201, 0x009a, 0x00d4, 0x2001,
          0x1001, 0x0801, 0x0401, 0x0201, 0x00b8, 0x008b, 0x0201, 0x004d, 0x00c7, 0x0401, 0x0201,
          0x007c, 0x00d5, 0x0201, 0x005d, 0x00e1, 0x0801, 0x0401, 0x0201, 0x001e, 0x00e2, 0x0201,
          0x00aa, 0x00b9, 0x0401, 0x0201, 0x009b, 0x00e3, 0x0201, 0x00d6, 0x006d, 0x1401, 0x0a01,
          0x0601, 0x0201, 0x003e, 0x0201, 0x002e, 0x004e, 0x0201, 0x00c8, 0x008c, 0x0401, 0x0201,
          0x00e4, 0x00d7, 0x0401, 0x0201, 0x007d, 0x00ab, 0x00e5, 0x0a01, 0x0401, 0x0201, 0x00ba,
          0x005e, 0x0201, 0x00c9, 0x0201, 0x009c, 0x006e, 0x0801, 0x0201, 0x00e6, 0x0201, 0x000d,
          0x0201, 0x00e0, 0x000e, 0x0401, 0x0201, 0x00d8, 0x008d, 0x0201, 0x00bb, 0x00ca, 0x4a01,
          0x0201, 0x00ff, 0x4001, 0x3a01, 0x2001, 0x1001, 0x0801, 0x0401, 0x0201, 0x00ac, 0x00e7,
          0x0201, 0x007e, 0x00d9, 0x0401, 0x0201, 0x009d, 0x00e8, 0x0201, 0x008e, 0x00cb, 0x0801,
          0x0401, 0x0201, 0x00bc, 0x00da, 0x0201, 0x00ad, 0x00e9, 0x0401, 0x0201, 0x009e, 0x00cc,
          0x0201, 0x00db, 0x00bd, 0x1001, 0x0801, 0x0401, 0x0201, 0x00ea, 0x00ae, 0x0201, 0x00dc,
          0x00cd, 0x0401, 0x0201, 0x00eb, 0x00be, 0x0201, 0x00dd, 0x00ec, 0x0801, 0x0401, 0x0201,
          0x00ce, 0x00ed, 0x0201, 0x00de, 0x00ee, 0x000f, 0x0401, 0x0201, 0x00f0, 0x001f, 0x00f1,
          0x0401, 0x0201, 0x00f2, 0x002f, 0x0201, 0x00f3, 0x003f, 0x1201, 0x0801, 0x0401, 0x0201,
          0x00f4, 0x004f, 0x0201, 0x00f5, 0x005f, 0x0401, 0x0201, 0x00f6, 0x006f, 0x0201, 0x00f7,
          0x0201, 0x007f, 0x008f, 0x0a01, 0x0401, 0x0201, 0x00f8, 0x00f9, 0x0401, 0x0201, 0x009f,
          0x00af, 0x00fa, 0x0801, 0x0401, 0x0201, 0x00fb, 0x00bf, 0x0201, 0x00fc, 0x00cf, 0x0401,
          0x0201, 0x00fd, 0x00df, 0x0201, 0x00fe, 0x00ef,
          //},g_huffman_table_32[31] = {
          0x0201, 0x0000, 0x0801, 0x0401, 0x0201, 0x0008, 0x0004, 0x0201, 0x0001, 0x0002, 0x0801,
          0x0401, 0x0201, 0x000c, 0x000a, 0x0201, 0x0003, 0x0006, 0x0601, 0x0201, 0x0009, 0x0201,
          0x0005, 0x0007, 0x0401, 0x0201, 0x000e, 0x000d, 0x0201, 0x000f, 0x000b,
          //},g_huffman_table_33[31] = {
          0x1001, 0x0801, 0x0401, 0x0201, 0x0000, 0x0001, 0x0201, 0x0002, 0x0003, 0x0401, 0x0201,
          0x0004, 0x0005, 0x0201, 0x0006, 0x0007, 0x0801, 0x0401, 0x0201, 0x0008, 0x0009, 0x0201,
          0x000a, 0x000b, 0x0401, 0x0201, 0x000c, 0x000d, 0x0201, 0x000e, 0x000f,
  };
  private static final int[] HUFFMAN_TABLE_OFFSET_LAYER_III = {
          Short.MIN_VALUE, 0, 7, 24, Short.MIN_VALUE, 41, 72, 103, 174, 245, 316, 443, 570, 697, Short.MIN_VALUE, 1208, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2230, 2230, 2230, 2230, 2230, 2230, 2230, 2230, 2742, 2261
  };
  private static final int[] HUFFMAN_TREELEN_LAYER_III = {
          0, 7, 17, 17, 0, 31, 31, 71, 71, 71, 127, 127, 127, 511, 0, 511, 511, 511, 511, 511, 511, 511, 511, 511, 512, 512, 512, 512, 512, 512, 512, 512, 31, 31
  };
  private static final int[] HUFFMAN_LINBITS_LAYER_III = {
          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 6, 8, 10, 13, 4, 5, 6, 7, 8, 9, 11, 13, 0, 0
  };
  private static final float[] REQUANTIZE_LONG_PRETAB_LAYER_III = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
          1, 1, 1, 1, 2, 2, 3, 3, 3, 2};
  private static final float[] COS_12_LAYER_III;
  private static final float[] COS_36_LAYER_III;
  
  static {
    PRE_FRACTOR_LAYER_I = new float[16];
    for (int i = 0; i < 16; i++) {
      double pow = 0b1 << i;
      PRE_FRACTOR_LAYER_I[i] = (float) (pow / (pow - 1));
    }
    NIK_COEFFICIENTS = new float[64 * 32];
    for (int i = 0; i < 64; i++) {
      for (int k = 0; k < 32; k++) {
        double value = 1e9 * Math.cos((16 + i) * (2 * k + 1) * Math.PI / 64);
        if (value >= 0) {
          value = (int) (value + 0.5);
        } else {
          value = (int) (value - 0.5);
        }
        NIK_COEFFICIENTS[i * 32 + k] = (float) (value * 1e-9);
      }
    }
    POWTAB_LAYER_III = new float[8207];
    for (int i = 0; i < 8207; i++) {
      POWTAB_LAYER_III[i] = (float) Math.pow(i, 4.0 / 3.0);
    }
    IS_RATIOS_LAYER_III = new float[6];
    for (int i = 0; i < 6; i++) {
      IS_RATIOS_LAYER_III[i] = (float) Math.tan((i * Math.PI) / 12.0);
    }
    IMDCT_WINDOW_LAYER_III = new float[4 * 36];
    {
          /* Blocktype 0 */
      for (int i = 0; i < 36; i++) {
        IMDCT_WINDOW_LAYER_III[0 * 36 + i] = (float) Math.sin(Math.PI / 36 * (i + 0.5));
      }
    /* Blocktype 1 */
      for (int i = 0; i < 18; i++) {
        IMDCT_WINDOW_LAYER_III[1 * 36 + i] = (float) Math.sin(Math.PI / 36 * (i + 0.5));
      }
      for (int i = 18; i < 24; i++) {
        IMDCT_WINDOW_LAYER_III[1 * 36 + i] = 1.0f;
      }
      for (int i = 24; i < 30; i++) {
        IMDCT_WINDOW_LAYER_III[1 * 36 + i] = (float) Math.sin(Math.PI / 12 * (i + 0.5 - 18.0));
      }
    /* Blocktype 2 */
      for (int i = 0; i < 12; i++) {
        IMDCT_WINDOW_LAYER_III[2 * 36 + i] = (float) Math.sin(Math.PI / 12 * (i + 0.5));
      }
    /* Blocktype 3 */
      for (int i = 6; i < 12; i++) {
        IMDCT_WINDOW_LAYER_III[3 * 36 + i] = (float) Math.sin(Math.PI / 12 * (i + 0.5 - 6.0));
      }
      for (int i = 12; i < 18; i++) {
        IMDCT_WINDOW_LAYER_III[3 * 36 + i] = 1.0f;
      }
      for (int i = 18; i < 36; i++) {
        IMDCT_WINDOW_LAYER_III[3 * 36 + i] = (float) Math.sin(Math.PI / 36 * (i + 0.5));
      }
    }
    SYNTH_WINDOW_TABLE_LAYER_III = new float[64 * 32];
    for (int i = 0; i < 64; i++) {
      for (int j = 0; j < 32; j++) {
        SYNTH_WINDOW_TABLE_LAYER_III[i * 32 + j] = (float) Math.cos((16 + i) * (2 * j + 1) * Math.PI / 64.0);
      }
    }
    COS_12_LAYER_III = new float[6 * 12];
    for (int i = 0; i < 6; i++) {
      for (int j = 0; j < 12; j++) {
        COS_12_LAYER_III[i * 12 + j] = (float) Math.cos(Math.PI / (2 * 12) * (2.0*j + 1 + 12/2) * (2.0*i + 1));
      }
    }
    COS_36_LAYER_III = new float[18*36];
    for (int i = 0; i < 18; i++) {
      for (int j = 0; j < 36; j++) {
        COS_36_LAYER_III[i * 36 + j] = (float) Math.cos(Math.PI / (2 * 36) * (2.0*j + 1 + 36/2) * (2.0*i + 1));
      }
    }
  }
  
  private Decoder() {
    throw new IllegalStateException("This class cannot be instantiated!");
  }
  
  public static SoundData init(InputStream in) throws IOException {
    SoundData soundData = new SoundData();
    soundData.buffer = new Buffer(in);
    soundData.buffer.lastByte = soundData.buffer.in.read();
    if(!decodeFrame(soundData))
      return null;
    return soundData;
  }
  
  public static boolean decodeFrame(SoundData soundData) throws IOException {
      if (soundData.buffer.lastByte == -1) {
        return false;
      }
      
      while (true) {
        int read;
        do {
          read = soundData.buffer.lastByte;
          soundData.buffer.lastByte = soundData.buffer.in.read();
          if (soundData.buffer.lastByte == -1) {
            return false;
          }
        } while (read != 0b11111111);
        if ((soundData.buffer.lastByte >>> 4) != 0b1111) {
          soundData.buffer.lastByte = soundData.buffer.in.read();
          if (soundData.buffer.lastByte == -1) {
            return false;
          }
        } else {
          break;
        }
      }
  
    soundData.buffer.current = 4;
      
      int id = read(soundData.buffer, 1);
      int layer = read(soundData.buffer, 2);
      int protectionBit = read(soundData.buffer, 1);
      int bitrateIndex = read(soundData.buffer, 4);
      int samplingFrequency = read(soundData.buffer, 2);
      int paddingBit = read(soundData.buffer, 1);
      int privateBit = read(soundData.buffer, 1);
      int mode = read(soundData.buffer, 2);
      int modeExtension = read(soundData.buffer, 2);
      read(soundData.buffer, 4);
      
      if (soundData.frequency == -1) {
        soundData.frequency = SAMPLING_FREQUENCY[samplingFrequency];
      }
      
      if (soundData.stereo == -1) {
        if (mode == 0b11 /* single_channel */) {
          soundData.stereo = 0;
        } else {
          soundData.stereo = 1;
        }
        if (layer == 0b01 /* layer III */) {
          if (mode == 0b11 /* single_channel */) {
            soundData.mainData = new byte[1024];
            soundData.store = new float[32 * 18];
            soundData.v = new float[1024];
          } else {
            soundData.mainData = new byte[2 * 1024];
            soundData.store = new float[2 * 32 * 18];
            soundData.v = new float[2 * 1024];
          }
          soundData.mainDataReader = new MainDataReader(soundData.mainData);
        } else {
          if (mode == 0b11 /* single_channel */) {
            soundData.synthOffset = new int[]{64};
            soundData.synthBuffer = new float[1024];
          } else {
            soundData.synthOffset = new int[]{64, 64};
            soundData.synthBuffer = new float[2 * 1024];
          }
        }
      }
      
      int bound = modeExtension == 0b0 ? 4 : modeExtension == 0b01 ? 8 : modeExtension == 0b10 ? 12 : modeExtension == 0b11 ? 16 : -1;
      
      if (protectionBit == 0) {
        // TODO CRC CHECK
        read(soundData.buffer, 16);
      }
      
      if (layer == 0b11 /* layer I */) {
        float[] sampleDecoded = null;
        if (mode == 0b11 /* single_channel */) {
          sampleDecoded = samples_I(soundData.buffer, 1, -1);
        } else if (mode == 0b0 /* stereo */ || mode == 0b10 /* dual_channel */) {
          sampleDecoded = samples_I(soundData.buffer, 2, -1);
        } else if (mode == 0b01 /* intensity_stereo */) {
          sampleDecoded = samples_I(soundData.buffer, 2, bound);
        }
        if (mode == 0b11 /* single_channel */) {
          synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 1);
        } else {
          synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 2);
        }
      } else if (layer == 0b10 /* layer II */) {
        float[] sampleDecoded = null;
        int bitrate = BITRATE_LAYER_II[bitrateIndex];
        if (mode == 0b11 /* single_channel */) {
          sampleDecoded = samples_II(soundData.buffer, 1, -1, bitrate, soundData.frequency);
        } else if (mode == 0b0 /* stereo */ || mode == 0b10 /* dual_channel */) {
          sampleDecoded = samples_II(soundData.buffer, 2, -1, bitrate, soundData.frequency);
        } else if (mode == 0b01 /* intensity_stereo */) {
          sampleDecoded = samples_II(soundData.buffer, 2, bound, bitrate, soundData.frequency);
        }
        if (mode == 0b11 /* single_channel */) {
          synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 1);
        } else {
          synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 2);
        }
      } else if (layer == 0b01 /* layer III */) {
        int frameSize = (144 * BITRATE_LAYER_III[bitrateIndex]) / SAMPLING_FREQUENCY[samplingFrequency] + paddingBit;
        if (frameSize > 2000) {
          System.err.println("Frame too large! " + frameSize);
        }
        samples_III(soundData.buffer, soundData.stereo == 1 ? 2 : 1, soundData.mainDataReader, frameSize, samplingFrequency, mode, modeExtension, soundData.store, soundData.v, soundData);
      }
      
      if (soundData.buffer.current != 0) {
        read(soundData.buffer, 8 - soundData.buffer.current);
      }
      
      return true;
  }
  
  private static void samples_III(Buffer buffer, int stereo, MainDataReader mainDataReader, int frameSize, int samplingFrequency, int mode, int modeExtension, float[] store, float[] v, SoundData soundData) throws IOException {
    int[] scfsi = new int[stereo * 4];
    int[] part2_3_length = new int[stereo * 2];
    int[] big_values = new int[stereo * 2];
    int[] global_gain = new int[stereo * 2];
    int[] scalefac_compress = new int[stereo * 2];
    int[] win_switch_flag = new int[stereo * 2];
    int[] block_type = new int[stereo * 2];
    int[] mixed_block_flag = new int[stereo * 2];
    int[] table_select = new int[stereo * 2 * 3];
    int[] subblock_gain = new int[stereo * 2 * 3];
    int[] region0_count = new int[stereo * 2];
    int[] region1_count = new int[stereo * 2];
    int[] preflag = new int[stereo * 2];
    int[] scalefac_scale = new int[stereo * 2];
    int[] count1table_select = new int[stereo * 2];
    int[] count1 = new int[stereo * 2];
    int[] scalefac_l = new int[stereo * 2 * 21];
    int[] scalefac_s = new int[stereo * 2 * 12 * 3];
    float[] is = new float[stereo * 2 * 576];
    int mainDataBegin = read(buffer, 9);
    read(buffer, stereo == 1 ? 5 : 3);
    
    for (int ch = 0; ch < stereo; ch++) {
      for (int scaleband = 0; scaleband < 4; scaleband++) {
        scfsi[ch * 4 + scaleband] = read(buffer, 1);
      }
    }
    for (int gr = 0; gr < 2; gr++) {
      for (int ch = 0; ch < stereo; ch++) {
        part2_3_length[ch * 2 + gr] = read(buffer, 12);
        big_values[ch * 2 + gr] = read(buffer, 9);
        global_gain[ch * 2 + gr] = read(buffer, 8);
        scalefac_compress[ch * 2 + gr] = read(buffer, 4);
        
        win_switch_flag[ch * 2 + gr] = read(buffer, 1);
        
        if (win_switch_flag[ch * 2 + gr] == 1) {
          block_type[ch * 2 + gr] = read(buffer, 2);
          mixed_block_flag[ch * 2 + gr] = read(buffer, 1);
          for (int region = 0; region < 2; region++) {
            table_select[ch * 2 * 3 + gr * 3 + region] = read(buffer, 5);
          }
          for (int window = 0; window < 3; window++) {
            subblock_gain[ch * 2 * 3 + gr * 3 + window] = read(buffer, 3);
          }
          if ((block_type[ch * 2 + gr] == 2) &&
                  (mixed_block_flag[ch * 2 + gr] == 0)) {
            region0_count[ch * 2 + gr] = 8;
          } else {
            region0_count[ch * 2 + gr] = 7;
          }
          
          region1_count[ch * 2 + gr] =
                  20 - region0_count[ch * 2 + gr];
        } else {
          for (int region = 0; region < 3; region++) {
            table_select[ch * 2 * 3 + gr * 3 + region] = read(buffer, 5);
          }
          region0_count[ch * 2 + gr] = read(buffer, 4);
          region1_count[ch * 2 + gr] = read(buffer, 3);
          block_type[ch * 2 + gr] = 0;
        }
        preflag[ch * 2 + gr] = read(buffer, 1);
        scalefac_scale[ch * 2 + gr] = read(buffer, 1);
        count1table_select[ch * 2 + gr] = read(buffer, 1);
      }
    }
    
    System.arraycopy(mainDataReader.array, mainDataReader.top - mainDataBegin, mainDataReader.array, 0, mainDataBegin);
    
    int mainDataSize = frameSize - (stereo == 2 ? 32 : 17) - 4;
    readInto(buffer, mainDataReader.array, mainDataBegin, mainDataSize);
    mainDataReader.index = 0;
    mainDataReader.current = 0;
    mainDataReader.top = mainDataBegin + mainDataSize;
    
    for (int gr = 0; gr < 2; gr++) {
      for (int ch = 0; ch < stereo; ch++) {
        
        int part_2_start = mainDataReader.index * 8 + mainDataReader.current;
      
      /* Number of bits in the bitstream for the bands */
        int slen1 = SCALEFACTOR_SIZES_LAYER_III[scalefac_compress[ch * 2 + gr] * 2];
        int slen2 = SCALEFACTOR_SIZES_LAYER_III[scalefac_compress[ch * 2 + gr] * 2 + 1];
        
        if ((win_switch_flag[ch * 2 + gr] != 0) &&
                (block_type[ch * 2 + gr] == 2)) {
          if (mixed_block_flag[ch * 2 + gr] != 0) {
            for (int sfb = 0; sfb < 8; sfb++) {
              scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = read(mainDataReader, slen1);
            }
            for (int sfb = 3; sfb < 12; sfb++) {
              int nbits;
              if (sfb < 6) {	/* slen1 is for bands 3-5, slen2 for 6-11 */
                nbits = slen1;
              } else {
                nbits = slen2;
              }
              
              for (int win = 0; win < 3; win++) {
                scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win] =
                        read(mainDataReader, nbits);
              }
            }
          } else {
            for (int sfb = 0; sfb < 12; sfb++) {
              int nbits;
              if (sfb < 6) {	/* slen1 is for bands 3-5, slen2 for 6-11 */
                nbits = slen1;
              } else {
                nbits = slen2;
              }
              
              for (int win = 0; win < 3; win++) {
                scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win] =
                        read(mainDataReader, nbits);
              }
            }
          }
        } else { /* block_type == 0 if winswitch == 0 */

	/* Scale factor bands 0-5 */
          if ((scfsi[ch * 4 + 0] == 0) || (gr == 0)) {
            for (int sfb = 0; sfb < 6; sfb++) {
              scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = read(mainDataReader, slen1);
            }
          } else if ((scfsi[ch * 4 + 0] == 1) && (gr == 1)) {
    /* Copy scalefactors from granule 0 to granule 1 */
            for (int sfb = 0; sfb < 6; sfb++) {
              scalefac_l[ch * 2 * 21 + 1 * 21 + sfb] =
                      scalefac_l[ch * 2 * 21 + 0 * 21 + sfb];
            }
          }

	/* Scale factor bands 6-10 */
          if ((scfsi[ch * 4 + 1] == 0) || (gr == 0)) {
            for (int sfb = 6; sfb < 11; sfb++) {
              scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = read(mainDataReader, slen1);
            }
          } else if ((scfsi[ch * 4 + 1] == 1) && (gr == 1)) {
    /* Copy scalefactors from granule 0 to granule 1 */
            for (int sfb = 6; sfb < 11; sfb++) {
              scalefac_l[ch * 2 * 21 + 1 * 21 + sfb] =
                      scalefac_l[ch * 2 * 21 + 0 * 21 + sfb];
            }
          }

	/* Scale factor bands 11-15 */
          if ((scfsi[ch * 4 + 2] == 0) || (gr == 0)) {
            for (int sfb = 11; sfb < 16; sfb++) {
              scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = read(mainDataReader, slen2);
            }
          } else if ((scfsi[ch * 4 + 2] == 1) && (gr == 1)) {
    /* Copy scalefactors from granule 0 to granule 1 */
            for (int sfb = 11; sfb < 16; sfb++) {
              scalefac_l[ch * 2 * 21 + 1 * 21 + sfb] =
                      scalefac_l[ch * 2 * 21 + 0 * 21 + sfb];
            }
          }

	/* Scale factor bands 16-20 */
          if ((scfsi[ch * 4 + 3] == 0) || (gr == 0)) {
            for (int sfb = 16; sfb < 21; sfb++) {
              scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = read(mainDataReader, slen2);
            }
          } else if ((scfsi[ch * 4 + 3] == 1) && (gr == 1)) {
    /* Copy scalefactors from granule 0 to granule 1 */
            for (int sfb = 16; sfb < 21; sfb++) {
              scalefac_l[ch * 2 * 21 + 1 * 21 + sfb] =
                      scalefac_l[ch * 2 * 21 + 0 * 21 + sfb];
            }
          }
        }

        /* Check that there is any data to decode. If not, zero the array. */
        if (part2_3_length[ch * 2 + gr] != 0) {
        
  
  /* Calculate bit_pos_end which is the index of the last bit for this part. */
          int bit_pos_end = part_2_start + part2_3_length[ch * 2 + gr] - 1;
          
          int region_1_start;
          int region_2_start;
          int table_num;
          int is_pos;
          
          int[] huffman = new int[4];
          
  /* Determine region boundaries */
          if ((win_switch_flag[ch * 2 + gr] == 1) &&
                  (block_type[ch * 2 + gr] == 2)) {
            
            region_1_start = 36;  /* sfb[9/3]*3=36 */
            region_2_start = 576; /* No Region2 for short block case. */
          } else {
            region_1_start =
                    SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + region0_count[ch * 2 + gr] + 1];
            region_2_start =
                    SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + region0_count[ch * 2 + gr] + region1_count[ch * 2 + gr] + 2];
          }

  /* Read big_values using tables according to region_x_start */
          for (is_pos = 0; is_pos < big_values[ch * 2 + gr] * 2; is_pos++) {
            
            if (is_pos < region_1_start) {
              table_num = table_select[ch * 2 * 3 + gr * 3 + 0];
            } else if (is_pos < region_2_start) {
              table_num = table_select[ch * 2 * 3 + gr * 3 + 1];
            } else {
              table_num = table_select[ch * 2 * 3 + gr * 3 + 2];
            }
    
    /* Get next Huffman coded words */
            huffman_III(mainDataReader, table_num, huffman);

    /* In the big_values area there are two freq lines per Huffman word */
            is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[0];
            is[ch * 2 * 576 + gr * 576 + is_pos] = huffman[1];
          }

  /* Read small values until is_pos = 576 or we run out of huffman data */
          table_num = count1table_select[ch * 2 + gr] + 32;
          for (is_pos = big_values[ch * 2 + gr] * 2;
               (is_pos <= 572) && (mainDataReader.index * 8 + mainDataReader.current <= bit_pos_end); is_pos++) {

    /* Get next Huffman coded words */
            huffman_III(mainDataReader, table_num, huffman);
            
            is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[2];
            if (is_pos >= 576) {
              break;
            }
            
            is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[3];
            if (is_pos >= 576) {
              break;
            }
            
            is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[0];
            if (is_pos >= 576) {
              break;
            }
            
            is[ch * 2 * 576 + gr * 576 + is_pos] = huffman[1];
          }

  /* Check that we didn't read past the end of this section */
          if (mainDataReader.index * 8 + mainDataReader.current > (bit_pos_end + 1)) {
    /* Remove last words read */
            is_pos -= 4;
          }

  /* Setup count1 which is the index of the first sample in the rzero reg. */
          count1[ch * 2 + gr] = is_pos;
        
            /* Zero out the last part if necessary */
          for (/* is_pos comes from last for-loop */; is_pos < 576; is_pos++) {
            is[ch * 2 * 576 + gr * 576 + is_pos] = 0.0f;
          }

  /* Set the bitpos to point to the next part to read */
          mainDataReader.index = (bit_pos_end + 1) / 8;
          mainDataReader.current = (bit_pos_end + 1) % 8;
        }
      } /* end for (gr... */
    }
  
    if(soundData.samplesBuffer == null)
      soundData.samplesBuffer = new byte[18 * 32 * 2 * stereo * 2];
    
    for (int gr = 0; gr < 2; gr++) {
      for (int ch = 0; ch < stereo; ch++) {
        
        // requantize ===================================================

  /* Determine type of block to process */
        if ((win_switch_flag[ch * 2 + gr] == 1) &&
                (block_type[ch * 2 + gr] == 2)) { /* Short blocks */

    /* Check if the first two subbands
     * (=2*18 samples = 8 long or 3 short sfb's) uses long blocks */
          if (mixed_block_flag[ch * 2 + gr] != 0) { /* 2 longbl. sb  first */

      /*
       * First process the 2 long block subbands at the start
       */
            int sfb = 0;
            int next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb + 1];
            for (int i = 0; i < 36; i++) {
              if (i == next_sfb) {
                sfb++;
                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb + 1];
              } /* end if */
              requantize_long_III(gr, ch, scalefac_scale, preflag, global_gain, scalefac_l, is, i, sfb);
            }

      /*
       * And next the remaining, non-zero, bands which uses short blocks
       */
            sfb = 3;
            next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
            int win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                    SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
            
            for (int i = 36; i < count1[ch * 2 + gr]; /* i++ done below! */) {

	/* Check if we're into the next scalefac band */
              if (i == next_sfb) {	/* Yes */
                sfb++;
                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
                win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                        SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
              } /* end if (next_sfb) */
              
              for (int win = 0; win < 3; win++) {
                for (int j = 0; j < win_len; j++) {
                  requantize_short_III(gr, ch, scalefac_scale, subblock_gain, global_gain, scalefac_s, is, i, sfb, win);
                  i++;
                } /* end for (win... */
              } /* end for (j... */
            }	/* end for (i... */
          } else {			/* Only short blocks */
            
            int sfb = 0;
            int next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
            int win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                    SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
            
            for (int i = 0; i < count1[ch * 2 + gr]; /* i++ done below! */) {

	/* Check if we're into the next scalefac band */
              if (i == next_sfb) {	/* Yes */
                sfb++;
                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
                win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                        SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
              } /* end if (next_sfb) */
              
              for (int win = 0; win < 3; win++) {
                for (int j = 0; j < win_len; j++) {
                  requantize_short_III(gr, ch, scalefac_scale, subblock_gain, global_gain, scalefac_s, is, i, sfb, win);
                  i++;
                } /* end for (win... */
              } /* end for (j... */
            }	/* end for (i... */
          } /* end else (only short blocks) */
        } else {			/* Only long blocks */
          
          int sfb = 0;
          int next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb + 1];
          for (int i = 0; i < count1[ch * 2 + gr]; i++) {
            if (i == next_sfb) {
              sfb++;
              next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb + 1];
            } /* end if */
            requantize_long_III(gr, ch, scalefac_scale, preflag, global_gain, scalefac_l, is, i, sfb);
          }
        } /* end else (only long blocks) */
        
        
        // reorder ================================================
        
        
        outer:
        while (true) {
        

  /* Only reorder short blocks */
          if ((win_switch_flag[ch * 2 + gr] == 1) &&
                  (block_type[ch * 2 + gr] == 2)) { /* Short blocks */
            
            float[] re = new float[576];
            
            int i = 0;
            int sfb = 0;
            int next_sfb;
            int win_len;
    
    /* Check if the first two subbands
     * (=2*18 samples = 8 long or 3 short sfb's) uses long blocks */
            if (mixed_block_flag[ch * 2 + gr] != 0) { /* 2 longbl. sb  first */
              sfb = 3;
              i = 36;
            }
            next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
            win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                    SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
            
            for (; i < 576; /* i++ done below! */) {
      
      /* Check if we're into the next scalefac band */
              if (i == next_sfb) {	/* Yes */
        
        /* Copy reordered data back to the original vector */
                for (int j = 0; j < 3 * win_len; j++) {
                  is[ch * 2 * 576 + gr * 576 + 3 * (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb]) + j] =
                          re[j];
                }

        /* Check if this band is above the rzero region, if so we're done */
                if (i >= count1[ch * 2 + gr]) {
          /* Done */
                  break outer;
                }
                
                sfb++;
                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] * 3;
                win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] -
                        SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
              } /* end if (next_sfb) */

      /* Do the actual reordering */
              for (int win = 0; win < 3; win++) {
                for (int j = 0; j < win_len; j++) {
                  re[j * 3 + win] = is[ch * 2 * 576 + gr * 576 + i];
                  i++;
                } /* end for (j... */
              } /* end for (win... */
            }	/* end for (i... */

    /* Copy reordered data of the last band back to the original vector */
            for (int j = 0; j < 3 * win_len; j++) {
              is[ch * 2 * 576 + gr * 576 + 3 * (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + 12]) + j] = re[j];
            }
          }
          break;
        }
      }
      // stereo ==============================================
      
        /* Do nothing if joint stereo is not enabled */
      if ((mode == 1) && (modeExtension != 0)) {

  /* Do Middle/Side ("normal") stereo processing */
        if ((modeExtension & 0x2) != 0) {
          
          int max_pos;
    /* Determine how many frequency lines to transform */
          if (count1[0 * 2 + gr] > count1[1 * 2 + gr]) {
            max_pos = count1[0 * 2 + gr];
          } else {
            max_pos = count1[1 * 2 + gr];
          }

    /* Do the actual processing */
          for (int i = 0; i < max_pos; i++) {
            float left = (is[0 * 2 * 576 + gr * 576 + i] + is[1 * 2 * 576 + gr * 576 + i])
                    * (INV_SQUARE_2);
            float right = (is[0 * 2 * 576 + gr * 576 + i] - is[1 * 2 * 576 + gr * 576 + i])
                    * (INV_SQUARE_2);
            is[0 * 2 * 576 + gr * 576 + i] = left;
            is[1 * 2 * 576 + gr * 576 + i] = right;
          } /* end for (i... */
        } /* end if (ms_stereo... */

  /* Do intensity stereo processing */
        if ((modeExtension & 0x1) != 0) {

    /* The first band that is intensity stereo encoded is the first band
     * scale factor band on or above the count1 frequency line.
     * N.B.: Intensity stereo coding is only done for the higher subbands,
     * but the logic is still included to process lower subbands.
     */

    /* Determine type of block to process */
          if ((win_switch_flag[0 * 2 + gr] == 1) &&
                  (block_type[0 * 2 + gr] == 2)) { /* Short blocks */

      /* Check if the first two subbands
       * (=2*18 samples = 8 long or 3 short sfb's) uses long blocks */
            if (mixed_block_flag[0 * 2 + gr] != 0) { /* 2 longbl. sb  first */

        /*
         * First process the 8 sfb's at the start
         */
              for (int sfb = 0; sfb < 8; sfb++) {
          
          /* Is this scale factor band above count1 for the right channel? */
                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb] >= count1[1 * 2 + gr]) {
                  stereo_long_III(is, scalefac_l, gr, sfb, samplingFrequency);
                }
              } /* end if (sfb... */
        
        /*
         * And next the remaining bands which uses short blocks
         */
              for (int sfb = 3; sfb < 12; sfb++) {
          
          /* Is this scale factor band above count1 for the right channel? */
                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb] * 3 >= count1[1 * 2 + gr]) {
            
            /* Perform the intensity stereo processing */
                  stereo_short_III(is, scalefac_s, gr, sfb, samplingFrequency);
                }
              }
            } else {			/* Only short blocks */
              
              for (int sfb = 0; sfb < 12; sfb++) {
          
          /* Is this scale factor band above count1 for the right channel? */
                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb] * 3 >= count1[1 * 2 + gr]) {
            
            /* Perform the intensity stereo processing */
                  stereo_short_III(is, scalefac_s, gr, sfb, samplingFrequency);
                }
              }
            } /* end else (only short blocks) */
          } else {			/* Only long blocks */
            
            for (int sfb = 0; sfb < 21; sfb++) {
        
        /* Is this scale factor band above count1 for the right channel? */
              if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb] >= count1[1 * 2 + gr]) {

          /* Perform the intensity stereo processing */
                stereo_long_III(is, scalefac_l, gr, sfb, samplingFrequency);
              }
            }
          } /* end else (only long blocks) */
        } /* end if (intensity_stereo processing) */
      }
      
      for (int ch = 0; ch < stereo; ch++) {
        
        // antialiasing ==============================================
        
        /* No antialiasing is done for short blocks */
        if (!((win_switch_flag[ch * 2 + gr] == 1) &&
                (block_type[ch * 2 + gr] == 2) &&
                (mixed_block_flag[ch * 2 + gr]) == 0)) {
          
          int sblim;

  /* Setup the limit for how many subbands to transform */
          if ((win_switch_flag[ch * 2 + gr] == 1) &&
                  (block_type[ch * 2 + gr] == 2) &&
                  (mixed_block_flag[ch * 2 + gr]) == 1) {
            sblim = 2;
          } else {
            sblim = 32;
          }

  /* Do the actual antialiasing */
          for (int sb = 1; sb < sblim; sb++) {
            for (int i = 0; i < 8; i++) {
              int li = 18 * sb - 1 - i;
              int ui = 18 * sb + i;
              float lb = is[ch * 2 * 576 + gr * 576 + li] * CS_ALIASING_LAYER_III[i] - is[ch * 2 * 576 + gr * 576 + ui] * CA_ALIASING_LAYER_III[i];
              float ub = is[ch * 2 * 576 + gr * 576 + ui] * CS_ALIASING_LAYER_III[i] + is[ch * 2 * 576 + gr * 576 + li] * CA_ALIASING_LAYER_III[i];
              is[ch * 2 * 576 + gr * 576 + li] = lb;
              is[ch * 2 * 576 + gr * 576 + ui] = ub;
            }
          }
        }
        // hybrid synthesis ===========================================
        
  /* Loop through all 32 subbands */
        for (int sb = 0; sb < 32; sb++) {
          
          int bt;

    /* Determine blocktype for this subband */
          if ((win_switch_flag[ch * 2 + gr] == 1) &&
                  (mixed_block_flag[ch * 2 + gr] == 1) && (sb < 2)) {
            bt = 0;			/* Long blocks in first 2 subbands */
          } else {
            bt = block_type[ch * 2 + gr];
          }
          
          float[] rawout = new float[36];
          
          // ----
    /* Do the inverse modified DCT and windowing */
          // MPG_IMDCT_Win(& (is[ch * 2 + gr][sb * 18]), rawout, bt);
          
          int offset = ch * 2 * 576 + gr * 576 + sb * 18;
  
          if (bt == 2) {
            for (int j = 0; j < 3; j++) {
              for (int p = 0; p < 12; p++) {
                float sum = 0;
                for (int m = 0; m < 6; m++) {
                  sum += is[offset + j+3*m] * COS_12_LAYER_III[m * 12 + p];
                }
                rawout[6*j+p+6] += sum * IMDCT_WINDOW_LAYER_III[bt * 36 + p];
              }
            }
          } else {
            for (int p = 0; p < 36; p++) {
              float sum = 0;
              for (int m = 0; m < 18; m++) {
                sum += is[offset + m] * COS_36_LAYER_III[m * 36 + p];
              }
              rawout[p] = sum * IMDCT_WINDOW_LAYER_III[bt * 36 + p];
            }
          }
          
          

    /* Overlapp add with stored vector into main_data vector */
          for (int i = 0; i < 18; i++) {
            
            is[ch * 2 * 576 + gr * 576 + sb * 18 + i] = rawout[i] + store[ch * 32 * 18 + sb * 18 + i];
            store[ch * 32 * 18 + sb * 18 + i] = rawout[i + 18];
          } /* end for (i... */
        } /* end for (sb... */
        
        
        // frequency inversion ================================================
        
        for (int sb = 1; sb < 32; sb += 2) {
          for (int i = 1; i < 18; i += 2) {
            is[ch * 2 * 576 + gr * 576 + sb * 18 + i] = -is[ch * 2 * 576 + gr * 576 + sb * 18 + i];
          }
        }
        
        
        // polyphase subband synthesis
        
        float[] u = new float[512];
        float[] s = new float[32];
        
          /* Loop through the 18 samples in each of the 32 subbands */
        for (int ss = 0; ss < 18; ss++) {
  
          for (int i = 1023; i > 63; i--)  /* Shift up the V vector */ {
            v[ch * 1024 + i] = v[ch * 1024 + i - 64];
          }

    /* Copy the next 32 time samples to a temp vector */
          for (int i = 0; i < 32; i++) {
            s[i] = is[ch * 2 * 576 + gr * 576 + i * 18 + ss];
          }
          
          for (int i = 0; i < 64; i++) { /* Matrix multiply input with n_win[][] matrix */
            float sum = 0.0f;
            for (int j = 0; j < 32; j++) {
              sum += SYNTH_WINDOW_TABLE_LAYER_III[i * 32 + j] * s[j];
            }
            v[ch * 1024 + i] = sum;
          } /* end for(i... */
    
    /* Build the U vector */
          for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 32; j++) {
              u[i * 64 + j] = v[ch * 1024 + i * 128 + j];
              u[i * 64 + j + 32] = v[ch * 1024 + i * 128 + j + 96];
            }
          } /* end for (i... */

    /* Window by u_vec[i] with g_synth_dtbl[i] */
          for (int i = 0; i < 512; i++) {
            u[i] *= DI_COEFFICIENTS[i];
          }

    /* Calculate 32 samples and store them in the outdata vector */
          for (int i = 0; i < 32; i++) {
            float sum = 0.0f;
            for (int j = 0; j < 16; j++) {
              sum += u[j * 32 + i];
            }
      
      /* sum now contains time sample 32*ss+i. Convert to 16-bit signed int */
            int samp = (int) (sum * 32767.0f);
            if (samp > 32767) {
              samp = 32767;
            } else if (samp < -32767) {
              samp = -32767;
            }
            samp &= 0xffff;

            if (stereo > 1) {
              soundData.samplesBuffer[gr * 18 * 32 * 2 * 2 + ss * 32 * 2 * 2 + i * 2 * 2 + ch * 2] = (byte) samp;
              soundData.samplesBuffer[gr * 18 * 32 * 2 * 2 + ss * 32 * 2 * 2 + i * 2 * 2 + ch * 2 + 1] = (byte) (samp >>> 8);
            } else {
              soundData.samplesBuffer[gr * 18 * 32 * 2 + ss * 32 * 2 + i * 2] = (byte) samp;
              soundData.samplesBuffer[gr * 18 * 32 * 2 + ss * 32 * 2 + i * 2 + 1] = (byte) (samp >>> 8);
            }
          } /* end for (i... */
        } /* end for (ss... */
      }
    }
  }
  
  private static void stereo_short_III(float[] is, int[] scalefac_s, int gr, int sfb, int samplingFrequency) {
  /* The window length */
    int win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb];
  
  /* The three windows within the band has different scalefactors */
    for (int win = 0; win < 3; win++) {
      
      int is_pos;

    /* Check that ((is_pos[sfb]=scalefac) != 7) => no intensity stereo */
      if ((is_pos = scalefac_s[0 * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win]) != 7) {
        
        int sfb_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 23 + sfb] * 3 + win_len * win;
        int sfb_stop = sfb_start + win_len;
        
        float is_ratio_l;
        float is_ratio_r;
        
      /* tan((6*PI)/12 = PI/2) needs special treatment! */
        if (is_pos == 6) {
          is_ratio_l = 1.0f;
          is_ratio_r = 0.0f;
        } else {
          is_ratio_l = IS_RATIOS_LAYER_III[is_pos] / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
          is_ratio_r = 1.0f / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
        }
      
      /* Now decode all samples in this scale factor band */
        for (int i = sfb_start; i < sfb_stop; i++) {
          is[0 * 2 * 576 + gr * 576 + i] *= is_ratio_l;
          is[1 * 2 * 576 + gr * 576 + i] *= is_ratio_r;
        }
      } /* end if (not illegal is_pos) */
    } /* end for (win... */
  }
  
  private static void stereo_long_III(float[] is, int[] scalefac_l, int gr, int sfb, int samplingFrequency) {
    int is_pos;
      /* Check that ((is_pos[sfb]=scalefac) != 7) => no intensity stereo */
    if ((is_pos = scalefac_l[0 * 2 * 21 + gr * 21 + sfb]) != 7) {
      
      int sfb_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb];
      int sfb_stop = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * (23 + 14) + 0 + sfb + 1];
      
      float is_ratio_l;
      float is_ratio_r;

    /* tan((6*PI)/12 = PI/2) needs special treatment! */
      if (is_pos == 6) {
        is_ratio_l = 1.0f;
        is_ratio_r = 0.0f;
      } else {
        is_ratio_l = IS_RATIOS_LAYER_III[is_pos] / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
        is_ratio_r = 1.0f / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
      }
      
    /* Now decode all samples in this scale factor band */
      for (int i = sfb_start; i < sfb_stop; i++) {
        is[0 * 2 * 576 + gr * 576 + i] *= is_ratio_l;
        is[1 * 2 * 576 + gr * 576 + i] *= is_ratio_r;
      }
    }
  }
  
  private static void requantize_short_III(int gr, int ch, int[] scalefac_scale, int[] subblock_gain, int[] global_gain, int[] scalefac_s, float[] is, int is_pos, int sfb, int win) {
    
    float sf_mult = scalefac_scale[ch * 2 + gr] != 0 ? 1.0f : 0.5f;
    
    float tmp1;
    
    if (sfb < 12) {
      tmp1 = (float) Math.pow(2, -(sf_mult * scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win]));
    } else {
      tmp1 = 1.0f;
    }
    
    float tmp2 = (float) Math.pow(2, 0.25f * (global_gain[ch * 2 + gr] - 210.0f -
            8.0f * (subblock_gain[ch * 2 * 3 + gr * 3 + win])));
    
    float tmp3;
    if (is[ch * 2 * 576 + gr * 576 + is_pos] < 0.0) {
      tmp3 = -POWTAB_LAYER_III[(int) -is[ch * 2 * 576 + gr * 576 + is_pos]];
    } else {
      tmp3 = POWTAB_LAYER_III[(int) is[ch * 2 * 576 + gr * 576 + is_pos]];
    }
    
    is[ch * 2 * 576 + gr * 576 + is_pos] = tmp1 * tmp2 * tmp3;
  }
  
  private static void requantize_long_III(int gr, int ch, int[] scalefac_scale, int[] preflag, int[] global_gain, int[] scalefac_l, float[] is, int is_pos, int sfb) {
    
    
    float sf_mult = scalefac_scale[ch * 2 + gr] != 0 ? 1.0f : 0.5f;
    
    // TODO table cache Math.pow 2 ? faster alternative?
    
    float tmp1;
    
    if (sfb < 21) {
      float pf_x_pt = preflag[ch * 2 + gr] * REQUANTIZE_LONG_PRETAB_LAYER_III[sfb];
      
      tmp1 = (float) Math.pow(2, -(sf_mult * (scalefac_l[ch * 2 * 21 + gr * 21 + sfb] + pf_x_pt)));
    } else {
      tmp1 = 1.0f;
    }
    
    float tmp2 = (float) Math.pow(2, 0.25f * (global_gain[ch * 2 + gr] - 210));
    
    float tmp3;
    if (is[ch * 2 * 576 + gr * 576 + is_pos] < 0.0) {
      tmp3 = -POWTAB_LAYER_III[(int) -is[ch * 2 * 576 + gr * 576 + is_pos]];
    } else {
      tmp3 = POWTAB_LAYER_III[(int) is[ch * 2 * 576 + gr * 576 + is_pos]];
    }
    
    is[ch * 2 * 576 + gr * 576 + is_pos] = tmp1 * tmp2 * tmp3;
  }
  
  private static void huffman_III(MainDataReader mainDataReader, int table_num, int[] array) {
    /* Table entries are 16 bits each:
   * Bit(s)
   * 15     hit/miss (1/0)
   * 14-13  codeword size (1-4 bits)
   * 7-0    codeword (bits 4-7=x, 0-3=y) if hit
   * 12-0   start offset of next table if miss
   */
    
    int point = 0;
    int currpos;
  
  /* Check for empty tables */
    if (HUFFMAN_TREELEN_LAYER_III[table_num] == 0) {
      array[0] = array[1] = array[2] = array[3] = 0;
      return;
    }
    
    int treelen = HUFFMAN_TREELEN_LAYER_III[table_num];
    int linbits = HUFFMAN_LINBITS_LAYER_III[table_num];
    int offset = HUFFMAN_TABLE_OFFSET_LAYER_III[table_num];
    
    int error = 1;
    int bitsleft = 32;
    
    do {   /* Start reading the Huffman code word,bit by bit */
    /* Check if we've matched a code word */
      if ((HUFFMAN_TABLE_LAYER_III[offset + point] & 0xff00) == 0) {
        error = 0;
        array[0] = (HUFFMAN_TABLE_LAYER_III[offset + point] >> 4) & 0xf;
        array[1] = HUFFMAN_TABLE_LAYER_III[offset + point] & 0xf;
        break;
      }
      if (read(mainDataReader, 1) != 0) { /* Go right in tree */
        while ((HUFFMAN_TABLE_LAYER_III[offset + point] & 0xff) >= 250) {
          point += HUFFMAN_TABLE_LAYER_III[offset + point] & 0xff;
        }
        point += HUFFMAN_TABLE_LAYER_III[offset + point] & 0xff;
      } else { /* Go left in tree */
        while ((HUFFMAN_TABLE_LAYER_III[offset + point] >> 8) >= 250) {
          point += HUFFMAN_TABLE_LAYER_III[offset + point] >> 8;
        }
        point += HUFFMAN_TABLE_LAYER_III[offset + point] >> 8;
      }
    } while ((--bitsleft > 0) && (point < treelen));
    if (error != 0) {  /* Check for error. */
      array[0] = array[1] = 0;
      throw new IllegalStateException("Illegal Huff code in data. bleft = %d,point = %d. tab = %d." +
              bitsleft + " " + point + " " + table_num);
    }
  /* Process sign encodings for quadruples tables. */
    if (table_num > 31) {
      array[2] = (array[1] >> 3) & 1;
      array[3] = (array[1] >> 2) & 1;
      array[0] = (array[1] >> 1) & 1;
      array[1] = array[1] & 1;
      
      if (array[2] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[2] = -array[2];
        }
      }
      if (array[3] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[3] = -array[3];
        }
      }
      if (array[0] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[0] = -array[0];
        }
      }
      if (array[1] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[1] = -array[1];
        }
      }
    } else {
    /* Get linbits */
      if ((linbits > 0) && (array[0] == 15)) {
        array[0] += read(mainDataReader, linbits);
      }

    /* Get sign bit */
      if (array[0] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[0] = -array[0];
        }
      }

    /* Get linbits */
      if ((linbits > 0) && (array[1] == 15)) {
        array[1] += read(mainDataReader, linbits);
      }

    /* Get sign bit */
      if (array[1] > 0) {
        if (read(mainDataReader, 1) == 1) {
          array[1] = -array[1];
        }
      }
    }
  }
  
  private static float[] samples_I(Buffer buffer, int stereo, int bound) throws IOException {
    if (bound < 0) {
      bound = 32;
    }
    int[] allocation = new int[32 - bound];
    int[] allocationChannel = new int[stereo * bound];
    int[] scalefactorChannel = new int[stereo * 32];
    float[] sampleDecoded = new float[stereo * 32 * 12];
    for (int sb = 0; sb < bound; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        allocationChannel[ch * bound + sb] = read(buffer, 4);
      }
    }
    for (int sb = bound; sb < 32; sb++) {
      allocation[sb - bound] = read(buffer, 4);
    }
    for (int sb = 0; sb < bound; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocationChannel[ch * bound + sb] != 0) {
          scalefactorChannel[ch * 32 + sb] = read(buffer, 6);
        }
      }
    }
    for (int sb = bound; sb < 32; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocation[sb - bound] != 0) {
          scalefactorChannel[ch * 32 + sb] = read(buffer, 6);
        }
      }
    }
    for (int s = 0; s < 12; s++) {
      for (int sb = 0; sb < bound; sb++) {
        for (int ch = 0; ch < stereo; ch++) {
          int n = allocationChannel[ch * bound + sb];
          if (n == 0) {
            sampleDecoded[ch * 32 * 12 + sb * 12 + s] = 0;
          } else {
            int read = read(buffer, n + 1);
            float fraction = 0;
            if (((read >> n) & 0b1) == 0) {
              fraction = -1;
            }
            fraction += (float) (read & ((0b1 << n) - 1)) / (0b1 << n) + 1f / (0b1 << n);
            sampleDecoded[ch * 32 * 12 + sb * 12 + s] = SCALEFACTORS[scalefactorChannel[ch * 32 + sb]] * PRE_FRACTOR_LAYER_I[n + 1] * fraction;
          }
        }
      }
      for (int sb = bound; sb < 32; sb++) {
        int n = allocationChannel[sb - bound];
        if (n == 0) {
          sampleDecoded[0 * 32 * 12 + sb * 12 + s] = sampleDecoded[1 * 32 * 12 + sb * 12 + s] = 0;
        } else {
          int read = read(buffer, n + 1);
          float fraction = 0;
          if (((read >> n) & 0b1) == 0) {
            fraction = -1;
          }
          fraction += (float) (read & ((0b1 << n) - 1)) / (0b1 << n) + 1f / (0b1 << n);
          for (int ch = 0; ch < 2; ch++) {
            sampleDecoded[ch * 32 * 12 + sb * 12 + s] = SCALEFACTORS[scalefactorChannel[ch * 32 + sb]] * PRE_FRACTOR_LAYER_I[n + 1] * fraction;
          }
        }
      }
    }
    return sampleDecoded;
  }
  
  private static float[] samples_II(Buffer buffer, int stereo, int bound, int bitrate, int frequency) throws IOException {
    int sbIndex = 0;
    if (frequency != 48000 && (bitrate >= 96000 || bitrate == 0)) {
      sbIndex = 1;
    } else if (frequency != 32000 && (bitrate > 0 && bitrate <= 48000)) {
      sbIndex = 2;
    } else if (frequency == 32000 && (bitrate > 0 && bitrate <= 48000)) {
      sbIndex = 3;
    }
    int sbLimit = SB_LIMIT[sbIndex];
    if (bound < 0) {
      bound = sbLimit;
    }
    int[] allocation = new int[sbLimit - bound];
    int[] allocationChannel = new int[stereo * bound];
    int[] scfsi = new int[stereo * sbLimit];
    int[] scalefactorChannel = new int[stereo * sbLimit * 3];
    float[] sampleDecoded = new float[stereo * 32 * 12 * 3];
    for (int sb = 0; sb < bound; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        allocationChannel[ch * bound + sb] = read(buffer, NBAL[sbIndex][sb]);
      }
    }
    for (int sb = bound; sb < sbLimit; sb++) {
      allocation[sb - bound] = read(buffer, NBAL[sbIndex][sb]);
    }
    for (int sb = 0; sb < bound; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocationChannel[ch * bound + sb] != 0) {
          scfsi[ch * sbLimit + sb] = read(buffer, 2);
        }
      }
    }
    for (int sb = bound; sb < sbLimit; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocation[sb - bound] != 0) {
          scfsi[ch * sbLimit + sb] = read(buffer, 2);
        }
      }
    }
    for (int sb = 0; sb < bound; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocationChannel[ch * bound + sb] != 0) {
          int offset = ch * sbLimit * 3 + sb * 3;
          if (scfsi[ch * sbLimit + sb] == 0) {
            scalefactorChannel[offset + 0] = read(buffer, 6);
            scalefactorChannel[offset + 1] = read(buffer, 6);
            scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 1) {
            scalefactorChannel[offset + 0] = scalefactorChannel[offset + 1] = read(buffer, 6);
            scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 2) {
            scalefactorChannel[offset + 0] = scalefactorChannel[offset + 1] = scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 3) {
            scalefactorChannel[offset + 0] = read(buffer, 6);
            scalefactorChannel[offset + 1] = scalefactorChannel[offset + 2] = read(buffer, 6);
          }
        }
      }
    }
    for (int sb = bound; sb < sbLimit; sb++) {
      for (int ch = 0; ch < stereo; ch++) {
        if (allocation[sb - bound] != 0) {
          int offset = ch * sbLimit * 3 + sb * 3;
          if (scfsi[ch * sbLimit + sb] == 0) {
            scalefactorChannel[offset + 0] = read(buffer, 6);
            scalefactorChannel[offset + 1] = read(buffer, 6);
            scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 1) {
            scalefactorChannel[offset + 0] = scalefactorChannel[offset + 1] = read(buffer, 6);
            scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 2) {
            scalefactorChannel[offset + 0] = scalefactorChannel[offset + 1] = scalefactorChannel[offset + 2] = read(buffer, 6);
          } else if (scfsi[ch * sbLimit + sb] == 3) {
            scalefactorChannel[offset + 0] = read(buffer, 6);
            scalefactorChannel[offset + 1] = scalefactorChannel[offset + 2] = read(buffer, 6);
          }
        }
      }
    }
    for (int gr = 0; gr < 12; gr++) {
      for (int sb = 0; sb < bound; sb++) {
        for (int ch = 0; ch < stereo; ch++) {
          int n = allocationChannel[ch * bound + sb];
          int offset = ch * 32 * 12 * 3 + sb * 12 * 3 + gr * 3;
          if (n == 0) {
            sampleDecoded[offset] = sampleDecoded[offset + 1] = sampleDecoded[offset + 2] = 0;
          } else {
            int index = QUANTIZATION_INDEX_LAYER_II[sbIndex][sb][n - 1];
            int[] sampleInt = new int[3];
            int sampleBits = BITS_LAYER_II[index];
            int nlevels = NLEVELS[index];
            if (GROUPING_LAYER_II[index]) {
              int samplecode = read(buffer, sampleBits);
              sampleInt[0] = samplecode % nlevels;
              samplecode /= nlevels;
              sampleInt[1] = samplecode % nlevels;
              samplecode /= nlevels;
              sampleInt[2] = samplecode % nlevels;
            } else {
              sampleInt[0] = read(buffer, sampleBits);
              sampleInt[1] = read(buffer, sampleBits);
              sampleInt[2] = read(buffer, sampleBits);
            }
            int msb = 0;
            while ((0b1 << msb) <= nlevels) {
              msb++;
            }
            msb--;
            for (int i = 0; i < 3; i++) {
              float sample = 0;
              if (((sampleInt[i] >> msb) & 0b1) == 0) {
                sample = -1;
              }
              sample += (float) (sampleInt[i] & ((0b1 << msb) - 1)) / (0b1 << msb);
              sample += D_LAYER_II[index];
              sample *= C_LAYER_II[index];
              sample *= SCALEFACTORS[scalefactorChannel[ch * sbLimit * 3 + sb * 3 + gr / 4]];
              sampleDecoded[offset + i] = sample;
            }
          }
        }
      }
      for (int sb = bound; sb < sbLimit; sb++) {
        int n = allocation[sb - bound];
        int offset = sb * 12 * 3 + gr * 3;
        if (n == 0) {
          for (int ch = 0; ch < stereo; ch++) {
            sampleDecoded[offset + ch * 32 * 12 * 3] = sampleDecoded[offset + ch * 32 * 12 * 3 + 1] = sampleDecoded[offset + ch * 32 * 12 * 3 + 2] = 0;
          }
        } else {
          int index = QUANTIZATION_INDEX_LAYER_II[sbIndex][sb][n - 1];
          int[] sampleInt = new int[3];
          int sampleBits = BITS_LAYER_II[index];
          int nlevels = NLEVELS[index];
          if (GROUPING_LAYER_II[index]) {
            int samplecode = read(buffer, sampleBits);
            sampleInt[0] = samplecode % nlevels;
            samplecode /= nlevels;
            sampleInt[1] = samplecode % nlevels;
            samplecode /= nlevels;
            sampleInt[2] = samplecode % nlevels;
          } else {
            sampleInt[0] = read(buffer, sampleBits);
            sampleInt[1] = read(buffer, sampleBits);
            sampleInt[2] = read(buffer, sampleBits);
          }
          int msb = 0;
          while ((0b1 << msb) <= nlevels) {
            msb++;
          }
          msb--;
          for (int i = 0; i < 3; i++) {
            float sample = 0;
            if (((sampleInt[i] >> msb) & 0b1) == 0) {
              sample = -1;
            }
            sample += (float) (sampleInt[i] & ((0b1 << msb) - 1)) / (0b1 << msb);
            sample += D_LAYER_II[index];
            sample *= C_LAYER_II[index];
            for (int ch = 0; ch < stereo; ch++) {
              sampleDecoded[offset + ch * 32 * 12 * 3 + i] = sample * SCALEFACTORS[scalefactorChannel[ch * sbLimit * 3 + sb * 3 + gr / 4]];
            }
          }
        }
      }
    }
    return sampleDecoded;
  }
  
  private static void synth(SoundData soundData, float[] samples, int[] synthOffset, float[] synthBuffer, int stereo) {
    int size = samples.length / stereo / 32;
    float[] pcm = new float[size * 32 * stereo];
    for (int ch = 0; ch < stereo; ch++) {
      for (int s = 0; s < size; s++) {
        synthOffset[ch] = (synthOffset[ch] - 64) & 0x3ff;
        for (int i = 0; i < 64; i++) {
          float sum = 0;
          for (int k = 0; k < 32; k++) {
            sum += NIK_COEFFICIENTS[i * 32 + k] * samples[ch * 32 * size + k * size + s];
          }
          synthBuffer[ch * 1024 + synthOffset[ch] + i] = sum;
        }
        for (int j = 0; j < 32; j++) {
          float sum = 0;
          for (int i = 0; i < 16; i++) {
            int k = j + (i << 5);
            sum += DI_COEFFICIENTS[k] * synthBuffer[ch * 1024 + ((synthOffset[ch] + (k + (((i + 1) >> 1) << 6))) & 0x3FF)];
          }
          pcm[s * 32 * stereo + j * stereo + ch] = sum;
        }
      }
    }
    if(soundData.samplesBuffer == null)
      soundData.samplesBuffer = new byte[size * 32 * stereo * 2];
    for (int i = 0; i < size * 32 * stereo; i++) {
      int sample = (int) (pcm[i] * 32768);
      if (sample >= 32768) {
        sample = 32767;
      } else if (sample < -32768) {
        sample = -32768;
      }
      soundData.samplesBuffer[i * 2] = (byte) sample;
      soundData.samplesBuffer[i * 2 + 1] = (byte) (sample >>> 8);
    }
  }
  
  private static int read(MainDataReader reader, int bits) {
    int number = 0;
    while (bits > 0) {
      int advance = Integer.min(bits, 8 - reader.current);
      bits -= advance;
      reader.current += advance;
      number |= ((reader.array[reader.index] >>> (8 - reader.current)) & (0xFF >>> (8 - advance))) << bits;
      if (reader.current == 8) {
        reader.current = 0;
        reader.index++;
      }
    }
    return number;
  }
  
  private static int read(Buffer buffer, int bits) throws IOException {
    int number = 0;
    while (bits > 0) {
      int advance = Integer.min(bits, 8 - buffer.current);
      bits -= advance;
      buffer.current += advance;
      if (bits != 0 && buffer.lastByte == -1) {
        throw new EOFException("Unexpected EOF reached in MPEG data");
      }
      number |= ((buffer.lastByte >>> (8 - buffer.current)) & (0xFF >>> (8 - advance))) << bits;
      if (buffer.current == 8) {
        buffer.current = 0;
        buffer.lastByte = buffer.in.read();
      }
    }
    return number;
  }
  
  private static void readInto(Buffer buffer, byte[] array, int offset, int length) throws IOException {
    if (buffer.current != 0) // TODO remove
    {
      throw new IllegalStateException("buffer current is " + buffer.current);
    }
    if (length == 0) {
      return;
    }
    if (buffer.lastByte == -1) {
      throw new EOFException("Unexpected EOF reached in MPEG data");
    }
    array[offset] = (byte) buffer.lastByte;
    int read = 1;
    while (read < length) {
      read += buffer.in.read(array, offset + read, length - read);
    }
    buffer.lastByte = buffer.in.read();
  }
  
  private static final class MainDataReader {
    public final byte[] array;
    public int top = 0;
    public int index = 0;
    public int current = 0;
    
    public MainDataReader(byte[] array) {
      this.array = array;
    }
  }
  
  private static final class Buffer {
    public final InputStream in;
    public int current = 0;
    public int lastByte = -1;
    
    public Buffer(InputStream inputStream) {
      in = inputStream;
    }
  }
  
  static final class SoundData {
    private Buffer buffer;
  
    int frequency = -1;
    int stereo = -1;
  
    private int[] synthOffset;
    private float[] synthBuffer;
  
    private byte[] mainData;
    private MainDataReader mainDataReader;
  
    private float[] store;
    private float[] v;
    
    byte[] samplesBuffer;
  }
}
